/*****************************************************************************

                           HEADER FILE FOR NCSSNET.C

    $Id: ncssnet.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _NCSSNET_H_
#define _NCSSNET_H_

/*
#if 99999
#include "common.h"
#include "comlib.h"
#include "ncsdef.h"
#include "ncsslib.fdl"
#include "ncssstrc.h"
#include "ncssscf.h"
#endif
*/

/* SYSTEM DEFINED GLOBAL VARIABLES */
#define  TIME          NcsTime
double          NCS_TIME;
int             CN;
int             PRECN;
int             POSCN;
double          POSOUT;

/* GLOBAL VARIABLES */

/* input variable */
double          INPUT;
double          NET[NCS_NNET];

/* mode & timer */
char            ncsg_mode;
double          ncsg_endtime;
double          ncsg_calstep;
double          ncsg_strstep;
long            ncsg_enditer;
long            ncsg_striter;

/* module information table */
int             ncsg_ntout;
int             ncsg_ntxin;
int             ncsg_ntobs;
int             ncsg_ncout[NCS_OUT_NT];
int             ncsg_ncxin[NCS_XIN_NT];
int             ncsg_ncobs[NCS_OBS_NT];

/* memory address table */
double         *ncsm_outptr[NCS_OUT_NT];
double         *ncsm_subptr[NCS_OUT_NT];
double         *ncsm_xinptr[NCS_XIN_NT];
double         *ncsm_obsptr[NCS_OBS_NT];

/* module name table & address table */
char            ncsg_outtbl[NCS_OUT_NT + 1][NAME_SIZE];
char           *ncsg_outtblptr[NCS_OUT_NT + 1];
char            ncsg_xintbl[NCS_XIN_NT + 1][NAME_SIZE];
char           *ncsg_xintblptr[NCS_XIN_NT + 1];
char            ncsg_obstbl[NCS_OBS_NT + 1][NAME_SIZE];
char           *ncsg_obstblptr[NCS_OBS_NT + 1];

/* EXTERNAL INPUT INFORMATION */
int             ncsg_nxinc;
struct xin_info ncsg_xindata[NCS_XIN_MAX];
struct xfp_info ncsg_xfpdata[NCS_XIN_MAX];
double          (*ncsg_xinfaddr[NCS_XF_MAX]) ();

/* NCS LIBRARY */
#define  ramp(x1,x2,x3)    ncsl_ramp(x1,x2,x3,ncsg_dummy1,ncsg_dummy2)
double          ncsg_dummy1, ncsg_dummy2;

/* STORING DATA */
int             ncsg_nstrd;
char            ncsg_strflg;
char            ncsg_strfile[NCS_DATA_FNAME];
double          **ncsg_strdptr;
int		*ncsg_out_buffnum;
int             *ncsg_out_buffdim;

/* GRAPH MONITER */
char            ncsg_monimode;
double         *ncsg_gmoniptr[NCS_MONI_NVAR];
double         *ncsg_vmoniptr[NCS_MONI_NVAR];
int             ncsg_ngmoni;
int             ncsg_nvmoni;


/* For Adaptive Integlation */
int             ncsg_cell;	   /* Number of Cell       */
int             ncsg_neqn;	   /* Number of equation   */
double          ncsg_relerr;       /* Relative Error       */
char            ncsg_intg_method;  /* Integration Method   */

/* For Buffer input */
int             ncsg_cdpoint;

PList ncsg_buff_info;
PLPointer ncsg_buff_info_p;
int exbuff_num;

/* For Delay */
char            ncsg_delay_flag;
double          ncsg_dlytime[NCS_DLY_NT];
double          ncsg_dlyinit[NCS_DLY_NT];
int             ncsg_qsize[NCS_DLY_NT];
char            ncsg_dlyinit_flg[NCS_DLY_NT];

#endif /* _NCSSNET_H_ */
