/*****************************************************************************

 	Header file of Functions to Control of Pointer's List           
  		      for NCS Module to SATELLITE                     

    $Id: plist.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _PLIST_H_
#define _PLIST_H_

#define  PL_ERROR_NODISP   0
#define  PL_ERROR_DISP     1
#define  PL_ERROR_ALLDISP  2

#ifndef TRUE
#define  TRUE   (1)
#endif
#ifndef FALSE
#define  FALSE  (0)
#endif

struct PLIST {
  void		*member;
  struct PLIST 	*next;
};

typedef struct PLIST * PList;
typedef struct PLIST * PLPointer;
typedef void * PLMember;

extern PList 	 plist_create		_ANSI_ARGS_(( int arg ));
extern int 	 plist_destroy		_ANSI_ARGS_(( PList list ));
extern PLPointer plist_advance		_ANSI_ARGS_(( PList current, 
						      PLPointer pointer ));
extern PLPointer plist_retreat		_ANSI_ARGS_(( PList current, 
						      PLPointer pointer ));
extern PLMember  plist_read_data	_ANSI_ARGS_(( PList current, 
						      PLPointer pointer ));
extern PLPointer plist_write_data 	_ANSI_ARGS_(( PList current, 
						      PLPointer pointer, 
						      PLMember data ));
extern PLPointer plist_insert		_ANSI_ARGS_(( PList current, 
						      PLPointer pointer, 
						      PLMember data ));
extern PLPointer plist_delete		_ANSI_ARGS_(( PList current, 
						      PLPointer pointer ));
extern int 	 plist_number_cell	_ANSI_ARGS_(( PList current ));
extern PLPointer plist_go_top		_ANSI_ARGS_(( PList current ));
extern PLPointer plist_go_end		_ANSI_ARGS_(( PList current ));
extern PLPointer plist_go_nth		_ANSI_ARGS_(( PList current, int n ));

#endif /* _PLIST_H_ */
