/*****************************************************************************
  
  			Function to append file

    $Id: fappend.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#include "common.h"
#include "comlib.h"

#ifdef SEEK_SET
#define FILE_TOP  0L,SEEK_SET
#define FILE_BTM  0L,SEEK_END
#else
#define FILE_TOP  0L,(int)0
#define FILE_BTM  0L,(int)2
#endif

FILE  *fappend( fp1, fp2 )
FILE	*fp1, *fp2;
{
	long	offset;
	int     f1, f2;
	char    ch;

	/* set file pointer at the beginning of file */
	offset = 0L;

	if ( ( f1 = fseek(fp1, FILE_BTM) ) != SUCCESS ) {
	  fprintf( stderr, "File append : File Seek Error.\n" );
	  exit(ERROR);
	}

	if ( (f2 = fseek(fp2, FILE_TOP)) != SUCCESS ) {
	  fprintf( stderr, "File append : File Seek Error.\n" );
	  exit(ERROR);
	}


	do {
	  if ((ch = fgetc(fp2)) == EOF) {
	    if (ferror(fp2) != SUCCESS) {
	      fprintf( stderr, "File append : Read Error.\n" );
	      exit(ERROR);
	    }	/* if */
	  }	/* if */
	  else {
	    if (fputc(ch, fp1) == EOF) {
	      if (ferror(fp1) != SUCCESS) {
		fprintf( stderr, "File append : Write Error.\n" );
		exit(ERROR);
	      }	/* if */
	    }	/* if */
	  }	/* else */
	} while (ch != EOF);

	return( fp1 );

}
