/*****************************************************************************

                         FUNCTIONS OF GETTING A NUMBER

    $Id: numget.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <ctype.h>
#include "common.h"
#include "comlib.h"

static int 	expntget	_ANSI_ARGS_(( char *expnt, int size, 
					      char *buffer, int *buffptr ));

/*****************************************************************************
FUNCTION USINTGET
******************************************************************************
EXTRACTING AN UNSIGNED INTEGER

usint   : storage buffer for a string ;
size    : size of 'usint' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;
mode    : mode ( MODE0:search for head , MODE1:not search for head ) ;

WARNING  : size of 'usint' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 <= counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
usintget( usint, size, buffer, buffptr, mode )
char   usint[], buffer[];
int    *buffptr, size, mode;
{
  	int    counter = 0;

	/* detecting head */
	if( mode == MODE0 ){
	  while( isdigit( (int) buffer[*buffptr] ) == FALSE 
		 && buffer[*buffptr] != EOS ){
	    (*buffptr)++;
	  }
	} else {
	  if( isdigit( (int) buffer[*buffptr] ) == FALSE ){
	    return( ERRORM1 );
	  }
	}
 
	/* extracting an unsigned integer */
	while( counter < size && buffer[*buffptr] != EOS ){
	  /* storing digit */
	  if ( isdigit( (int) buffer[*buffptr] ) != FALSE ){
	    usint[counter++] = buffer[(*buffptr)++];
	  } else {
	    /* done */
	    break;
	  }
	}/* while */

	usint[counter] = EOS;

	return( counter );

}/* usintget() */


/*****************************************************************************
FUNCTION USREALGET
******************************************************************************
EXTRACTING AN UNSIGNED REAL

usreal  : storage buffer for a string ;
size    : size of 'usreal' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;
mode    : mode ( 0:search for head , 1:not search for head ) ;

WARNING  : size of 'usreal' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
usrealget( usreal, size, buffer, buffptr, mode )
char   usreal[], buffer[];
int    *buffptr, size, mode;
{
  	int    counter, ret;

	/* extracting an integer part */
	ret = usintget( usreal , size , buffer , buffptr , mode );
	if( ret > ERROR0 ){
	  counter = ret;
	} else {
	  return( ERRORM1 );
	}

	/* detecting a decimal point */
	if( buffer[*buffptr] == '.' ){
	  if( counter < size ){
	    usreal[counter++] = buffer[(*buffptr)++];
	  } else {
	    goto END;
	  }
	} else {
	  return( ERRORM1 );
	}

	/* extracting the right part of a decimal point */
	ret = usintget( &usreal[counter], ( size - counter ), 
			buffer, buffptr, MODE1 );
	if( ret != ERRORM1 ){
	  counter += ret;
	}

	/* extracting an exponent part */
	ret = expntget( &usreal[counter], (size-counter), buffer, buffptr );
	if( ret != ERRORM1 ){
	  counter += ret;
	}

END:
	usreal[counter] = EOS;

	return( counter );

}/* usrealget() */


/*****************************************************************************
FUNCTION USNUMGET
******************************************************************************
EXTRACTING AN UNSIGNED NUMBER

usnum   : storage buffer for a string ;
size    : size of 'usnum' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;
mode    : mode ( 0:search for head , 1:not search for head ) ;

WARNING  : size of 'usnum' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
usnumget( usnum, size, buffer, buffptr, mode )
char   usnum[], buffer[];
int    *buffptr, size, mode;
{
  	int    counter, ret;

	/* extracting an integer part */
	ret = usintget( usnum, size, buffer, buffptr, mode );
	if( ret > ERROR0 ){
	  counter = ret;
	} else {
	  return( ERRORM1 );
	}

	/* detecting a decimal point */
	if( buffer[*buffptr] == '.' ){
	  if( counter < size ){
	    usnum[counter++] = buffer[(*buffptr)++];
	  } else {
	    goto END;
	  }
	}

	/* extracting the right part of a decimal point */
	ret = usintget( &usnum[counter], (size-counter), 
			buffer, buffptr, MODE1 );
	if( ret != ERRORM1 ){
	  counter += ret;
	}

	/* extracting an exponent part */
	ret = expntget( &usnum[counter], (size-counter), buffer, buffptr );
	if( ret != ERRORM1 ){
	  counter += ret;
	}

END:
	usnum[counter] = EOS;

	return( counter );

}/* usnumget() */


/*****************************************************************************
FUNCTION EXPNTGET
******************************************************************************
EXTRACTING AN EXPONENT PART

expnt   : storage buffer for a string ;
size    : size of 'expnt' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;

WARNING  : size of 'expnt' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

static int 
expntget( expnt, size, buffer, buffptr )
char   expnt[], buffer[];
int    *buffptr, size;
{
  	int    counter = 0, ret;

	/* extracting an exponent part */
	if( buffer[*buffptr] == 'E' || buffer[*buffptr] == 'e' ){
	  if( counter < size ){
	    expnt[counter++] = buffer[(*buffptr)++];
	  } else {
	    return( counter );
	  }
	  if( buffer[*buffptr] == '+' || buffer[*buffptr] == '-' ){
	    if( counter < size ){
	      expnt[counter++] = buffer[(*buffptr)++];
	    } else {
	      return( counter );
	    }
	  }
	  ret = usintget( &expnt[counter], (size-counter), 
			  buffer, buffptr, MODE1 );
	  if( ret != ERRORM1 ){
	    counter += ret;
	  }
	}/* if */

	return( counter );

}/* expntget() */


/*****************************************************************************
FUNCTION CONSTGET
******************************************************************************
EXTRACTING A CONSTANT NUMBER

cstnm   : storage buffer for a string ;
size    : size of 'cstnm' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;
mode    : mode ( MODE0:search for head , MODE1:not search for head ) ;

WARNING  : size of 'cstnm' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
constget( constnt, size, buffer, buffptr, mode )
char   constnt[], buffer[];
int    *buffptr, size, mode;
{
  	int    counter = 0, ret;

	/* detecting of sign */
	if( mode == MODE0 ){
	  while( isdigit( (int) buffer[*buffptr] ) == FALSE &&
		 buffer[*buffptr] != '+' &&
		 buffer[*buffptr] != '-' &&
		 buffer[*buffptr] != EOS ){
	    (*buffptr)++;
	  }
	} else {
	  if ( isdigit( (int) buffer[*buffptr] ) == FALSE &&
	       buffer[*buffptr] != '+' &&
	       buffer[*buffptr] != '-' ){
	    return( ERRORM1 );
	  }
	}
	if ( buffer[*buffptr] == '+' || buffer[*buffptr] == '-' ){
	  if( counter < size ){
	    constnt[counter++] = buffer[(*buffptr)++];
	  } else {
	    goto END;
	  }
	}
 
	/* extracting an unsigned number */
	ret = usnumget( &constnt[counter] , (size-counter), 
			buffer, buffptr, mode );
	if( ret > ERROR0 ){
	  counter += ret;
	} else {
	  return( ERRORM1 );
	}

END:
	constnt[counter] = EOS;

	return( counter );

}/* constget() */
