/*****************************************************************************

                              PART-GET FUNCTIONS

    $Id: partget.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <ctype.h>
#include "common.h"
#include "comlib.h"

/*****************************************************************************
FUNCTION EFRAGET
******************************************************************************
EXTRACTING A SIMPLE EXPRESSION OF THE FOUR RULES OF ARITHMETIC

efrabuff : storage buffer for a simple expression ;
efrasize : size of 'efrabuff' ;
buffer   : source buffer ;
buffptr  : a pointer of 'buffer' ;
mode     : mode ( MODE0:search for head , MODE1:not search for head ) ;

WARNING  : size of 'efrabuff' must be more than 'efrasize'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int efraget( efrabuff , efrasize , buffer , buffptr , mode )
char   efrabuff[] , buffer[];
int    *buffptr , efrasize , mode;
{
  int    ret , counter = 0;

  /* detecting head */
  if ( mode == MODE0 ) {
    while ( isalpha( (int) buffer[*buffptr] ) == FALSE &&
            isdigit( (int) buffer[*buffptr] ) == FALSE &&
            buffer[*buffptr] != EOS ) (*buffptr)++;
  }/* if */

REPEAT:

  /* extracting a simple expression */
  if ( isdigit( (int) buffer[*buffptr] ) != FALSE ) {
    ret = usintget( &efrabuff[counter] , ( efrasize - counter ) , buffer , buffptr , MODE1 );
    if ( ret > ERROR0 ) counter += ret;
    else return( ERRORM1 );
  }/* if */
  else {
    if ( isalpha( (int) buffer[*buffptr] ) != FALSE ) {
      ret = nameget( &efrabuff[counter] , ( efrasize - counter ) , buffer , buffptr , MODE1 );
        if ( ret > ERROR0 ) counter += ret;
        else return( ERRORM1 );
    }/* if */
    else return( ERRORM1 );
  }/* else */

  if ( buffer[*buffptr] == '+' ||
       buffer[*buffptr] == '-' ||
       buffer[*buffptr] == '*' ||
       buffer[*buffptr] == '/' ) {
    if ( counter < efrasize ) {
      efrabuff[counter++] = buffer[(*buffptr)++];
      goto REPEAT;
    }/* if */
  }/* if */

  efrabuff[counter] = EOS;

  return( counter );

}/* efraget() */


/*****************************************************************************
FUNCTION MDLNGET
******************************************************************************
EXTRACTING A MODULE NAME AND A NUMBER OF COMPONENTS

mdlname  : storage buffer for a module name ;
mdlnsize : size of 'mdlname' ;
cmponum  : storage buffer for a component number ;
cmposize : size of 'cmponum' ;
buffer   : source buffer ;
buffptr  : a pointer of 'buffer' ;
mode     : MODE0 : allowed expression for 'cmponum'
           MODE1 : not allowed

WARNING  : size of 'mdlname' must be more than 'mdlnsize'+1,
           and 'cmponum', 'cmposize'+1 ;

return( 0 ) : success ;
return( 1 ) : error ;

MSC Ver.5.1                                      06/08/1989 CODED BY A. ANZAI
*****************************************************************************/

int mdlnget( mdlname , mdlnsize , cmponum , cmposize , buffer , buffptr , mode )
char   mdlname[] , cmponum[] , buffer[];
int    *buffptr , mdlnsize , cmposize , mode;
{
  int    ret;
  extern int nameget();
  extern int efraget();

  /* extracting mdlname */
  ret = nameget( mdlname , mdlnsize , buffer , buffptr , MODE1 );
  if ( ret <= ERROR0 ) return( ERROR );

  if ( buffer[*buffptr] == '(' ) (*buffptr)++;
  else return( ERROR );

  /* extracting cmponum */
  if ( mode == MODE0 ) {
    ret = efraget( cmponum , cmposize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* if */
  else {
    ret = usintget( cmponum , cmposize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* else */

  if ( buffer[*buffptr] == ')' ) (*buffptr)++;
  else return( ERROR );

  return( SUCCESS );

}/* mdlnget() */


/*****************************************************************************
FUNCTION CNTLGET
******************************************************************************
EXTRACTING A CONTROL VARIABE NAME AND ITS RANGE OF VARRIATION

varname  : storage buffer for a control variable name ;
varsize  : size of 'varname' ;
start    : storage buffer for a start value ;
startsize: size of 'start' ;
end      : storage buffer for a end value ;
endsize  : size of 'end' ;
buffer   : source buffer ;
buffptr  : a pointer of 'buffer' ;
mode     : MODE0 : allowed expression for 'cmponum'
           MODE1 : not allowed

WARNING  : size of 'varname' must be more than 'varsize'+1,
           'start' 'startsize'+1 and 'end' 'end'+1 ;

return( 0 ) : success ;
return( 1 ) : error ;

MSC Ver.5.1                                      06/09/1989 CODED BY A. ANZAI
*****************************************************************************/

int cntlget( varname , varsize , start , startsize , end , endsize , buffer , buffptr , mode )
char   varname[] , start[] , end[] , buffer[];
int    *buffptr , varsize , startsize , endsize , mode;
{
  int    ret;
  extern int nameget();
  extern int efraget();

  /* removing a prefix of control variable */
  if ( buffer[*buffptr] == '#' ) (*buffptr)++;
  else return( ERROR );

  /* extracting varname */
  ret = nameget( varname , varsize , buffer , buffptr , MODE1 );
  if ( ret <= ERROR0 ) return( ERROR );

  if ( buffer[*buffptr] == '=' ) (*buffptr)++;
  else return( ERROR );

  /* extracting start */
  if ( mode == MODE0 ) {
    ret = efraget( start , startsize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* if */
  else {
    ret = usintget( start , startsize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* else */

  if ( buffer[*buffptr] == ',' ) (*buffptr)++;
  else return( ERROR );

  /* extracting end */
  if ( mode == MODE0 ) {
    ret = efraget( end , endsize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* if */
  else {
    ret = usintget( end , endsize , buffer , buffptr , MODE1 );
    if ( ret <= ERROR0 ) return( ERROR );
  }/* else */

  return( SUCCESS );

}/* cntlget() */
