/*****************************************************************************
  
  		Functions to Control of Pointer's List
 		     for NCS Module to SATELLITE                     

    $Id: plist.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif  /* HAVE_STDLIB_H */
#ifdef HAVE_MALLOC_H
#ifndef _STDLIB_H_
#include <malloc.h>
#endif
#endif /* HAVE_MALLOC_H */

#define  FATAL   (10)

#include "macro.h"
#include "plist.h"

static int 	plist_err		_ANSI_ARGS_(( int number ));
static int 	plist_remove_cell	_ANSI_ARGS_(( PList list ));
static PList 	plist_get_cell		_ANSI_ARGS_(( int arg ));

static int err_info = 0; /*  PL_ERROR_NODISP) Not display error         */
                         /*    PL_ERROR_DISP) display error             */
                         /* PL_ERROR_ALLDISP) display error and warning */ 

/*
 *  Funtion to creat list's cell ( static )
 *	input:  arg --- dummy
 *	output: address of cell of list
 */ 
static 
PList plist_get_cell( arg )
int arg;
{
  PList list;
  int err;

  if( ( list = (PList)malloc( sizeof( PList ) ) ) == NULL ){
    if( (err = plist_err(1)) != TRUE ){
      exit(err);
    }else{
      return( NULL );
    }
  }

  list->member = NULL;
  list->next = NULL;
  
  return( list );
}


/*
 *  Function to remove cell (static)
 *	input: PList list --- root list
 *     output: TRUE or FALSE
 */
static 
int plist_remove_cell( list )
PList list;
{
  free( list );

  return( TRUE );
}

/*
 *  Function to display wrror or warning message (static)
 *	input: int number --- error number
 *     output: error infomation
 */
static 
int plist_err( number )
int number;
{
  if( err_info != PL_ERROR_NODISP ){
    switch( number ){
     case 1:
      fprintf( stderr, "Error (plist 1):Memory Allocation Error\n" );
      return( FATAL );
      break;
     default:
      fprintf( stderr, "Error (plist ?):Error in PList\n" );
      break;
    }
  }
  return( TRUE );
}

/*
 *  Function to creat list structure
 *	input:  int error level 
 *                      --- PL_ERROR_NODISP) Not display error
 *			      PL_ERROR_DISP) display error            
 * 			   PL_ERROR_ALLDISP) display error and warning 
 *	output: address of root cell of list
 */ 
PList plist_create( err_level )
int err_level;
{
  PList root;

  if( ( err_level > 1 ) || ( err_level < 0 ) ){
    fprintf( stderr, "Warning (plist): No much error level\n" );
    err_info = 0;
  }else{
    err_info = err_level;
  }

  root = plist_get_cell( 0 );

  root->member = (PLMember)NULL;
  root->next = (PList)NULL;
  
  return( root );
}

/*
 *  Function to destroy list structure
 *	input:  PList list --- root list
 *	output: TRUE or FALSE
 */ 
int plist_destroy( list )
PList list;
{
  PLPointer pointer = list, next = list;

  do{
    next = pointer->next;
    if( plist_remove_cell( pointer ) != TRUE ){
      return( FALSE );
    }
    pointer = next;
  }while( pointer != NULL );

  return( TRUE );
}

/*
 *  Function to advance pointer of list
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *	output: advanced pointer of current list
 *              ( if pinter indicate end cell, then it is original pointer )
 */ 
PLPointer plist_advance( current, pointer )
PList current;
PLPointer pointer;
{
  if( pointer->next != NULL ){
    return( pointer->next );
  }else{
    return( pointer );
  }
}


/*
 *  Function to retreat pointer of list
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *	output: retreated pointer of current list
 *              ( if pinter indicate first cell, then it is original pointer )
 */ 
PLPointer plist_retreat( current, pointer )
PList current;
PLPointer pointer;
{
  PLPointer tmp = current;

  if( current == pointer ){
    return( pointer );
  }
  
  while( tmp->next != pointer ){
    tmp = tmp->next;
  }

  return( tmp );
}

/*
 *  Function to read list's member
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *	output: read data
 */ 
PLMember plist_read_data( current, pointer )
PList current;
PLPointer pointer;
{
  return( pointer->member );
}

/*
 *  Function to write data in list's member
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *              PLMember data --- data to write
 *	output: pointer of current list
 */ 
PLPointer plist_write_data( current, pointer, data )
PList current;
PLPointer pointer;
PLMember data;
{
  pointer->member = data;
  return( pointer );
}

/*
 *  Function to insert data in list's member
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *              PLMember data --- data to write
 *	output: pointer of current list
 */ 
PLPointer plist_insert( current, pointer, data )
PList current;
PLPointer pointer;
PLMember data;
{
  PList cell;
  PLPointer next;

  next = pointer->next;
  cell = plist_get_cell( (int)0 );
  pointer->next = next;

  cell->next = (PList)pointer->next;
  pointer->next = cell;

  pointer = plist_write_data( current, cell, data );

  return( pointer );
}

/*
 *  Function to delete cell in list structure
 *	input:  PList current --- root of current list
 *              PLPointer pointer --- pointer of current list
 *	output: pointer of current list
 */ 
PLPointer plist_delete( current, pointer )
PList current;
PLPointer pointer;
{
  PLPointer ret;

  if( current == pointer ){
    return( pointer );
  }

  ret = plist_retreat( current, pointer );
  ret->next = pointer->next;
  
  plist_remove_cell( pointer );
  
  return(ret);
}

/*
 *  Function to Return to Number of Cell of List Structure
 *	input:  PList current --- root of current list
 *	output: number of cell
 */ 
int plist_number_cell( current )
PList current;
{
  PLPointer point = current;
  int n = 0;

  while( point->next != NULL ){
    n++;
    point = point->next;
  }

  return( n );
}

/*
 *  Function to Move Pointer to Top
 *	input:  PList current --- root of current list
 *	output: pointer of current list
 */ 
PLPointer plist_go_top( current )
PList current;
{
  return( current );
}

/*
 *  Function to Move Pointer to End
 *	input:  PList current --- root of current list
 *	output: pointer of current list
 */ 
PLPointer plist_go_end( current )
PList current;
{
  PLPointer point = current;

  /*  printf( "pointer = %x\n", point );*/
  while( point->next != (struct PLIST 	*)NULL ){
    /*  printf( "pointer = %x\n", point );*/
    point = (PLPointer)point->next;
  }

  return( point );
}

/*
 *  Function to Move Pointer to N th
 *	input:  PList current --- root of current list
 *              int   n       --- n th
 *	output: pointer of n th
 */ 
PLPointer plist_go_nth( current, n )
PList current;
int n;
{
  PLPointer point = current;
  int i;
  
  for( i = 0; i < n; i++ ){
    point = plist_advance( current, point );
  }

  return( point );
}
