/*****************************************************************************

                              STRING FUNCTIONS

    $Id: strfunc.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef  HAVE_STDLIB_H
#include <stdlib.h>
#endif  /* HAVE_STDLIB_H */
#ifdef  HAVE_MALLOC_H
#include <malloc.h>
#endif  /* HAVE_MALLOC_H */
#include <string.h>
#include <ctype.h>
#include "common.h"
#include "comlib.h"

static int 	string_get	_ANSI_ARGS_(( char *buffer, int stringlen ));

/*****************************************************************************
FUNCTION STRING_GET
******************************************************************************
GETTING OF A STRING FROM CONSOLE

buffer     : storage buffer for a string;
stringlen  : the length of a string to be got;

WARNING    : The size of 'buffer' must be more than 'stringlen'+1. If the
             actual size of the string to have been input is larger than
             'stringlen', the excess part of the string is just discarded. ;

return( 0 ): success;
return( 1 ): error;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

static int 
string_get( buffer, stringlen )
char	buffer[];
int     stringlen;
{
	char            ch;
	int             counter = 0;

	/* getting of a string */
	do {
	  if( (ch = (char) fgetc(stdin)) == EOF ){
	    if( feof(stdin) == FALSE ){
	      return( ERROR );
	    } else {
	      break;
	    } 
           } else {
	     if( ch == LF ){
	       break;
	     } else {
	       buffer[counter++] = ch;
	     }
	   }		/* else */
	} while( counter < stringlen );
	buffer[counter] = EOS;

	/* discard the excess part of a string */
	while( ch != LF ){
	  if( (ch = (char) fgetc(stdin)) == EOF ){
	    if( feof(stdin) == FALSE ){
	      return( ERROR );
	    } else {
	      break;
	    }
	  }		/* if */
	}			/* while */

	return( SUCCESS );

}				/* string_get() */


/*****************************************************************************
FUNCTION  STRING_ANA
******************************************************************************
ANALYZING OF A STRING

buffer : a string to be analyzed;
anatbl : string table for analysis;
mode   : mode( MODE0: report error , MODE1: not report error );

id_num : string id on the table ( 0 < id_num ) ;

return( id_num ): success;
return( 0 ): error;

MSC Ver.5.1                                      06/09/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
string_ana( buffer, anatbl, mode )
char	buffer[], *anatbl[];
int     mode;
{
	int	counter, id_num = 0;

	/* string comparison */
	for( counter = 0; anatbl[counter] != EOS; counter++ ){
	  if( strcmp(buffer, anatbl[counter]) != EQUIVALENT ){
	    continue;
	  } else {
	    id_num = counter + 1;
	    break;
	  }		/* else */
	}			/* for */

	/* error processing */
	if( id_num == 0 ){
	  if( mode == MODE0 ){
	    printf( "\nIllegal String '%s'\n", buffer );
	    return( ERROR0 );
	  } else {
	    return (counter + 1);	/* for 'default' */
	  }
	} else {
	  return( id_num );
	}

}				/* string_ana() */


/*****************************************************************************
FUNCTION  CUTTER
******************************************************************************
CUTTING OF CHARACTERS FROM FILE

fp       : a source file pointer ;
stopterm : stop terminator ;
buffer   : storage buffer for a string which doesn't include TAB, CR, LF and
           SPACE ;
buff_size: size of 'buffer' ;
org_buff : storage buffer for an original string ;
org_size : size of 'org_buff' ;
mode     : mode ( MODE0 : no optional function
                  MODE1 : discard the rest of characters in the line ) ;

WARNING  : size of 'buffer' must be more than 'buff_size'+1 ;
           and 'org_buff', more than 'org_size'+1 ;

return( 0 ) : success ;
return( 1 ) : error ;
return( -1 ) : EOF ;

MSC Ver.5.1                                      06/08/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
cutter( fp, stopterm, buffer, buff_size, org_buff, org_size, mode )
FILE	*fp;
char    *stopterm, buffer[], org_buff[];
int     buff_size, org_size, mode;
{
	int	ch, buff_cnt = 0, org_cnt = 0;

	while( (ch = fgetc(fp)) != *stopterm && ch != EOF ){

	  /* storing character into 'org_buff' */
	  if( org_cnt < org_size ){
	    org_buff[org_cnt++] = ch;
	  } else {
	    buffer[buff_cnt] = EOS;
	    org_buff[org_cnt] = EOS;
	    printf( "\nBuffer Full !!\n" );
	    return( ERROR );
	  }		/* else */

	  /* storing character into 'buffer' */
	  if( ch != TAB && ch != CR && ch != LF && ch != SPACE ){
	    if (buff_cnt < buff_size){
	      buffer[buff_cnt++] = ch;
	    } else {
	      buffer[buff_cnt] = EOS;
	      org_buff[org_cnt] = EOS;
	      printf( "\nBuffer Full !!\n" );
	      return( ERROR );
	    }	/* else */
	  }		/* if */
	}			/* while */
	buffer[buff_cnt] = EOS;
	org_buff[org_cnt] = EOS;

	if( ch == EOF ){
	  if( ferror(fp) == SUCCESS ){
	    if( buff_cnt != 0 ){
	      printf("\nNot Exist '%c' !!\n", *stopterm);
	      return( ERROR );
	    } else {
	      return (EOF);
	    }
	  } else {
	    printf("\nFailed to Get Character from File !!\n");
	    exit(ERROR);
	  }		/* else */
	}			/* if */
	if( mode == MODE1 ){
	  /* discard the rest of characters in the line */
	  while( (ch = fgetc(fp)) != LF && ch != EOF );
	  if (ch == EOF) {
	    if (ferror(fp) != SUCCESS) {
	      printf("\nFailed to Get Character from File !!\n");
	      exit(ERROR);
	    }	/* if */
	  }		/* if */
	}			/* if */
	return( SUCCESS );

}				/* cutter() */


/*****************************************************************************
FUNCTION NAMEGET
******************************************************************************
EXTRACTING A NAME
name    : storage buffer for a string ;
size    : size of 'name' ;
buffer  : source buffer ;
buffptr : a pointer of 'buffer' ;
mode    : mode ( MODE0:search for head , MODE1:not search for head ) ;

WARNING  : size of 'name' must be more than 'size'+1 ;

return( counter ) : success ( size of the string stored : 0 =< counter ) ;
return( -1 ) : error ;

MSC Ver.5.1                                      05/27/1989 CODED BY A. ANZAI
*****************************************************************************/

int 
nameget( name, size, buffer, buffptr, mode )
char	name[], buffer[];
int     *buffptr, size, mode;
{
	int	counter = 0;

	/* detecting head */
	if( mode == MODE0 ){
	  while( isalpha((int) buffer[*buffptr]) == FALSE 
		 && buffer[*buffptr] != EOS ) {
	    (*buffptr)++;
	  }
	} else if (isalpha((int) buffer[*buffptr]) == FALSE) {
	  return (ERRORM1);
	}

	/* extracting name */
	while( counter < size && buffer[*buffptr] != EOS ){
	  /* extracting alphabet */
	  if( isalpha((int) buffer[*buffptr]) != FALSE ){
	    name[counter++] = buffer[(*buffptr)++];
	  } else {
	    if( isdigit((int) buffer[*buffptr]) != FALSE 
		|| buffer[*buffptr] == '_' ) {
	      name[counter++] = buffer[(*buffptr)++];
	    } else {
	      break;
	    }
	  }		/* else */
	}			/* while */

	name[counter] = EOS;

	return (counter);

}				/* nameget() */


/*
 * save a copy of a string
 * 	char *s : copy of a string 
 *	int  len: allocate memory over a string *s
 */
char *str_over_dup( s, len )
char 	*s;
int	len;
{
  	char	*str;

	if( (str=(char *)malloc(((int)strlen(s)+len+1)*sizeof(char)))==NULL ){
	  exit(213);
	}
	strcpy( str, s );
	return( str );
}

/*
 * save a copy of a string
 * 	char *s : copy of a string 
 *	int  n  : not more than n characters.
 *	int  len: allocate memory over a string *s
 */
char *str_over_ndup( s, n, len )
char 	*s;
int	n, len;
{
  	char	*str;

	if( (str=(char *)malloc(((int)strlen(s)+len+1)*sizeof(char)))==NULL ){
	  exit(213);
	}
	strncpy( str, s, n );
	return( str );
}
