/*****************************************************************************
  
  			redefined isnumber

    $Id: stype.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif /* HAVE_CTYPE_H */
#include "ncsdef.h"
#include "common.h"
#include "comlib.h"

#ifndef HAVE_ISNUMBER

#define SIGN	0
#define INTGR	1
#define FLOAT	2 
#define EXPNT	3 
#define EXPSG	4
#define NUMBR	5
#define PRIOD	6  
#define NONUM   999


int isnumber( str )
char *str;
{
	int ch, ptr, flag;

	ptr = 0;
	flag = NONUM;
	ch = str[ptr++];
	if( ch == '+' || ch == '-' )
	  flag = SIGN;
	else if( isdigit( ch ) )
	  flag = INTGR;
	else if( ch == '.' )
	  flag = PRIOD;

	if( flag == NONUM ){
	  return( FALSE );
	}

	while( (ch = str[ptr++]) != '\0' ){
	  switch( ch ) {
	  case '.':
	    if( flag == INTGR ){
	      flag = FLOAT;
	    } else {
	      return( FALSE );
	    }
	    break;

	  case '+':
	  case '-':
	    if( flag == EXPNT ){
	      flag = EXPSG;
	    } else {
	      return( FALSE );
	    }
	    break;

	  case 'e':
	  case 'E':
	    if( flag == INTGR || flag == FLOAT ){
	      flag = EXPNT;
	    } else {
	      return( FALSE );
	    }
	      break;

	  default :
	    if( isdigit( ch ) ) {
	      switch( flag ) {
	      case SIGN : flag = INTGR; break;
	      case PRIOD: flag = FLOAT; break;
	      case EXPNT: flag = NUMBR; break;
	      case EXPSG: flag = NUMBR; break;
	      }
	    } else {
	      return( FALSE ); 
	    }
	  }
	}
	if( flag == INTGR || flag == FLOAT ){
	  flag = NUMBR;
	}
	if( flag == NUMBR ){
	  return( TRUE );
	} else {
	  return( FALSE );
	}
}

#endif /* HAVE_IS_NUMBER */
