/*****************************************************************************
  
  		 Functions to Control Child Process

    $Id: waitfor.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#include <sys/wait.h>
#include <unistd.h>
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif /* HAVE_VFORK_H */

#include "macro.h"

#define COMLENG	64
#define MAXSIG 19
#define lowbyte(w)	((w) & 0377)
#define highbyte(w)	lowbyte((w) >> 8)
/*
#if defined(vax) || defined(i386) || defined(i486)
#define ReturnCode(w)	((w) & 0x00ff)
#endif
#if defined(titan) || defined(luna88k) || defined(mc68000) || defined(sparc) || defined(hpux)
#define ReturnCode(w)	(((w) & 0xff00) >> 8)
#endif
#if defined(__alpha) || defined(__mips)
#define ReturnCode(w)	(((w) & 0xff00) >> 8)
#endif
*/

static int 	statusprt	_ANSI_ARGS_(( int pid, int status ));
static int 	waitfor		_ANSI_ARGS_(( int pid ));
static int 	returnCode	_ANSI_ARGS_(( int pid ));

#ifndef BYTE_ORDER
# ifndef  BIG_ENDIAN
#  define BIG_ENDIAN 4321
# endif
# ifndef  LITTLE_ENDIAN
#  define LITTLE_ENDIAN 1234
# endif
# ifdef WORDS_BIGENDIAN
#  define BYTE_ORDER BIG_ENDIAN
# else
#  define BYTE_ORDER LITTLE_ENDIAN
# endif
#endif

static int
returnCode(w)
     int w;
{
  switch(BYTE_ORDER){
  case LITTLE_ENDIAN:
    return w & 0x00ff;
    break;
  case BIG_ENDIAN:
    return (w & 0xff00) >> 8;
    break;
  }
}

static int 
statusprt(pid, status)
int	pid, status;
{
	int             code = 0;
	static char    *sigmsg[] = {
		"",
		"Hangup",
		"Interrupt",
		"Quit",
		"Illegal instruction",
		"Trace trap",
		"IOT instruction",
		"EMT instruction",
		"Floating point exception",
		"Kill",
		"Bus error",
		"Segmentation violation",
		"Bad arg to system call",
		"Write on pipe",
		"Alarm clock",
		"Terminate signal",
		"User signal 1",
		"User signal 2",
		"Death of child",
		"Power fail"
	};


	if (status != 0 && pid != 0){
	  fprintf(stderr, "Process %d: ", pid);
	}
	if (lowbyte(status) == 0) {
/*
		if ((code = highbyte(status)) != 0)
			fprintf(stderr, "Exit code %d\n", code);
*/
	} else {
	  if ((code = (status & 0177)) <= MAXSIG){
	    fprintf(stderr, "%s", sigmsg[code]);
	  }else{
	    fprintf(stderr, "Signal #%d", code);
	  }
	  if ((status & 0200) == 0200){
	    fprintf(stderr, "-core dumped");
	  }
	  fprintf(stderr, "\n");
	}
	return	code;
}


static int
waitfor( pid )
int pid;
{
	int	wpid, code = 0;
	int	status = 0;

	while ((wpid = wait(&status)) != pid && wpid != -1){
	  code = statusprt(wpid, status);
	}

	if (wpid == pid){
	  code = statusprt(0, status);
	}

	fflush(stderr);
	/*
	  return (code != 0) ? -code : (int)ReturnCode(status);
	*/
	return (code != 0) ? -code : (int)returnCode(status);
}


int
ChildProcess( argv )
char 	*argv[];
{
        char     com[COMLENG];
        int      pid = -1;
        int      status;

	fflush(stdout), fflush(stderr);
        strcpy( com, argv[0] );

        /* Fork Child Process */
#ifdef HAVE_VFORK_H
  	switch( pid = vfork() ){
#else
        switch( pid = fork() ) {
#endif
        case -1:
                perror("Can't create new process\n");
                return (-1);
        case 0:
                /* Execute SCCOM Command */
                execvp(com, argv);
                /* Error Exit (Command Not Found) */
                exit(225);
        default:
		status = waitfor(pid);
                return status;
        }
}

char *
strargcpy(argv, argc, str)
char	**argv;
int     argc;
char    *str;
{
	argv[argc] = (char *) malloc((strlen(str) + 1) * sizeof(char));
	if (argv[argc] == NULL) {
	  perror("Memory Allocation Error\n");
	}
	strcpy( argv[argc], str );
	return ( argv[argc] );
}


