/*****************************************************************************

                     NCS FUNCTION FOR SIMULATION PROGRAM

    $Id: ncssfunc.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef TITAN
#include <vmath.h>
#else
#include <math.h>
#endif
#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "ncssstrc.h"
#include "ncssscf.h"
#include "ncssfdl.h"
#include "ncssfunc.h"

#define DEBUGF(a)	fprintf a  

void 	ncsf_valset_all		_ANSI_ARGS_(( int nt, 
					      int *nctbl, 
					      double **mem_ptr, 
					      double value ));
void 	ncsf_prnd		_ANSI_ARGS_(( int cnt, 
					      double **dptr ));

extern int	ncsg_vbuff[];
extern int	ncsg_vbuffdim[];
extern double	ncsg_bufstep;
/*extern int      rr_end;*/
long	ncsg_bufperiod;

/*****************************************************************************
FUNCTION  NCSF_SCSET
******************************************************************************
SET SIMULAITON CONDITION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

void 
ncsf_scset( dpoint, calc_end, str_period, report_end )
int	*dpoint;
int     *calc_end, *str_period;
float   *report_end;
{
	long            tmpl;
	float           tmpf;

	/* preprocessing */
	tmpf = (float) (ncsg_bufstep / ncsg_calstep + 0.5);
	ncsg_bufperiod = (long) tmpf;
	tmpf = (float) (ncsg_strstep / ncsg_calstep + 0.5);
	*str_period = (long) tmpf;
	tmpf = (float) (ncsg_endtime / ncsg_calstep + 0.5);
	*calc_end = (long) tmpf;

	tmpl = *calc_end + 1;
	*report_end = (float) tmpl;

	tmpl = *calc_end / (*str_period) + 1;
	*dpoint = (int) tmpl;

} /* end of ncsf_scset */


/*****************************************************************************
FUNCTION  NCSF_INITSET
******************************************************************************
INITIALIZE MEMORY

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

void 
ncsf_initset()
{
	/* memory zero clear */
	ncsf_valset_all( ncsg_ntout, ncsg_ncout, ncsm_outptr, 0. );
	ncsf_valset_all( ncsg_ntxin, ncsg_ncxin, ncsm_xinptr, 0. );
	ncsf_valset_all( ncsg_ntobs, ncsg_ncobs, ncsm_obsptr, 0. );
}				/* ncsf_initset() */


/*****************************************************************************
FUNCTION  NCSF_MONISET
******************************************************************************
SET MONITERING CONSTANTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

void 
ncsf_moniset( moni_vflag )
char	*moni_vflag;
{
  	if( ncsg_monimode == NCS_MONI_VLONLY ){
	  *moni_vflag = FLAG_ON;
	} else {
	  *moni_vflag = FLAG_OFF;
	}
}				/* ncsf_moniset() */


/*****************************************************************************
FUNCTION  NCSF_STARTSIGN
******************************************************************************
INDICATE CALCULATION START SIGN

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_startsign()
{
	printf( "###### NCS on %s ######\n", OS_NAME );
	/* indicating start sign */
	printf( ">> NOW CALCULATING ... WAIT FOR A TIME, PLEASE !! <<" );

	/* Disable cursor display */
	printf( "%c[>5h", ESC );
	fflush( (FILE *)stdout );
}				/* ncsf_startsign() */


/*****************************************************************************
FUNCTION  NCSF_REPOSTART
******************************************************************************
INDICATE CALCULATION PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_repostart()
{

	/* indicating calculation progress report */
	printf( "   0.0%% done." );
	/* Cursor backward */
	printf( "%c[7D", ESC );
	fflush( (FILE *)stdout );
}				/* ncsf_repostart() */


/*****************************************************************************
FUNCTION  NCSF_DATAOUT
******************************************************************************
STORE THE RESULTS OF CALCULATION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

void 
ncsf_dataout( moni_vflag, index, strd_cnt )
char	*moni_vflag;
int     index;
int	strd_cnt;
{
	ncsf_strd( ncsg_nstrd, index, ncsg_strdptr );
	if( ( strd_cnt % ncsg_bufperiod ) == 0 ){
	  ncsf_StoreData( index, ncsg_nstrd );
	}

	if( *moni_vflag == FLAG_ON ){
	  ncsf_prnd( index, ncsg_vmoniptr );
	}
}				/* ncsf_dataout() */


/*****************************************************************************
FUNCTION  NCSF_REPOPROGRESS
******************************************************************************
INDICATE PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_repoprogress( calc_cnt, report_end )
int	calc_cnt;
float   report_end;
{
	long 	tmpl;
	float   progress;

	/* indicating calculation progress report */
	tmpl = calc_cnt + 1;
	/*	if( (int)report_end == 0 ){
	  report_end = (float)rr_end;
	}*/
	progress = ( (float)tmpl / report_end ) * 100.;
	/* Cursor backward */
	printf( "%c[5D", ESC );
	printf( "%5.1f", progress );
	fflush( (FILE *)stdout );
}				/* ncsf_repoprogress() */


/*****************************************************************************
FUNCTION  NCSF_ENDSIGN
******************************************************************************
INDICATE END SIGN

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_endsign()
{
	/* move cursor to left margin */
	printf("%c", CR);
	/* indicating end sign */
	printf(">> THE CALCULATION HAS FINISHED .............. !! <<\n");
	/* Enable cursor display */
	printf("%c[>5l", ESC);
	fflush((FILE *)stdout);
}				/* ncsf_endsign() */


/*****************************************************************************
FUNCTION  NCSF_REPOEND
******************************************************************************
INDICATE CALCULATION PROGRESS REPORT

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_repoend()
{
	/* indicating calculation progress report */
	printf( "%c[5D", ESC );
	printf( "100.0" );
	fflush( (FILE *)stdout );
}				/* ncsf_repoend() */


/*****************************************************************************
FUNCTION  NCSF_XINSET
******************************************************************************
SET EXTERNAL INPUT INFORMATION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_xinset( nxinc, xin_data, xfp_data, xin_func )
int             nxinc;
struct xin_info xin_data[];
struct xfp_info xfp_data[];
double          (*xin_func[]) ();
{
	int             cnt, xfd_num, func_num;
	double         *mem_addr, (*func_addr) ();


	for (cnt = 0; cnt < nxinc; cnt++) {
	  mem_addr = xin_data[cnt].comp_addr;
	  CN = xin_data[cnt].comp_number;
	  xfd_num = xin_data[cnt].xfd_number - 1;
	  func_num = xfp_data[xfd_num].xf_number - 1;
	  func_addr = xin_func[func_num];
	  *mem_addr = (*func_addr) (
				    xfp_data[xfd_num].xf_para[0],
				    xfp_data[xfd_num].xf_para[1],
				    xfp_data[xfd_num].xf_para[2],
				    xfp_data[xfd_num].xf_para[3],
				    xfp_data[xfd_num].xf_para[4]);
	}			/* for */
}				/* ncsf_xinset */


/*****************************************************************************
FUNCTION  NCSF_VALSET_ALL
******************************************************************************
SET VALUE

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_valset_all(nt, nctbl, mem_ptr, value)
int	 nt, nctbl[];
double   *mem_ptr[], value;
{
	int             type, number;
	double         *mem_addr;

	for (type = 0; type < nt; type++) {
		mem_addr = mem_ptr[type];
		for (number = 0; number < nctbl[type]; number++) {
			mem_addr[number] = value;
		}		/* for */
	}			/* for */
}				/* ncsf_valset */


/*****************************************************************************
FUNCTION  NCSF_UPDATE
******************************************************************************
UPDATE MEMORY CONTENTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
*****************************************************************************/

void 
ncsf_update( nt, nctbl, out_ptr, tmp_ptr )
int 	nt, nctbl[];
double  *out_ptr[], *tmp_ptr[];
{
	register int    type, number;
	double         *to_addr, *from_addr;

#ifdef TITAN
#pragma ASIS	
#endif	
	for (type = 0; type < nt; type++) {
	  to_addr = out_ptr[type];
	  from_addr = tmp_ptr[type];
	  for (number = 0; number < nctbl[type]; number++){
	    to_addr[number] = from_addr[number];
	  }
	}			/* for */
}				/* ncsf_update() */


/*****************************************************************************
FUNCTION  NCSF_PRND
******************************************************************************
CRT OUTPUT OF CALCULATION RESULTS

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

void 
ncsf_prnd(prn_index, dptr)
int	prn_index;
double  *dptr[];
{
	int             cnt;
	float           f_data=0.;
	double          data;

	if ((prn_index % 10) == 0) {
	  printf("\n  TIME ");
	  for (cnt = 0; cnt < NCS_MONI_NVAR; cnt++) {
	    if (dptr[cnt] != NULL) {
	      printf("       ");
	      printf("BUFF%2d[%2d]", ncsg_vbuff[cnt], ncsg_vbuffdim[cnt]);
	    }	/* if */
	  }		/* for */
	  printf("\n");
	}			/* if */
	printf("%-15.6f", NCS_TIME);
	for (cnt = 0; cnt < NCS_MONI_NVAR; cnt++) {
	  if (dptr[cnt] != NULL) {
	    data = *dptr[cnt];
	    if (data > 1.e+37){
	      f_data = 1.e+37;
	    }
	    if (data < -1.e+37){
	      f_data = -1.e+37;
	    }
	    if (-1.e+37 <= data && data <= 1.e+37) {
	      if (fabs(data) < 1.e-36){
		f_data = 0.;
	      }	else {
		f_data = (float) data;
	      }
	    } /* if */	
	    printf("%-16.6g", f_data);
	    
	  }		/* if */
	}			/* for */
	printf("\n");
}				/* ncsf_prnd() */
