/*****************************************************************************
  
                     NCS LIBRARY FOR SIMULATION PROGRAM
  
    $Id: ncsslib.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef TITAN
#include <vmath.h>
#else
#include <math.h>
#endif
#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "ncssstrc.h"
#include "ncssfdl.h"

#define DEBUGF(a)	fprintf a

extern double NCS_TIME;           /* SIMULATION CALCULATION TIME */
extern double ncsg_calstep;       /* SIMULATION CALCULATION TIME STEP */
extern double   MachineEps;


/*****************************************************************************
FUNCTION  NCSL_INTGRL
******************************************************************************
NUMERICAL INTEGRATION
  
return( init ) : initial value ( when TIME = 0. );
return( f ) : integrated value ( when TIME > 0. );
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_intgrl( init, y, f_old )
double init, y, f_old;
{
	double          f;

	if( NCS_TIME == 0. ){
	  return (init);
	}
	f = f_old + y * ncsg_calstep;

	return( f );
}				/* ncsl_intgrl() */


/*****************************************************************************
FUNCTION  NCSL_DIFFER
******************************************************************************
NUMERICAL DIFFERENCIATION
  
return( init ) : initial value ( when TIME = 0. );
return( f ) : function value ( when TIME >= 0. );
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_differ( init, y, y_old )
double init, y, y_old;
{
	double          f;

	if ( NCS_TIME == 0. ){
	  return (init);
	}
	f = (y - y_old) / ncsg_calstep;

	return( f );
}				/* ncsl_differ() */


/*****************************************************************************
FUNCTION  NCSL_RAMP
******************************************************************************
RAMP FUNCTION
  
return( init_out ) : initial value ( when TIME < rampup_time );
return( f ) : function value ( when TIME >= rampup_tm );
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_ramp( rampup_tm, init_out, gradient, dummy1, dummy2 )
double	init_out, rampup_tm, gradient, dummy1, dummy2;
{
	double	f;

	if( NCS_TIME < rampup_tm ){
	  return( init_out );
	}
	f = gradient * (NCS_TIME - rampup_tm) + init_out;

	return( f );
}				/* ncsl_ramp() */


/*****************************************************************************
FUNCTION  NCSL_PULSE
******************************************************************************
PULSE FUNCTION
  
return( init_out ) : initial value ( when TIME < start_tm );
return( init_out + height ) : function value ( when TIME >= start_tm );
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_pulse( start_tm, init_out, height, width, period )
double	start_tm, init_out, height, width, period;
{
	double	d_val, tm_mod;

	if( NCS_TIME < (start_tm - MachineEps / 2.0) ) {
	  return (init_out);
	}
	if(period != 0.0)  {
	  d_val = (NCS_TIME - start_tm) / period;
	  d_val = (double)(long)d_val;

	  tm_mod = NCS_TIME - start_tm - d_val * period;
	} else {
	  tm_mod = NCS_TIME - start_tm;
	}


	if( tm_mod < (width - MachineEps / 2.0) ){
	  return (init_out + height);
	} else {
	  return (init_out);
	}
}				/* ncsl_pulse() */


/*****************************************************************************
FUNCTION  NCSL_SIGMOID
******************************************************************************
SIGMOID FUNCTION
  
return( f ) : function value;
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_sigmoid( a )
double 	a;
{
	double	f;

	f = 1./ (1.+ exp(-a));

	return( f );
}				/* ncsl_sigmoid() */


/*****************************************************************************
FUNCTION  NCSL_THOLD
******************************************************************************
THRESHOLD FUNCTION
  
return( f ) : function value;
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_thold( input, theta )
double	input, theta;
{
  	if( input < theta ){
	  return( 0. );
	} else {
	  return( 1. );
	}
}				/* ncsl_thold() */


/*****************************************************************************
FUNCTION  NCSL_RCAB
******************************************************************************
RATE CONSTANT OF IONIC CURRENT
  
return( g / f ) : function value;
  
MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double 
ncsl_rcab(c1, c2, c3, c4, c5, c6, c7, V)
double 	c1, c2, c3, c4, c5, c6, c7, V;
{
	double	f, g;

	if( c6 == 0.&& c7 == -1. ){
	  printf("Error Detected in 'rcab()' NCS Library !!\n");
	  printf("Always Divided by Zero Because 'c6' = 0. and 'c7' = -1.0 !!\n");
	  exit(NORMAL);
	} else {
	  f = exp(c6 * (V + c3)) + c7;
	  if( f == 0. ){
	    f = c6 * exp(c6 * (V + c3));
	    g = c1 * c2 * exp(c2 * (V + c3)) + c4;
	    return( g / f );
	  }		/* if */
	  g = c1 * exp(c2 * (V + c3)) + c4 * (V + c5);
	  return( g / f );
	}			/* else */
}				/* ncsl_rcab() */
