/******************************************************************************

	                 NEURAL CIRCUIT SIMULATOR                 
	                    SIMULATION PROGRAM                    
	                       MAIN ROUTINE                       

    $Id: ncssmain.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef TITAN
#include <vmath.h>
#else
#include <math.h>
#endif

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "ncssstrc.h"
#include "ncssfdl.h"
#include "ncssmain.h"
#include "ncssbuff.h"

typedef void    (*VoidFunc) ();

double        **y, **yp;
float         **buffer;
VoidFunc      Integrl;
/*int           rr_end;*/

VoidFunc	ncsf_integset   _ANSI_ARGS_(( char *integ_method ));
void 		PreProcess	_ANSI_ARGS_((char *moni_vflag, 
					    int *dpoint, 
					    int *calc_end, 
					    int *str_period, 
					    float *report_end));
void 		CalcInit	_ANSI_ARGS_((char *moni_vflag, 
					     int *iflag, 
					     int *index, 
					     float report_end));
void 		Calculate	_ANSI_ARGS_((char *moni_vflag, 
					     int *iflag, 
					     int *index, 
					     float report_end, 
					     int calc_end, 
					     int str_period));
void 		PostProcess	_ANSI_ARGS_((char *moni_vflag, 
					     int dpoint, 
					     int nstrd));

extern void 	initvalue	_ANSI_ARGS_(( double **Ncs_y ));


/******************************************************************************
*          Cell counter  Modify function                                      *
*                 : Calling from Main function                                *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

VoidFunc
ncsf_integset( integ_method )
char	*integ_method;
{
	int             type;
	void		EulerIntgrl(), AdapIntgrl(), RKG4Intgrl();

#ifdef TITAN
#pragma ASIS
#endif
	for( type = 0; type < ncsg_ntout; type++ ){
	  if( ncsg_ncout[type] > ncsg_cell ){
	    ncsg_ncout[type] = ncsg_cell;
	  }
	}

	switch( *integ_method ){
	  case 'E':
	    return( EulerIntgrl );
	    break;
	  case 'F':
	    return( AdapIntgrl );
	    break;
	  case 'R':
	    return( RKG4Intgrl );
	    break;
	  default:
	    break;
	}

	return( NULL );
}



/******************************************************************************
*          Calling from AdapIntegrl function                                  *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

void
cf( t, ncs_y, ncs_dy )
double	t, **ncs_y, **ncs_dy;
{
	NCS_TIME = t;

	/*
	 * NETWORK() is produced by preprocessor 
	 */
	NETWORK( t, ncs_y, ncs_dy );

	/* update memory contents */
	ncsf_update( ncsg_ntout, ncsg_ncout, ncsm_outptr, ncsm_subptr );
}



/******************************************************************************
*          NCS Simulation Program Main function                               *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

void
PreProcess( moni_vflag, dpoint, calc_end, str_period, report_end )
char	*moni_vflag;
int     *dpoint;
int    *calc_end, *str_period;
float   *report_end;
{
	/*
	 * setting up of constants (This function is produced by
	 * preprocessor.) 
	 */
	ncsf_constset();

	/* preparation of exinput buffer information */
	ncsg_buff_info = plist_create( PL_ERROR_DISP );
	ncsg_buff_info_p = plist_go_top( ncsg_buff_info );
	exbuff_num = 0;
	/*printf( "ncsg_buff_info, next = %x, %x\n", ncsg_buff_info, ncsg_buff_info->next );*/

	/* reading of simulation conditions */
	if( ncsf_scfread() == ERROR ){
	  printf("Simulation Condition File Reading Error !!\n");
	  exit(219);
	}
	/* setting up of simulation conditions */
	ncsf_scset( dpoint, calc_end, str_period, report_end );

	/* this is for error on FreeBSD */
	/* You NOT remove this line.     */
	/*rr_end = (int)*report_end;  */

	/* setting up of integration conditions */

	/* Integration Information Setting    */
	Integrl = ncsf_integset( &ncsg_intg_method );

	/* Memory Allocation ... y, yp, buffer */
	ncsf_memalloc( ncsg_nstrd, *dpoint );

	/* initializing states of components */
	ncsf_initset();

	/*
	 * initial value set for Integration ( This function is produced by
	 * preprocessor ) 
	 */

	initvalue(y);

	/* setting up of monitering condition */
	ncsf_moniset( moni_vflag );

	/* displaying of start sign */
	ncsf_startsign();

	/* indicating of calculation progress report */
	if( *moni_vflag == FLAG_OFF ){
	  ncsf_repostart();
	}else{
	  printf("\n");
	}
}

void
CalcInit( moni_vflag, iflag, index, report_end )
char	*moni_vflag;
int     *iflag, *index;
float   report_end;
{
	double	time;

	/* ----------------------------------------------------------------- */
	/* Start of Calculation for Time = 0                 */
	/* ----------------------------------------------------------------- */
	/* Integration taking one step ( initialize ) */
	*iflag = 1;		/* for initialize   */

	ncsg_cdpoint = 0;
	time = 0.0;

	/* Initialize of Module output (time = -1) */
	ncsg_delay_flag = OUTPUT_INIT;

	/*
	 * setting up of external input values 
	 */
	ncsf_xinset( ncsg_nxinc, ncsg_xindata, ncsg_xfpdata, ncsg_xinfaddr );

	cf( time, y, yp );

	/* Initialize of queue */
	ncsg_delay_flag = DELAY_INIT_SET;

	/*
	 * setting up of external input values 
	 */
	ncsf_xinset( ncsg_nxinc, ncsg_xindata, ncsg_xfpdata, ncsg_xinfaddr );

	cf( time, y, yp );
	/*
	 * set_delay(); 
	 */

	ncsg_delay_flag = CALCULATE;

	(* Integrl)( cf, time, ncsg_calstep, ncsg_cell, ncsg_neqn, y,
		     &ncsg_relerr, iflag );

	/* ----------------------------------------------------------------- */
	/* End of Calculation for Time = 0                   */
	/* ----------------------------------------------------------------- */

}

void
Calculate( moni_vflag, iflag, index, report_end, calc_end, str_period )
char	*moni_vflag;
int    calc_end, str_period;
int     *iflag, *index;
float   report_end;
{
	int            calc_cnt, strd_cnt=0;
	double          time;

	/* ----------------------------------------------------------------- */
	/* Start of Calculation routine                      */
	/* ----------------------------------------------------------------- */
	for( calc_cnt = 0; calc_cnt <= calc_end; calc_cnt++ ){

	  if(((ncsg_intg_method) == ('E'))&&(calc_cnt == 0)){
	    calc_cnt = 1;
	    calc_end++;
	  }

	  /* for interporation (Buffer Input) */
	  ncsg_cdpoint = (int)calc_cnt;

	  time = ((double) calc_cnt) * ncsg_calstep;

	  /*
	   * setting up of external input values 
	   */
	  ncsf_xinset(ncsg_nxinc, ncsg_xindata, ncsg_xfpdata, ncsg_xinfaddr);

	  /* storing of results into memory area */
	  if( strd_cnt % str_period == 0 ){
	    
	    ncsf_dataout( moni_vflag, (*index)++, strd_cnt );
	  
	    if( *moni_vflag == FLAG_OFF ){
	      ncsf_repoprogress( calc_cnt, report_end );
	    }

	  }		/* if */
	  strd_cnt = calc_cnt + 1;
	  /*
	   * Integration taking one step NETWORK() is produced by
	   * preprocessor in cf(). 
	   */

	  (*Integrl)(cf, time, ncsg_calstep, ncsg_cell, ncsg_neqn, y,
		     &ncsg_relerr, iflag);
	  
	}			/* FOR */
	/* ----------------------------------------------------------------- */
	/* End of Calculation routine                        */
	/* ----------------------------------------------------------------- */
}

void
PostProcess( moni_vflag, dpoint, nstrd )
char	*moni_vflag;
int     dpoint, nstrd;
{
	/* indicating of calculation progress report */
	if( *moni_vflag == FLAG_OFF ){
	  ncsf_repoend();
	}

	/* indicating of end sign */
	if( *moni_vflag == FLAG_ON ){
	  printf("\n");
	}
	ncsf_endsign();

	/* ----------------------------------------------------------------- */
	/* Saving  data into SATELITE Data Buffer               */
	/* ----------------------------------------------------------------- */
	ncsf_StoreData( dpoint, nstrd );

	/* Free Memory */
	remove_all_exbuf_info( ncsg_buff_info );
	ncsf_FreeOutBuffer();
}


/*----------------------------- Start of main -------------------------------*/
int
main()
{
	char            moni_vflag;
	int             iflag, dpoint, index = 0;
	int             calc_end, str_period;
	float           report_end;

	/* Setting of simulation condition */
	PreProcess( &moni_vflag, &dpoint, &calc_end, &str_period, &report_end );

	/* Integration taking one step ( initialize ) */
	CalcInit( &moni_vflag, &iflag, &index, report_end );

	/* Start Calculation */
	Calculate( &moni_vflag, &iflag, &index, 
		   report_end, calc_end, str_period );

	/* Store Data */
	PostProcess( &moni_vflag, dpoint, ncsg_nstrd );

	exit(0);
}

/*------------------------------- End of main -------------------------------*/
