/*****************************************************************************

         NCS FUNCTIONS FOR READING OF SIMULATION CONDITION FILE


    $Id: ncssrscf.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <string.h>
#include <math.h>
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#ifndef _STDLIB_H_
#include <malloc.h>
#endif /* _STDLIB_H_ */
#endif /* HAVE_MALLOC_H */
#ifdef HAVE_SYSTYPES_H
#include <sys/types.h>
#endif /* HAVE_SYSTYPES_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */


#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "ncssstrc.h"
#include "ncssscf.h"
#include "ncssfdl.h"
#include "ncssrscf.h"
#include "ncssbuff.h"

#undef ESC

#ifndef L_SET
#define L_SET  0
#define L_INCR 1
#define L_XTND 2
#endif


void 	checker			_ANSI_ARGS_(( double small, double big ));
int 	ReadXin			_ANSI_ARGS_(( char *xin_name, int *xfdn_max ));
int 	ReadXfp			_ANSI_ARGS_(( char *xfp_name, int xfdn_max ));
int 	Mismatch		_ANSI_ARGS_(( int n, char *out_name ));
int 	Bsearch			_ANSI_ARGS_(( struct moni_buff *vbuff,
					      int n ));
int 	SetOutPtr		_ANSI_ARGS_(( int fd_out, char *out_name ));
int 	GetOutPtr		_ANSI_ARGS_(( int fd_out, 
					      char *out_name, 
					      int buff_max_number ));
int 	SetMoniBuff		_ANSI_ARGS_(( struct moni_buff *vbuff ));
int 	GetMoniInfo		_ANSI_ARGS_(( int fd_out ));

int	ncsg_vbuff[NCS_MONI_NVAR];
int	ncsg_vbuffdim[NCS_MONI_NVAR];

/*****************************************************************************
FUNCTION  NCSF_RDMAT
******************************************************************************
READ MODE AND TIMER FILE

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

double	ncsg_bufstep;

 void 
checker(small, big)
double	small, big;
{
  	if(big < small){
	  exit(204);
	}
}

int
ncsf_rdmat( scfn )
char scfn[];
{

	struct scf_mat  sc;
	int             fd_mat, r_size;
	char            mat_name[FNAME_WD];

	sprintf(mat_name, "%s.%s", scfn, NCS_MAT_EXTN);

	if ((fd_mat = open(mat_name, O_RDONLY)) == FCNTL_ERROR) 
		exit(201);

	r_size = sizeof(struct scf_mat);
	if (read(fd_mat, (char *) &sc, r_size) < r_size) 
		exit(202);

	if (sc.type == '1') {
		ncsg_endtime = sc.timer.sim_timer[0];
		ncsg_calstep = sc.timer.sim_timer[1];
		ncsg_strstep = sc.timer.sim_timer[2];
		ncsg_bufstep = sc.timer.sim_timer[3];

		/*
		 * checker(small, big);
		 */
#if 0
		checker(ncsg_calstep, ncsg_strstep);
		checker(ncsg_strstep, ncsg_bufstep);
		checker(ncsg_bufstep, ncsg_endtime);
#endif


		if( ncsg_endtime == 0. || ncsg_calstep == 0. ) 
			exit(204);

		if( sc.integral.maxcell < 0 || ncsg_cell < sc.integral.maxcell ) 
			exit(205);

		ncsg_intg_method = sc.integral.method;
		ncsg_cell   = sc.integral.maxcell;
		ncsg_relerr = sc.integral.relerr;

		if( ncsg_relerr < 0. || ncsg_relerr > 1. ) 
			exit(206);


	}			/* if */
	if (close(fd_mat) == FCNTL_ERROR)
		exit(203);
	return (SUCCESS);

}				/* ncsf_rdmat() */


/*****************************************************************************
FUNCTION  NCSF_RDPRM
******************************************************************************
READ PARAMETER FILE

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

int
ncsf_rdprm( scfn )
char	scfn[];
{
	struct scf_prm  sc;
	int             fd_prm, r_size;
	char            prm_name[FNAME_WD];

	sprintf(prm_name, "%s.%s", scfn, NCS_PRM_EXTN);

	if ((fd_prm = open(prm_name, O_RDONLY)) == FCNTL_ERROR) 
		exit(201);

	r_size = sizeof(struct scf_prm);

	while (read(fd_prm, (char *) &sc, r_size) == r_size 
				&& sc.type != NCS_SCF_EOF) {
		if (ncsf_prmset(&sc) != SUCCESS)
			exit(221);
	}			/* while */

	if (close(fd_prm) == FCNTL_ERROR) 
		exit(203);
	return (SUCCESS);

}				/* ncsf_rdprm() */


/*****************************************************************************
FUNCTION  NCSF_RDXINFO
******************************************************************************
READ EXTERNAL INFORMATION FILE

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
*****************************************************************************/

int 
ncsf_rdxinfo( scfn )
char	scfn[];
{
	char	xin_name[FNAME_WD], xfp_name[FNAME_WD];
	int     xfdn_max = 0;

	sprintf(xin_name, "%s.%s", scfn, NCS_XIN_EXTN);
	sprintf(xfp_name, "%s.%s", scfn, NCS_XFP_EXTN);

	ncsg_xinfaddr[0] = ncsl_ramp;
	ncsg_xinfaddr[1] = ncsl_pulse;
	ncsg_xinfaddr[2] = ncsl_interp;
	ncsg_xinfaddr[3] = ncsl_interp;

	ReadXin( xin_name, &xfdn_max );
	ReadXfp( xfp_name, xfdn_max );
	return( SUCCESS );
}

int
ReadXin( xin_name, xfdn_max )
char	xin_name[];
int	*xfdn_max;
{
	struct scf_xin  scxin;
	char		*mdl_name;
	int             fd_xin, xin_mtype, r_size;
	int		comp_number, nc, xfd_number;	
	double         *mem_addr;


	if ((fd_xin = open(xin_name, O_RDONLY)) == FCNTL_ERROR){
	  exit(201);
	}

	r_size = sizeof(struct scf_xin);

	nc = 0;
	while (read(fd_xin, (char *) &scxin, r_size) == r_size
				&& scxin.type != NCS_SCF_EOF) {
	  if (scxin.type == '1') {
	    /**/
	    mdl_name = scxin.xin.rec3.mdl_name;
	    comp_number = scxin.xin.rec3.comp_number;
	    xfd_number = scxin.xin.rec3.xfd_number;
	    /**/
	    xin_mtype = string_ana( mdl_name, ncsg_xintblptr, MODE0 );
	    if ( xin_mtype == 0 ){
	      exit(207);
	    }

	    mem_addr = ncsm_xinptr[xin_mtype - 1];
	    ncsg_xindata[nc].comp_addr = &mem_addr[comp_number];
	    ncsg_xindata[nc].comp_number = comp_number;
	    ncsg_xindata[nc].xfd_number = xfd_number;
	    if (xfd_number > *xfdn_max){
	      *xfdn_max = xfd_number;
	    }
	    nc++;
	  }		/* if */
	}			/* while */
	ncsg_nxinc = nc;

	if (scxin.type != NCS_SCF_EOF){
	  exit(202);
	}
	if (close(fd_xin) == FCNTL_ERROR){
	  exit(203);
	}
	return( SUCCESS );
}				/* ncsf_rdxinfo() */


int
ReadXfp( xfp_name, xfdn_max )
char	xfp_name[];
int	xfdn_max;
{
	struct scf_xfp  scxfp;
	int             fd_xfp, xfp_cnt, r_size, ret, nc, time_buffid;
	char		time_buff_name[NCS_DATA_FNAME];

	if ( (fd_xfp = open(xfp_name, O_RDONLY)) == FCNTL_ERROR ){ 
	  exit(201);
	}

	r_size = sizeof(struct scf_xfp);

	for( xfp_cnt = 0; xfp_cnt < xfdn_max; xfp_cnt++ ){
	  ret = read(fd_xfp, (char *) &scxfp, r_size);
	  if (ret == r_size && scxfp.type != NCS_SCF_EOF) {
	    ncsg_xfpdata[xfp_cnt].xf_number = scxfp.func_number;
	    switch( scxfp.type ) {
	     case '1':
	       for (nc = 0; nc < NCS_XFP_MAX; nc++){
		 ncsg_xfpdata[xfp_cnt].xf_para[nc] = 
		   scxfp.xfp.rec1.func_para[nc];
	       }
	       break;
	     case '2':
	   /*****  Change for multiple exinput buffer  *****/
           /*****                        [28,Aug,`94]  *****/
	       exbuff_num++;
	       ncsg_xfpdata[xfp_cnt].xf_para[0]=(double)exbuff_num;
	       ncsg_xfpdata[xfp_cnt].xf_para[1]=(double)scxfp.xfp.rec2.buffdim;
	       /* time information of buffer or file */
	       if( strlen( scxfp.xfp.rec2.timename ) == 0 ){ /* none */
		 time_buffid = 0;
		 time_buff_name[0] = EOS;
	       }else{	/* buffer id of time info buffer */
		 time_buffid = scxfp.xfp.rec2.timebuff ;
		 strcpy( time_buff_name, scxfp.xfp.rec2.timename );
	       }
	       if( scxfp.func_number == 3 ){
		 ncsg_buff_info_p = add_exbuf_info( ncsg_buff_info, ncsg_buff_info_p,
					       scxfp.xfp.rec2.buffnum, 
					       scxfp.xfp.rec2.datf_name,
					       time_buffid,
					       time_buff_name );
	       }else{
		 ncsg_buff_info_p = add_exbuf_info( ncsg_buff_info, ncsg_buff_info_p,
					       scxfp.xfp.rec2.buffnum,
					       NULL,
					       time_buffid,
					       time_buff_name );
	       }
	       break;
	     default:
	       exit(212);
	       break;
	    }
	  }		/* if */
	}			/* for */

	if(close(fd_xfp) == FCNTL_ERROR ){
	  exit(203);
	}
	return( SUCCESS );
}				/* ncsf_rdxinfo() */


/*****************************************************************************
FUNCTION  NCSF_RDOUT
******************************************************************************
READ OUTPUT INFORMATION FILE

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                   Coded by A.Anzai     06/12/1989
                                              Modified by A.I     14,Jun.,'94
*****************************************************************************/

int
Mismatch( n, out_name )
int	n;
char	*out_name;
{
  	printf("Module Name Mismatch in '%s' !!%d\n", out_name, n);
	exit(222);
}

int
Bsearch( vbuff, n )
struct moni_buff *vbuff;
int n;
{
	register int	i;

	for( i = 0; i < ncsg_nstrd; i++ ){
	  if( (vbuff->num[n] == ncsg_out_buffnum[i]) 
	      && (vbuff->dim[n] == ncsg_out_buffdim[i] ) ){
	    return(i);
	  }
	}
	return(-1);
}

int
ncsf_rdout( scfn )
char	scfn[];
{

	int             fd_out;
	char            out_name[FNAME_WD];
	int		buff_max;


	sprintf( out_name, "%s.%s", scfn, NCS_OUT_EXTN );

	if ( (fd_out = open(out_name, O_RDONLY)) == FCNTL_ERROR ){
	  exit(201);
	}

	if( ( buff_max = SetOutPtr(fd_out, out_name) ) == 0 ){
	  exit(221);
	}
	GetOutPtr( fd_out, out_name, buff_max );
	GetMoniInfo( fd_out );

	if( close(fd_out) == FCNTL_ERROR ){
	  exit(203);
	}

	return( SUCCESS );
}				/* ncsf_rdout() */

/***** dynamic memory allocation   *****/
/***** for output buffer '96/10/15 *****/
int 
SetOutPtr( fd_out, out_name )
int fd_out;
char out_name[];
{
	int	r_size;
	long	offset;
	OutFile sc;
	int     buff_max_number = 0;

	ncsg_nstrd = 0;

	/* Head of RECORD3 -> RECORD2 */
	r_size = sizeof(OutFile);
	offset = 0L;
	if( lseek(fd_out, offset, SEEK_SET) == -1 ){
	  fprintf( stderr, "lseek's error\n" );
	}

	while( read( fd_out, (void *)&sc, r_size ) == r_size 
				&& sc.type != SCF_EOF) {
	  if( sc.type == SCF_OUT_BUFF_SIZE ){
	    buff_max_number = sc.out.rec4.max_number;
	    if((ncsg_strdptr
		=(double **)malloc(sizeof(double *)*buff_max_number))
		     == NULL ){
	      fprintf( stderr, "GetOutPtr()[ncsg_strdptr]\n" );
	      exit( 213 );
	    }
	    if((ncsg_out_buffnum
		=(int *)malloc(sizeof(int)*buff_max_number))
	       == NULL ){
	      fprintf( stderr, "GetOutPtr()[ncsg_out_buffnum]\n" );
	      exit( 213 );
	    }
	    if((ncsg_out_buffdim
		=(int *)malloc(sizeof(int)*buff_max_number))
	       == NULL ){
	      fprintf( stderr, "GetOutPtr()[ncsg_out_buffdim]\n" );
	      exit( 213 );
	    }
	    break;
	  }		/* if */
	}
	/* printf( "bmax = %d\n", buff_max_number); */
	return( buff_max_number );
}

int
GetOutPtr( fd_out, out_name, buff_max_number )
int	fd_out;
char	out_name[];
int     buff_max_number;
{
	int	r_size, mtype;
	long	offset;
	char	*mdl_name, obs_name[SCF_NAME_WID];
	double	*mem_addr=NULL;
	OutFile sc;

	ncsg_nstrd = 0;

	/* Head of RECORD3 -> RECORD2 -> RECORD3 96/10/15 */
	r_size = sizeof(OutFile);
	offset = OUT_RECORD3;
	lseek(fd_out, offset, SEEK_SET);

	while (read(fd_out, (char *) &sc, r_size) == r_size 
				&& sc.type != SCF_EOF) {
	  
	  mdl_name = sc.out.rec3.mdl_name;

	  switch( sc.type ) {
	    case SCF_OUT_BUFF_OUT:
	      mtype = string_ana( mdl_name, ncsg_outtblptr, MODE0 );
	      if( mtype == 0 ){
		Mismatch( 1, out_name );
	      }
	      mem_addr = ncsm_outptr[mtype - 1];
	      
	      break;

	    case SCF_OUT_BUFF_EXIN:
	      mtype = string_ana( mdl_name, ncsg_xintblptr, MODE0 );
	      if( mtype == 0 ){
		Mismatch( 2, out_name );
	      }
	      mem_addr = ncsm_xinptr[mtype - 1];

	      break;

	    case SCF_OUT_BUFF_OBS:
	      mtype = string_ana( mdl_name, ncsg_outtblptr, MODE0 );
	      if( mtype == 0 ){
		Mismatch( 2, out_name );
	      }

	      sprintf( obs_name, "o%02d", (mtype - 1) );
	      strcat( obs_name, sc.out.rec3.obs_name );
#if 0
{
  int i;
  printf("obs_name[%s]\n", obs_name);
  for(i=0; ncsg_obstblptr[i]!=EOS; i++) {
    printf("obs[%s]\n", ncsg_obstblptr[i]);
  }
  fflush(stdout);
}
#endif
              mtype = string_ana( obs_name, ncsg_obstblptr, MODE0 );
	      if( mtype == 0 ){
		Mismatch( 3, out_name );
	      }
	      mem_addr = ncsm_obsptr[mtype - 1];

	      break;
	    default:
		  /* mem_flag = 2;*/
	      break;
	  }		/* switch */

	  ncsg_out_buffnum[ncsg_nstrd] = sc.out.rec3.buff_num;
	  ncsg_out_buffdim[ncsg_nstrd] = sc.out.rec3.buff_dim;
	  ncsg_strdptr[ncsg_nstrd++] = &mem_addr[sc.out.rec3.comp_number];
	  if( buff_max_number < ncsg_nstrd ){
	    exit(231);
	  }
	}			/* while */
	return( TRUE );
}


int
SetMoniBuff( vbuff )
struct moni_buff	*vbuff;
{
	int	nc, buff;
	int     *tmp;

	for (nc = 0; nc < NCS_MONI_NVAR; nc++) {
	  buff = Bsearch(vbuff, nc);
	  if( buff < 0 ){
	    ncsg_vmoniptr[nc] = NULL;
	  }else{
	    ncsg_vmoniptr[nc] = ncsg_strdptr[buff];
	    ncsg_nvmoni++;
	  } 
	  tmp = vbuff->num;
	  ncsg_vbuff[nc] = tmp[nc];
	  tmp = vbuff->dim;
	  ncsg_vbuffdim[nc] = tmp[nc];
	}
	return( TRUE );
}

int 
GetMoniInfo( fd_out )
int	fd_out;
{
	long	offset;
	int	r_size;
	struct moni_buff vbuff;
	struct scf_out  sc;


	/* Head of RECORD1 */
	r_size = sizeof(struct scf_out);
	offset = 0L;
	lseek( fd_out, offset, L_SET );

	ncsg_nvmoni = 0;
	while(read(fd_out, (char *) &sc, r_size) == r_size 
					&& sc.type != SCF_EOF) {

	  switch (sc.type) {
	    case SCF_OUT_MONITOR:
	      ncsg_monimode = sc.out.rec1.monitor_mode;

	      if (ncsg_monimode != '1'){
		break;
	      }	else {
		vbuff.num = sc.out.rec1.vmoni_buffnum;
		vbuff.dim = sc.out.rec1.vmoni_buffdim;
		
		SetMoniBuff(&vbuff);
	      }	
	      break;

	    case SCF_OUT_FILE:
	      ncsg_strflg = sc.out.rec2.strf_flag;
	      strcpy(ncsg_strfile, sc.out.rec2.strf_name);
	      break;

	  }		/* switch */
	}			/* while */
	return( TRUE );
}


/*****************************************************************************
FUNCTION  NCSF_RDDLY
******************************************************************************
READ DELAY INFORMATION FILE

return( 0 ) : success;
return( 1 ) : error;

on UNIX                                     Coded by S.Hitomi   10/05/1989
*****************************************************************************/

int 
ncsf_rddly( scfn )
char 	scfn[];
{
	struct scf_dly  sc;

	int             fd_dly, r_size, id = 0;
	char            dly_name[FNAME_WD];
	short           delay_flag;

	sprintf( dly_name, "%s.%s", scfn, NCS_DLY_EXTN );

	if( (fd_dly = open(dly_name, O_RDONLY)) == FCNTL_ERROR ){
	  exit(201);
	}

	/* Head of .DLY file */
	r_size = sizeof( struct scf_dly );

	delay_flag = 0;
	while (read(fd_dly, (char *) &sc, r_size) == r_size 
	       && sc.type != NCS_SCF_EOF) {

	  if( sc.type == '1' ) {
	    if( id < 0 ) { 
	      printf( "Module or Input variable Name Mismatch in '%s'\n", 
		      dly_name);
	      exit(224);
	    }

	    ncsg_dlytime[id] = sc.delay.time;	 
	    ncsg_dlyinit_flg[id] = sc.delay.init_flag;
	    if(sc.delay.init_flag != 'A' ) {
	      ncsg_dlyinit[id] = sc.delay.init_out;
	    }
	    ncsg_qsize[id] = (long)( sc.delay.time / ncsg_calstep );
	    if( ncsg_qsize[id] != 0 ){
	      delay_flag = 1; 
	    }
	    if( ncsg_intg_method == 'R' ){
	      ncsg_qsize[id] *= 4;
	    }
			
	    id++;
	  }		/* if */
	}			/* while */

	if( ncsg_intg_method == 'F' && delay_flag ){
	  exit(208);
	}

	if( close(fd_dly) == FCNTL_ERROR ){
	  exit(203);
	}
	return( SUCCESS );
}

/*****************************************************************************
FUNCTION  ncsf_FreeOutBuffer
******************************************************************************
for Free Memory

on UNIX                                     Coded by A.I   5,Oct.,'96
*****************************************************************************/
void ncsf_FreeOutBuffer()
{
  free( ncsg_strdptr );
  free( ncsg_out_buffnum );
  free( ncsg_out_buffdim );
}
