/******************************************************************************

		NEURAL CIRCUIT SIMULATOR SIMULATION PROGRAM                    
                  	   MAIN ROUTINE for NPE

    $Id: ncssnpe.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef TITAN
#include <vmath.h>
#else
#include <math.h>
#endif

#include "ncsdef.h"
#include "macro.h"
#include "common.h"
#include "comlib.h"
#include "ncssstrc.h"
#include "ncssfdl.h"
#include "ncssmain.h"
#include "ncssbuff.h"
#include "ncssscf.h"
#include "ncssrscf.h"
#include "ncsssate.h"

typedef void    (*VoidFunc) ();

extern void 	initvalue	_ANSI_ARGS_(( double **Ncs_y ));

double        **y, **yp;
float         **buffer;
VoidFunc         Integrl;
int           rr_end;

int	calc_end, str_period;
float   report_end;
int     data_point;

extern	long ncsg_bufperiod;

void 
ncsf_strd2( nstrd, mem_index, dptr )
int	nstrd, mem_index;
double  *dptr[];
{
	register int    buff_num;
	float           f_data=0.0;
	double          data;
	extern unsigned int NumWave;
	extern double 	**NcsOutput;

	for( buff_num = 0; buff_num < NumWave; buff_num++ ){

	  data = *dptr[buff_num];

	  if( data > 1.e+37 ){
	    f_data = 1.e+37;
	  }
	  if( data < -1.e+37 ){
	    f_data = -1.e+37;
	  }
	  if( -1.e+37 <= data && data <= 1.e+37 ){
	    if (fabs(data) < 1.e-36){
	      f_data = 0.;
	    } else {
	      f_data = (float) data;
	    }
	  }		/* if */

	  ncsg_buffer[buff_num][mem_index] = f_data;
	  NcsOutput[buff_num][mem_index] = data;
	}			/* for */

}				/* ncsf_strd2() */

/*****************************************************************************
FUNCTION  NCSF_DATAOUT
******************************************************************************
STORE THE RESULTS OF CALCULATION

MSC Ver.5.1                                      Coded by A.Anzai   06/17/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

void 
ncsf_dataout2( index, strd_cnt )
int  	index;
long 	strd_cnt;
{
	ncsf_strd2( ncsg_nstrd, index,  ncsg_strdptr );
	if( (strd_cnt % ncsg_bufperiod) == 0 ){
	  ncsf_StoreData(index, ncsg_nstrd);
	}
}				/* ncsf_dataout2() */

/******************************************************************************
*          Cell counter  Modify function                                      *
*                 : Calling from Main function                                *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

VoidFunc
ncsf_integset( integ_method )
char	integ_method;
{
	int	type;
	void	EulerIntgrl(), AdapIntgrl(), RKG4Intgrl();

#ifdef TITAN
#pragma ASIS
#endif
	for( type = 0; type < ncsg_ntout; type++ ){
	  if( ncsg_ncout[type] > ncsg_cell ){
	    ncsg_ncout[type] = ncsg_cell;
	  }
	}

	switch( integ_method ){
	  case 'E':
	    return( EulerIntgrl );
	    break;
	  case 'F':
	    return( AdapIntgrl );
	    break;
	  case 'A':
	    return( AdapIntgrl );
	    break;
	  case 'R':
	    return( RKG4Intgrl );
	    break;
	  default:
	    break;
	}

	return( NULL );
}



/******************************************************************************
*          Calling from AdapIntegrl function                                  *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

void
cf( t, ncs_y, ncs_dy )
double	t, **ncs_y, **ncs_dy;
{
	NCS_TIME = t;

	/*
	 * setting up of external input values 
	 */
	ncsf_xinset( ncsg_nxinc, ncsg_xindata, ncsg_xfpdata, ncsg_xinfaddr );

	/*
	 * NETWORK() is produced by preprocessor 
	 */
	NETWORK( t, ncs_y, ncs_dy );

	/* update memory contents */
	ncsf_update( ncsg_ntout, ncsg_ncout, ncsm_outptr, ncsm_subptr );
}



/******************************************************************************
*          NCS Simulation Program Main function                               *
*                                            Coded by S.Hitomi  09/05/1990    *
******************************************************************************/

void 
ncsReadConditionFile()
{
	/*
	 * setting up of constants (This function is produced by
	 * preprocessor.) 
	 */
	ncsf_constset();

	/* preparation of exinput buffer information */
	ncsg_buff_info = plist_create( PL_ERROR_DISP );
	ncsg_buff_info_p = plist_go_top( ncsg_buff_info );
	exbuff_num = 0;

	/* reading of simulation conditions */
	if( ncsf_scfread() == ERROR ){
	  printf("Simulation Condition File Reading Error !!\n");
	  exit(219);
	}

	/* setting up of simulation conditions */
	ncsf_scset( &data_point, &calc_end, &str_period, &report_end );

	/* setting up of integration conditions */

	/* Integration Information Setting    */
	Integrl = ncsf_integset( ncsg_intg_method );

	/* Memory Allocation ... y, yp, buffer */
	ncsf_memalloc( ncsg_nstrd, data_point );
	ncsg_buffer = buffer;

	/* initializing states of components */
	ncsf_initset();

}


void 
ncsxstart1()
{
        int 	index = 0;
	int	iflag;
	double  time;
	long    calc_cnt, strd_cnt;

	/*
	 * initial value set for Integration ( This function is produced by
	 * preprocessor ) 
	 */

	initvalue( y );

	/* ----------------------------------------------------------------- */
	/* Start of Calculation for Time = 0                 */
	/* ----------------------------------------------------------------- */
	/* Integration taking one step ( initialize ) */
	iflag = 1;

	ncsg_cdpoint = 0;
	time = 0.0;

	/* Initialize of Module output (time = -1) */
	ncsg_delay_flag = OUTPUT_INIT;
	cf( time, y, yp );

	/* Initialize of queue */
	ncsg_delay_flag = DELAY_INIT_SET;
	cf( time, y, yp );

	ncsg_delay_flag = CALCULATE;

	(* Integrl)( cf, time, ncsg_calstep, ncsg_cell, ncsg_neqn, y,
		     &ncsg_relerr, &iflag );

	/* storing of results into ISPP buffer area */
	strd_cnt = 0;
	ncsf_dataout2( index++, strd_cnt );

	/* ----------------------------------------------------------------- */
	/*                 End of Calculation for Time = 0                   */
	/* ----------------------------------------------------------------- */

	/* ----------------------------------------------------------------- */
	/* Start of Calculation routine                      */
	/* ----------------------------------------------------------------- */
	for( calc_cnt = 0; calc_cnt < calc_end; calc_cnt++ ){

		/* for interporation (Buffer Input) */
		ncsg_cdpoint = (int) calc_cnt;

		time = ((double) calc_cnt) * ncsg_calstep;
		strd_cnt = calc_cnt + 1;
		
		/*
		 * Integration taking one step NETWORK() is produced by
		 * preprocessor in cf(). 
		 */

		(*Integrl)( cf, time, ncsg_calstep, ncsg_cell, ncsg_neqn, y,
			    &ncsg_relerr, &iflag );

		/* storing of results into buffer area */
		if( strd_cnt % str_period == 0 ){
		  ncsf_dataout2( index++, strd_cnt );
		}		/* if */
	}			/* FOR */

	/* ----------------------------------------------------------------- */
	/* Saving  data into SATELITE Data Buffer               */
	/* ----------------------------------------------------------------- */
	ncsf_StoreData(data_point, ncsg_nstrd); 

	/* ----------------------------------------------------------------- */
	/* End of Calculation routine                        */
	/* ----------------------------------------------------------------- */
}


void ncsPostProcess()
{
  	remove_all_exbuf_info( ncsg_buff_info ); 
	ncsf_FreeOutBuffer();
}
