/*****************************************************************************

   	Function Library to Control NCS Simulation Condition File

    $Id: scf.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */
#include <string.h>

#include "common.h"
#include "scflib.h"

char	*scf_work_dir;

/*
 *  Open simulation condition file(SCF)
 * 	char *fname : file name of file
 *      Return      : advance the file potion indicator.
 *                    TRUE : success.
 *                    FALSE : failed.
 */
FILE *OpenSCF( fname )
char 	*fname;
{
  	FILE 		*fp;

	if( (fp = fopen( fname, "r+" )) == NULL ){
	  return( NULL );
	} else {
	  return( fp );
	}
}

/*
 *  Open simulation condition file(SCF)
 * 	char *fname : file name of file
 *      Return      : advance the file potion indicator.
 *                    TRUE : success.
 *                    FALSE : failed.
 */
FILE *CreateSCF( fname )
char 	*fname;
{
  	FILE 		*fp;

	if( (fp = fopen( fname, "w" )) == NULL ){
	  return( NULL );
	} else {
	  return( fp );
	}
}


/*
 *  Close Simulation condition file(SCF)
 * 	FILE  *fp   : file pointer of file
 */
int
CloseSCF( fp )
FILE 	*fp;
{
  	return( fclose( fp ) );
}

/*
 *  Read one entry from SCF file
 * 	FILE *fp : file pointer of SCF file
 * 	void *buf: storing at the location 
 *      int  size: read size bytes long.
 *      Return   : advance the file potion indicator.
 *                 1 : success.
 *                 0 : failed.
 */
int
ReadSCF( fp, buf, size )
FILE    *fp;
void	*buf;
int	size;
{
  	return( fread( buf, size, 1, fp ) );
}


/*
 *  Write one entry to SCF file
 * 	FILE *fp : file pointer of SCF file
 * 	void *buf: reading at the location 
 *      int  size: read size bytes long.
 *      Return   : advance the file potion indicator.
 *                 1 : success.
 *                 0 : failed.
 */
int
WriteSCF( fp, buf, size )
FILE    *fp;
void	*buf;
int	size;
{
  	int 	tmp;
	tmp = fwrite( buf, size, 1, fp );
	fflush( fp );
  	return( tmp );
}


/*
 *  set path of working directory for SCF files
 * 	char *path : path of working directory
 *      Return     : 1 : success.
 *                   0 : failed.
 */
int
SetWorkDirSCF( path )
char	*path;
{
  	if( path == NULL ){
	  return( FALSE );
	}
	if( scf_work_dir != NULL ){
	  free( scf_work_dir );
	}
	scf_work_dir = strdup( path );
	
  	return( TRUE );
}

/*
 *  get path of working directory for SCF files
 *      Return     : path of working directory : success.
 *                   NULL                      : failed.
 */
char *
GetWorkDirSCF()
{
  	return( scf_work_dir );
}
