/*****************************************************************************
  
   	  Function Library to Control NCS Simulation Condition File 
  	       	     for information of DELAY variables

    $Id: scfdly.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFDLY_H_
#define _SCFDLY_H_

#define  SCF_DLY_EXTN   "dly"     /* file extension of simulation condition */

/* DELAY INFORMATION */
struct delay_info {
  char     mdl_name[SCF_NAME_LEN];          /* 33 bytes */
  char     inp_name[SCF_NAME_LEN];          /* 33 bytes */
  double   time;                            /*  8 bytes */
  double   init_out;                        /*  8 bytes */
  char     init_flag;                       /*  1 bytes */
};                                          /* 83 bytes */ 

struct scf_dly {
  char   type;                              /*  1 bytes */
  struct delay_info  delay;                 /* 83 bytes */
};                                          /* 84 bytes */

typedef struct scf_dly	DlyFile;

/* type information: scf_delay.type */
#define SCF_DLY_TYPE_NORMAL	('1')	/* normal type       */

/* type information: scf_mat.type */
#define SCF_DLY_FLAG_AUTO 	('A')	/* normal type       */
#define SCF_DLY_FLAG_FIX 	('F')	/* normal type       */


extern int  DlyMakeSCF		_ANSI_ARGS_(( void ));
extern int  DlyAddInfoSCF	_ANSI_ARGS_(( DlyFile *add ));
extern int  DlyPutInfoSCF	_ANSI_ARGS_(( DlyFile *add, int n ));
extern int  DlySetInfoSCF	_ANSI_ARGS_(( DlyFile *src, char *mdl_name, 
					      char *inp_name, double time, 
					      double init_out, char *flag ));
extern int  DlyWriteInfoSCF	_ANSI_ARGS_(( DlyFile *src ));
extern int  DlyGetInfoSCF	_ANSI_ARGS_(( DlyFile *src, int n ));
extern int  DlySearchInfoSCF	_ANSI_ARGS_(( DlyFile *cmp ));
extern int  DlyDeleteInfoSCF	_ANSI_ARGS_(( int n ));
extern int  DlyDeleteAllInfoSCF _ANSI_ARGS_(( void ));
extern int  DlyListupSCF	_ANSI_ARGS_(( FILE *disp ));

#endif /* _SCFDLY_H_ */
