/*****************************************************************************

   	Function Library to Control NCS Simulation Condition File 

    $Id: scflib.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFLIB_H_
#define _SCFLIB_H_

#define	SCF_ERROR	(0)
#define	SCF_SUCCESS	(1)
#define SCF_ALL_MATCH	(-1)

#define SCF_EOF		('\0')
#define SCF_ERASED	('0')

#ifndef SCF_NAME_LEN
#define SCF_NAME_LEN    (33)
#endif
#ifndef SCF_NAME_WID
#define  SCF_NAME_WID      36 
#endif

extern FILE *OpenSCF		_ANSI_ARGS_(( char *fname ));
extern FILE *CreateSCF		_ANSI_ARGS_(( char *fname ));
extern int   CloseSCF		_ANSI_ARGS_(( FILE *fp ));
extern int   ReadSCF		_ANSI_ARGS_(( FILE *fp, void *buf, int size ));
extern int   WriteSCF		_ANSI_ARGS_(( FILE *fp, void *buf, int size ));
extern int   SetWorkDirSCF	_ANSI_ARGS_(( char *path ));
extern char *GetWorkDirSCF	_ANSI_ARGS_(( void ));

#endif /* _SCFLIB_H_ */
