/*****************************************************************************
  
   	Function Library to Control NCS Simulation Condition File 
  	       for information of MATHEMATICAL variables
  
    $Id: scfmat.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFMAT_H_
#define _SCFMAT_H_

/* Integration method & Condition file */
struct integal_info {
  char     method;                          /*  1 byte  */
  int      maxcell;                         /*  4 bytes */
  double   relerr;                          /*  8 bytes */
};                                          /* 13 bytes */

/* Mode and timer data file */
struct scf_mat {
  char   type;                              /*  1 byte  */
  char   mode;                              /*  1 byte  */
  union  time_data {
    double  sim_timer[4];                   /* 24 bytes */
    long    iteration[4];                   /* 12 bytes */
  } timer;                                  /* 24 bytes */
  struct integal_info integral;             /* 13 bytes */ 
};                                          /* 39 bytes */

typedef struct scf_mat	MatFile;

#define  SCF_MAT_EXTN   "mat"     /* file extension of simulation condition */

/* type information: scf_mat.type */
#define SCF_MAT_TYPE_NORMAL	('1')	/* normal type       */

/* method of integration: integral_info.method */
#define SCF_MAT_INTEG_EULER	('E')
#define SCF_MAT_INTEG_RKG	('R')
#define SCF_MAT_INTEG_FERBERG	('F')

extern int  MatMakeSCF		_ANSI_ARGS_(( void ));
extern int  MatAddInfoSCF	_ANSI_ARGS_(( MatFile *add ));
extern int  MatPutInforSCF	_ANSI_ARGS_(( MatFile *add, int n ));
extern int  MatSetInfoSCF	_ANSI_ARGS_(( MatFile *src, 
					      double last_time, 
					      double calc_time, 
					      double store_time, 
					      double write_time, 
					      char *integ_method, 
					      int integ_maxcell, 
					      double integ_relerr ));
extern int  MatSearchInfoSCF	_ANSI_ARGS_(( MatFile *cmp ));
extern int  MatWriteInfoSCF	_ANSI_ARGS_(( MatFile *src ));
extern int  MatGetInfoSCF	_ANSI_ARGS_(( MatFile *str, int n ));
extern int  MatTimeListupSCF	_ANSI_ARGS_(( FILE *disp ));
extern int  MatIntegListupSCF	_ANSI_ARGS_(( FILE *disp ));

#endif /* _SCFMAT_H_ */
