/*****************************************************************************
  
       Function Library to Control NCS Simulation Condition File 
  	           for name of model source file etc.

    $Id: scfn.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef  HAVE_STDLIB_H
#include <stdlib.h>
#endif  /* HAVE_STDLIB_H */
#ifdef  HAVE_MALLOC_H
#include <malloc.h>
#endif  /* HAVE_MALLOC_H */
#include <string.h>
#ifdef  HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#include "common.h"
#include "scflib.h"
#include "scfn.h"

static void	MakeSCFN	_ANSI_ARGS_(( void ));
static char	*ReadSCFN	_ANSI_ARGS_(( char *mfile, 
					      char *hfile, 
					      char *lfile ));
static int	WriteSCFN	_ANSI_ARGS_(( char *mfile, 
					      char *header, 
					      char *lib ));
static int 	CheckAccessSCF	_ANSI_ARGS_(( char *fname ));


/*
 * Create simulation condition file from SCFN file.
 */
static void
MakeSCFN()
{
  	FILE	*fp;
	char	*path;
	char	buff[SCF_SCFN_PATH_SIZE];

	if( (path=GetWorkDirSCF()) != NULL ){
	  strcpy( buff, path );
	  strcat( buff, SCF_SCFN_NAME );
	} else {
	  return;
	}
	if( (fp=fopen(buff,"w")) == NULL ){
	  return;
	}

	buff[0] = '\n';
	buff[1] = '\0';
	fputs( buff, fp );
	fputs( buff, fp );
	fputs( buff, fp );
	putc( EOS, fp );

	fclose( fp );
}

/*
 * Read file name of simulation condition file from SCFN file.
 *	char 	*mfile : name of model source file
 *	char 	*hfile : name of header file for library defined by user.
 *	char 	*lfile : name of library file defined by user.
 */
static char	*
ReadSCFN( mfile, hfile, lfile )
char    mfile[];
char    hfile[];
char    lfile[];
{
	FILE	*fp;
	char	*path;
	char	buff[SCF_SCFN_PATH_SIZE];
	int	i, j;

	if( (path=GetWorkDirSCF()) != NULL ){
	  strcpy( buff, path );
	  strcat( buff, SCF_SCFN_NAME );
	} else {
	  return( NULL );
	}
	if( access(buff, R_OK ) == -1 ){
	  MakeSCFN();
	  mfile[0] = '\0';
	  hfile[0] = '\0';
	  lfile[0] = '\0';
	  return( mfile );
	}
	if( (fp=fopen(buff, RDONLY)) == NULL ){
	  return( NULL );
	}else{
	  i = 0; 
	  j = 0;
	  mfile[0] = '\0';
	  hfile[0] = '\0';
	  lfile[0] = '\0';
	  while( (buff[i++]=getc(fp)) != EOF )
	    if( buff[i-1] == '\n' ){
	      buff[i-1] = '\0';
	      switch( j ){
		case 0:
		  strcpy( mfile, buff );
		  j++;
		  i = 0;
		  break;
		case 1:
		  strcpy( hfile, buff );
		  j++;
		  i = 0;
		  break;
		case 2:
		  strcpy( lfile, buff );
		  j++;
		  i = 0;
		  break;
		default:
		  break;
	      }
	    }
	  fclose( fp );
	}			/* else */
	return( mfile );
}

/*
 * Write modele source file name of simulation condition file to SCFN file.
 *	char 	*path  : directory path of SCFN file
 *	char 	*mfile : name of model source file
 */
static int 
WriteSCFN( mfile, header, lib )
char	mfile[];
char    header[];
char    lib[];
{
  	FILE	*fp;
	char	*path;
	char	buff[SCF_SCFN_PATH_SIZE];
	char	*model_name=NULL, *header_name=NULL, *lib_name=NULL;

	if( mfile != NULL ){
	  strcpy( buff, mfile );
	  strcat( buff, "\n\0" );
	  model_name = strdup( buff );
	} else {
	  return( FALSE );
	}
	if( header != NULL ){
	  strcpy( buff, header );
	  strcat( buff, "\n\0" );
	  header_name = strdup( buff );
	} else {
	  buff[0] = '\n';
	  buff[1] = '\0';
	  header_name = strdup( buff );
	}
	if( lib != NULL ){
	  strcpy( buff, lib );
	  strcat( buff, "\n\0" );
	  lib_name = strdup( buff );
	} else {
	  buff[0] = '\n';
	  buff[1] = '\0';
	  lib_name = strdup( buff );
	}

	if( (path=GetWorkDirSCF()) != NULL ){
	  strcpy( buff, path );
	  strcat( buff, SCF_SCFN_NAME );
	} else {
	  return( FALSE );
	}
	if( (fp=fopen(buff,"w")) == NULL ){
	  return( FALSE );
	}
	fputs( model_name, fp );
	fputs( header_name, fp );
	fputs( lib_name, fp );
	putc( EOS, fp );

	fclose( fp );

	free( model_name );
	free( header_name );
	free( lib_name );
	return( TRUE );
}


/*
 * Read file name of simulation condition file from SCFN file.
 *	char 	*path  : directory path of SCFN file
 *	char 	*mfile : name of model source file
 *	char 	*hfile : name of header file for library defined by user.
 *	char 	*lfile : name of library file defined by user.
 */
char	*
GetSCFN( mfile, hfile, lfile )
char    mfile[];
char    hfile[];
char    lfile[];
{
	return( ReadSCFN( mfile, hfile, lfile ) );
}

/*
 * Read model source name of simulation condition file from SCFN file.
 *	char 	*model : name of model source file
 */
char	*
ModelNameSCFN( model )
char    model[];
{
  	char    *pointer;
  	char	mfile[SCF_SCFN_PATH_SIZE];
  	char	buff1[SCF_SCFN_PATH_SIZE], buff2[SCF_SCFN_PATH_SIZE];

  	if( ReadSCFN( mfile, buff1, buff2 ) != NULL ){
	  if( ( pointer = strrchr( mfile, '/' ) ) != NULL ){
	    strcpy( model, pointer+1 );
	  }else{
	    strcpy( model, mfile );
	  }
	} else {
	  return( NULL );
	}

	return( model );
}


/*
 * Write modele source file name of simulation condition file to SCFN file.
 *	char 	*path  : directory path of SCFN file
 *	char 	*mfile : name of model source file
 */
int 
SetSCFN( mfile, header, lib )
char	mfile[];
char    header[];
char    lib[];
{
	return( WriteSCFN( mfile, header, lib ) );
}


/*
 *  accessable check files
 *	char *fname : file (path) name
 *	RETURN      : TRUE  : OK
 *		    : FALSE : failed
 */
static int 
CheckAccessSCF( fname )
char 	*fname;
{
  	if( fname[0] != '\0' ){
	  if( access( fname, R_OK ) == -1 ){
	    fprintf( stderr, "File name = \"%s\" \n", fname );
	    return( FALSE );
	  }
	}
	return( TRUE );
}

/*
 * get and set modele source file name to SCFN file.
 *	char 	*path  : directory path of SCFN file
 *	char 	*mfile : name of model source file
 */
char *
GetAllFilesSCFN( marg, harg, larg )
char 	marg[];
char 	harg[];
char 	larg[];
{
	char 	mfile[SCF_SCFN_PATH_SIZE];
	char 	hfile[SCF_SCFN_PATH_SIZE];
	char 	lfile[SCF_SCFN_PATH_SIZE];

	/* there is no argument */
	if( GetSCFN( mfile, hfile, lfile ) == NULL ){
	  if( mfile == '\0' ){ 
	    return( NULL );
	  } else {
	    sprintf( mfile, "%s.%s", marg, SCF_MODEL_EXTN );
	  }
	}
	if( hfile == '\0' ){
	  if( harg[0] != '\0' ){
	    strcpy( hfile, harg );
	    if( larg[0] != '\0' ){
	      strcpy( lfile, larg );
	    }
	  }
	}

	/* check access of model file */
	if( access( mfile, F_OK ) == -1 ){
	  fprintf( stderr, "Model file name = \"%s\" \n", mfile );
	  return( NULL );
	}
	
	if( ( CheckAccessSCF( mfile ) == FALSE ) ||
	    ( CheckAccessSCF( hfile ) == FALSE ) ||
	    ( CheckAccessSCF( hfile ) == FALSE ) ){ 
	  return( NULL );
	}

	/* set to SCF */
	strcpy( mfile, marg );
	strcpy( hfile, harg );
	strcpy( lfile, larg );
	if( SetSCFN( marg, harg, larg ) == FALSE ){
	  return( NULL );
	}

	return( marg );
}

/*
 * Write modele source file name of simulation condition file to SCFN file.
 * for nasign command.
 *	char 	*mfile : name of model source file
 *	char 	*file1 : file name
 *	char 	*file2 : file name
 */
int 
SignSCFN( mfile, file1, file2 )
char	mfile[];
char    file1[];
char    file2[];
{
  	char	*pointer;
  	char	*model;
	char	*header;
	char	*lib;
	int 	flag;

	/*** model file name ***/
	model = strdup( mfile );
	pointer = strrchr( model, '.' );
	if( (pointer != NULL) && (strcmp( pointer, SCF_MODEL_EXTN ) == 0) ){
	  *pointer = '\0';
	}

	/*** file name of header and library ***/
	if( (file1 != NULL) && (strlen(file1)!=0)){
	  /* argument 2 was seted */
	  if( (file2 == NULL) || (strlen(file2)==0)){
	    /* argument 3 was seted */
	    pointer = (char *)strrchr( file1, '.' );
	    if( strcmp( pointer+1, SCF_HDF_EXTN ) != 0 ){
	      /* argument1 was a name of header file */
	      lib = strdup( file1 );
	      header = strdup( "\0" );
	      /*header_name[0] = NULL;*/
	    }else{
	      /* argument1 was a name of library */
	      header = strdup( file1 );
	      lib = strdup( "\0" );
	      /*strcpy( header_name, file_name1 );
	      lib_name[0] = NULL;*/
	    }
	  }else{
	    header = strdup( file1 );
	    lib = strdup( file2 );
	  }
	}else{
	  header = strdup( "\0" );
	  lib = strdup( "\0" );
	      /*header_name[0] = NULL;
	  lib_name[0] = NULL;*/
	}
  	
	flag = WriteSCFN( model, header, lib );
	free( model );
	free( header );
	free( lib );
	return( flag );
}

/*
 *  Print list of all entry file names of simulation condition file.
 * 	FILE *disp  : output file
 *      Return      : success : number of lines of lists
 *                    0       : failed
 */
int
ListupSCFN( disp )
FILE	*disp;
{
  	int	row = 0;
	char	mfile[SCF_SCFN_PATH_SIZE];
	char	hfile[SCF_SCFN_PATH_SIZE];
	char	lfile[SCF_SCFN_PATH_SIZE];

	if( ReadSCFN( mfile, hfile, lfile ) == NULL ){
	  return( 0 );
	}
	if( strlen( mfile ) == 0 ){
	  fprintf( disp, "Current Simulation Condition File Name: none\n" );
	}else{
	  fprintf( disp, "Current Simulation Condition File Name: %s\n",
		   mfile );
	}
	row++;

	if( strlen( hfile ) > 1 ){
	  fprintf( disp, "User's Library Header File Name : %s\n", hfile );
	  row++;
	}

	if( strlen( lfile ) > 1 ){
	  fprintf( disp, "User's Library File Name : %s\n", lfile );
	  row++;
	}

	return( row );
}
