/*****************************************************************************

	   Function Library to Control NCS Simulation Condition File 
   		   for information of OBSERVABLE variables

    $Id: scfobs.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFOBS_H_
#define _SCFOBS_H_

#define  SCF_OBS_EXTN   "obs"     /* file extension of simulation condition */
#define  SCF_OBS_NORMAL	('1')

/* OBSERVABLE INFORMATION */
struct observable_info {
  char   type;                          
  struct obs_info {
    char module[SCF_NAME_LEN];
    int  max_comp;
    char var[SCF_NAME_LEN];
  } info;
};

typedef struct observable_info ObsFile;

extern int   ObsMakeSCF		_ANSI_ARGS_(( void ));
extern int   ObsAddInfoSCF	_ANSI_ARGS_(( ObsFile *add ));
extern int   ObsGetInfoSCF	_ANSI_ARGS_(( ObsFile *src ));
extern int   ObsSearchInfoSCF	_ANSI_ARGS_(( ObsFile *cmp ));
extern int   ObsListupSCF	_ANSI_ARGS_(( FILE *disp ));
extern int   ObsSetInfoSCF	_ANSI_ARGS_(( ObsFile *src, char *mdl_name,
					      int comp, char *var_name ));

#endif  /* _SCFOBS_H_ */


