/*****************************************************************************
  
	   Function Library to Control NCS Simulation Condition File 
   			for information of OUTPUTS 
  
    $Id: scfout.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFOUT_H_
#define _SCFOUT_H_

/* OUTPUT DATA FILE */
struct scf_out {
  char   type;                              /*  1 byte  */
  union  out_data {
    struct out_rec1 {
      char   monitor_mode;                  /*  1 byte  */
      int    vmoni_buffnum[NCS_MONI_NVAR];  /* 16 bytes */
      int    vmoni_buffdim[NCS_MONI_NVAR];  /* 16 bytes */
    } rec1;                                 /* 33 bytes */
    struct out_rec2 {
      char   strf_flag;                     /*  1 byte  */
      char   strf_name[NCS_DATA_FNAME];     /* 22 bytes */
    } rec2;                                 /* 23 bytes */
    struct out_rec3 {
      int    buff_num;                      /*  4 bytes */
      char   buf_name[NCS_BUF_NAME_LEN];    /* 32 bytes */
      int    buff_dim;                      /*  4 bytes */ /* for nmout */
      char   mdl_name[SCF_NAME_LEN];        /* 33 bytes */
      int    comp_number;                   /*  4 bytes */
      char   obs_name[SCF_NAME_WID];        /* 36 bytes */
    } rec3;                                 /*113 bytes */
    struct out_rec4 {
      int    max_number;		    /*  4 bytes */
    } rec4;
  } out;                                    /*113 bytes */
};                                          /*114 bytes */

typedef struct scf_out OutFile;

#define  SCF_OUT_EXTN   "out"     /* file extension of simulation condition */

#ifndef OFSET_HEAD
#define  OFFSET_HEAD 0L
#endif
#ifndef READ_ERR
#define  READ_ERR    -1
#endif

#define  OUT_RECSIZE		(sizeof(struct scf_out))
#define  OUT_RECORD1		(0)
#define  OUT_RECORD2		(OUT_RECSIZE)
#define  OUT_RECORD3		(OUT_RECSIZE*2)
#define  OUT_RECORD4		(OUT_RECSIZE*3)

/* OUTPUT BUFFER INFOMATION: scf_out.type */
#define SCF_OUT_BUFF_OUT	('1')	/* from output statement       */
#define SCF_OUT_BUFF_EXIN	('2')   /* from exinput statement      */
#define SCF_OUT_BUFF_OBS	('3')   /* from observable statement   */
#define SCF_OUT_MONITOR		('4')   /* moniter mode                */
#define SCF_OUT_FILE		('5')   /* output data file            */
#define SCF_OUT_BUFF_SIZE	('6')   /* specified max output buffer */
#define SCF_OUT_NO		('7')   /* no assign                   */

/* for mode of monitor buffer */
#define SCF_OUT_MONITOR_MAX	(4)	/* max number of output to monitor */
#define SCF_OUT_MONITOR_NO_CRT	('0')   /* no CRT output                   */
#define SCF_OUT_MONITOR_CRT	('1')   /* values only                     */

#define SCF_OUT_BUFF_MAX       (255)   /* maximum number of variable  */


extern int   OutMakeSCF		 _ANSI_ARGS_(( void ));
extern int   OutAddInfoSCF	 _ANSI_ARGS_(( OutFile *add ));
extern int   OutPutInfoSCF	 _ANSI_ARGS_(( OutFile *add, int n ));
extern int   OutSetInfoSCF	 _ANSI_ARGS_(( OutFile *src, int buf_id, 
					       char *buf_name, int buf_dim, 
					       char *mdl_name, int comp_no, 
					       int type, char *obs_name ));
extern int   OutWriteInfoSCF	 _ANSI_ARGS_(( OutFile *src ));
extern int   OutGetInfoSCF	 _ANSI_ARGS_(( OutFile *src, int n ));
extern int   OutSearchInfoSCF	 _ANSI_ARGS_(( OutFile *cmp ));
extern int   OutDeleteInfoSCF	 _ANSI_ARGS_(( int n ));
extern int   OutDeleteAllInfoSCF _ANSI_ARGS_(( void ));
extern int   OutRemoveInfoSCF	 _ANSI_ARGS_(( OutFile *src, int flag ));
extern int   OutListupSCF	 _ANSI_ARGS_(( FILE *disp ));

#endif /* _SCFOUT_H_ */
