/*****************************************************************************
  
   	Function Library to Control NCS Simulation Condition File
  	         for information of PARAMETER variables

    $Id: scfprm.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifndef _SCFPRM_H_
#define _SCFPRM_H_

/* PARAMETER FILE */
struct scf_prm {
  char   type;                              /*  1 byte  */
  char   mdl_name[SCF_NAME_LEN];            /* 33 bytes */
  char   prm_name[SCF_NAME_WID];            /* 36 bytes */
  union  prm_data {
    double  prm_real;                       /*  4 bytes */
    long    prm_intg;                       /*  4 bytes */
  } prm_val;                                /*  4 bytes */
};                                          /* 82 bytes */

typedef struct scf_prm	PrmFile;

#define  SCF_PRM_EXTN   "prm"     /* file extension of simulation condition */

/* type information: scf_mat.type */
#define SCF_PRM_TYPE_NORMAL	('1')	/* normal type       */
#define SCF_PRM_TYPE_INT	('2')	/* normal type       */

/* flag to display list of parameters */
#define	SCF_PRM_ALL_MDL		"ALL"
#define	SCF_PRM_ALL_MDL_OLD	"-ALL"

extern int  PrmMakeSCF		_ANSI_ARGS_(( void ));
extern int  PrmAddInfoSCF	_ANSI_ARGS_(( PrmFile *add ));
extern int  PrmPutInfoSCF	_ANSI_ARGS_(( PrmFile *add, int n ));
extern int  PrmSetInfoSCF	_ANSI_ARGS_(( PrmFile *src, char *type, 
					      char *mdl_name, char *prm_name, 
					      double data ));
extern int  PrmSearchInfoSCF	_ANSI_ARGS_(( PrmFile *cmp ));
extern int  PrmWriteInfoSCF	_ANSI_ARGS_(( PrmFile *src ));
extern int  PrmGetValueSCF	_ANSI_ARGS_(( PrmFile *src ));
extern int  PrmListupSCF	_ANSI_ARGS_(( FILE *disp, char *module ));

#endif /* _SCFPRM_H_ */
