/*****************************************************************************

   	Function Library to Control NCS Simulation Condition File 
   	for information of EXTERNAL INPUT FUNCTION parameters(XFP)

    $Id: scfxfp.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFXFP_H_
#define _SCFXFP_H_

#ifndef _SCFXIN_H_
#include "scfxin.h"
#endif /* _SCFXIN_H_ */

#define  SCF_XFP_EXTN   "xfp"     /* file extension of simulation condition */
#define  SCF_XFP_MAX	5

/* EXTERNAL INPUT FUNCTION PARAMETER FILE */
struct scf_xfp {
  char    type;                              /*  1 byte  */
  int     func_number;                       /*  4 bytes */
  union   xfp_data { 
    struct xfp_rec1 {
      double  func_para[SCF_XFP_MAX];        /* 40 bytes */
    } rec1;                                  /* 40 bytes */
    struct xfp_rec2 {
      int     buffnum;                       /*  4 bytes */
      int     buffdim;			     /*  4 bytes */
      char    datf_name[SCF_NAME_LEN];       /* 22 bytes */
      char    buffname[SCF_NAME_LEN];        /* 32 bytes */
      int     timebuff;		             /*  4 bytes */
      char    timename[SCF_NAME_LEN];        /* 32 bytes */
    } rec2;                                  /* 98 bytes */
  } xfp;
};                                           /*103 bytes */

typedef struct scf_xfp XfpFile;

/* scf_xfp.type */
#define SCF_XFP_TYPE_PULSE 		('1')
#define SCF_XFP_TYPE_RAMP 		('1')
#define SCF_XFP_TYPE_BUFFER 		('2')
#define SCF_XFP_TYPE_FILE 		('2')
#define SCF_XFP_TYPE_DEFAULT		('1')

/* scf_xfp.func_number */
#define SCF_XFP_FCN_PULSE 		(2)
#define SCF_XFP_FCN_RAMP 		(1)
#define SCF_XFP_FCN_BUFFER 		(4)
#define SCF_XFP_FCN_FILE 		(3)

struct rec_xfdata {
	char            xf_name[SCF_NAME_LEN];
	char            xf_para[5][SCF_NAME_LEN];
	int             xf_npara;
};

typedef struct rec_xfdata Xfpdata;

#define XFP_DATA_FILE	"xfpdatafile"

extern int   XfpMakeSCF			_ANSI_ARGS_(( void ));
extern int   XfpAddInfoSCF		_ANSI_ARGS_(( XfpFile *add ));
extern int   XfpPutInfoSCF		_ANSI_ARGS_(( XfpFile *add, int n ));
extern int   XfpSetInfoSCF		_ANSI_ARGS_(( XfpFile *src, 
						      char *type, 
						      double *val, 
						      char *fname, 
						      char *bname, 
						      char *time ));
extern int   XfpSetDefaultsXfdata	_ANSI_ARGS_(( Xfpdata *data ));
extern int   XfpWriteInfoSCF		_ANSI_ARGS_(( XinFile *cmp, 
						      XfpFile *src ));
extern int   XfpSetStimSCF		_ANSI_ARGS_(( XinFile *sc_xin, 
						      XfpFile *sc_xfp ));
extern int   XfpGetInfoSCF		_ANSI_ARGS_(( XfpFile *src, int n ));
extern int   XfpDeleteInfoSCF		_ANSI_ARGS_(( int n ));
extern int   XfpDeleteAllInfoSCF	_ANSI_ARGS_(( void ));
extern int   XfpRemoveInfoSCF		_ANSI_ARGS_(( XinFile *src, 
						      int aflag ));
extern int   XfpListupSCF		_ANSI_ARGS_(( FILE *disp ));
extern int   XfpListupAllSCF		_ANSI_ARGS_(( FILE *disp ));

#endif /* _SCFXFP_H_ */


