/*****************************************************************************

   	Function Library to Control NCS Simulation Condition File 
   		for information of EXINPUT variables(XIN)

    $Id: scfxin.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _SCFXIN_H_
#define _SCFXIN_H_

#define  SCF_XIN_EXTN   "xin"     /* file extension of simulation condition */

/* EXTERNAL INPUT DATA FILE */
struct scf_xin {
  char   type;	                            /*  1 byte  */
  union  xin_data {
    struct xin_rec1 {
      int    usrxf_nprm;                    /*  4 bytes */
      char   usrxf_name[SCF_NAME_LEN];      /* 33 bytes */
      char   usrxf_pname[SCF_NAME_LEN];     /* 33 bytes */
    } rec1;                                 /* 70 bytes */
    struct xin_rec2 {
      char   usrxf_pname[2][SCF_NAME_LEN];  /* 66 bytes */
    } rec2;                                 /* 66 bytes */
    struct xin_rec3 {
      char   mdl_name[SCF_NAME_LEN];        /* 33 bytes */
      int    comp_number;                   /*  4 bytes */
      int    xfd_number;                    /*  4 bytes */
    } rec3;                                 /* 41 bytes */
  } xin;                                    /* 70 bytes */
};                                          /* 71 bytes */

typedef struct scf_xin XinFile;

/* scf_xin.type */
#define  SCF_XIN_TYPE_NORMAL  '1'

extern int   XinMakeSCF		 _ANSI_ARGS_(( void ));
extern int   XinAddInfoSCF	 _ANSI_ARGS_(( XinFile *add ));
extern int   XinPutInfoSCF	 _ANSI_ARGS_(( XinFile *add, int n ));
extern int   XinSetInfoSCF	 _ANSI_ARGS_(( XinFile *src, char *mdl_name,
					       int comp ));
extern int   XinSearchInfoSCF	 _ANSI_ARGS_(( XinFile *cmp ));
extern int   XinWriteInfoSCF	 _ANSI_ARGS_(( XinFile *src ));
extern int   XinGetInfoSCF	 _ANSI_ARGS_(( XinFile *src, int n ));
extern int   XinDeleteInfoSCF	 _ANSI_ARGS_(( int n ));
extern int   XinDeleteAllInfoSCF _ANSI_ARGS_(( void ));
extern int   XinListupSCF	 _ANSI_ARGS_(( FILE *disp ));

#endif /* _SCFXIN_H_ */


