/*****************************************************************************

            NCS FUNCTIONS FOR SIMULATION PROGRAM ( for SATELITE )
		
    $Id: ncsssate.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"
#include "ncssstrc.h"
#include "ncssfdl.h"
#include "ncsssate.h"

extern int	ncsg_cell, ncsg_neqn;
extern double	**y, **yp;
extern float	**buffer;


/*****************************************************************************
FUNCTION  NCSF_SCFREAD
******************************************************************************
READ SIMULATION CONDITION

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

int 
ncsf_scfread()
{
	char	tmp[FNAME_WD], scfn[FNAME_WD];

	resat();

	SetWorkDirSCF( get_tmpdir() );
	sprintf( scfn, "%s%s", get_tmpdir(), ModelNameSCFN( tmp ) );

	if( ncsf_rdmat(scfn) == ERROR ){
	  return( ERROR );
	}

	if( ncsf_rdxinfo(scfn) == ERROR ){
	  return( ERROR );
	}

	if( ncsf_rdprm(scfn) == ERROR ){
	  return( ERROR );
	}

	if( ncsf_rdout(scfn) == ERROR ){
	  return( ERROR );
	}

	if( ncsf_rddly(scfn) == ERROR ){
	  return( ERROR );
	}

	return (SUCCESS);
}				/* ncsf_scfread() */

void 
ncsf_memalloc( nbuff, dpoint )
int	nbuff, dpoint;
{
	/* Memory allocation for Integlation */
	y  = (double **) alloc2d(ncsg_cell, ncsg_neqn, sizeof(double));
	yp = (double **) alloc2d(ncsg_cell, ncsg_neqn, sizeof(double));

	/* Memory allocation for Data buffer */
	buffer = (float **) alloc2d(nbuff, dpoint, sizeof(float));
}


void 
ncsf_strd( nstrd, mem_index, dptr )
int	nstrd;		/* number of buffers to out */
int     mem_index;      /* number of *store* data point */
double  **dptr;		/* address of out data */
{
	register int    buff_num;
	float           f_data=0.0;
	double          data;

	for( buff_num = 0; buff_num < nstrd; buff_num++ ){
	  data = *dptr[buff_num];
		
	  if ( data > 1.e+37 ){
	    f_data = 1.e+37;
	  }
	  if ( data < -1.e+37 ){
	    f_data = -1.e+37;
	  }

	  if ( -1.e+37 <= data && data <= 1.e+37 ) {
	    if (fabs(data) < 1.e-36){
	      f_data = 0.;
	    } else {
	      f_data = (float) data;
	    }		/* if */
	  }
	  
	  buffer[buff_num][mem_index] = f_data;
	  
	}			/* for */

}				/* ncsf_strd() */


/*
 *   function for Data Store to ISPP buffer 
 *                        Coded by A.Anzai (MSC Ver.5.1)    [06/21/1989]
 *                        Modifid by S.Hitomi (on UNIX)     [08/29/1990]
 *                        Modifid        (on SATELLITE)     [15,Jun.'94]
 */
void
ncsf_StoreData( dpoint, nstrd )
int	dpoint;  /* number of *store* data point (not calculated data) */
int	nstrd; 
{
 	int 	i, j, k;
	int 	buff_num, buff_dim;
	Buffer  *tmpbuffer;
	int     tmpdim, tmpindex[MAX_INDEX];
	int     chdim, chindex[MAX_INDEX];

	if( dpoint == 0 ){
	  return;
	}

	if( (tmpbuffer = AllocBuffer( dpoint )) == NULL ){
	  exit(201);
	}

	for( i = 0; i < nstrd; i++ ){
	  buff_num = ncsg_out_buffnum[i];
	  buff_dim = ncsg_out_buffdim[i];

	  k = 0;
	  for( j = 0; j < dpoint; j++ ){
	    tmpbuffer[j] = buffer[i][j];
	  }
	  
	  tmpdim = 1;

	  chdim = GetBufferInfo( buff_num, chindex );
	  if( chdim == -1 ){
	    fprintf( stderr, "...Warnning: Fail to Write Buffer%d, becase it is not existance.\n", buff_num );
	  }else{
	    if( chdim == 1 ){
	      tmpindex[0] = dpoint;
	      if( WriteBuffer( buff_num, tmpdim, tmpindex, tmpbuffer ) == -1 ){
		exit( 210 );
	      }
	    }else{
	      tmpindex[0] = buff_dim;
	      if( WriteTimeSeries( buff_num, tmpdim, tmpindex,
				   tmpbuffer, dpoint) == -1 ){
		exit( 210 );
	      }
	    }
	  }
	}

	FreeBuffer( tmpbuffer );
}				/* ncsf_StoreData() */
