/**************************************************************************
  
  	Functions to control list structure

$Header: /cvsroot/satellite/satellite2/src/ncs/ncspp/list.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

**************************************************************************/
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include	<stdio.h>
#ifdef HAVE_STDLIB_H
#include	<stdlib.h>
#else
#ifdef HAVE_MALLOC_H
#include	<malloc.h>
#endif /* HAVE_MALLOC_H */
#endif /* HAVE_STDLIB_H */
#include        <string.h>
#include        "common.h"
#include        "list.h"

#ifdef __STDC__

void menu( void );

#else

void menu();

#endif

/*
void main(void)
{       menu();
	List a;
	List b;

	init_list(&a);
	init_list(&b);

	insert("1",1,&a);
	insert("2",2,&a);
	insert("3",3,&a);
	insert("4",4,&a);

	insert("5",1,&b);
	insert("6",2,&b);
	insert("7",3,&b);
	insert("8",4,&b);
	insert("9",5,&b);

	print_list(&a);
	print_list(&b);

	listcat(&a , &b);

	print_list(&a);
	print_list(&b);
}
*/

void 
menu( void )
{
	int	i;
	char    w[256];
	pos	p;
	List	l;
	
	init_list(&l);
	do {	
	  print_list(&l);
	  printf("\n");
	  printf("1...insert   2...delete   3...see   4...locate\n");
	  printf("5...next     6...previous 7...end   8...first\n");
	  printf("others... quit ? ");
	  scanf("%d" , &i);
	  printf("\n");
	  switch( i ){
	    case 1 :printf("word? ");
	      scanf("%s" , w);
	      printf("position? ");
	      scanf("%d" ,&p);
	      insert(w , p , &l);
	      break;
	    case 2 :printf("position? ");
	      scanf("%d" ,&p);
	      delete(p , &l);
	      break;
	    case 3 :printf("position? ");
	      scanf("%d" ,&p);
	      printf("element of position %d = %s\n" , p , see(p , &l) );
	      break;
	    case 4 :printf("word? ");
	      scanf("%s" , w);
	      printf("%s is located %d\n" , w , locate(w , &l) );
	      break;
	    case 5 :printf("position? ");
	      scanf("%d" ,&p);
	      printf("next position is %d\n" , next(p , &l) );
	      break;
	    case 6 :printf("position? ");
	      scanf("%d" , &p);
	      printf("previous position is %d\n",previous(p,&l));
	      break;
	  case 7 :printf("end position is %d\n" , endlist(&l) );
	      break;
	  case 8 :printf("first is %d\n" , first(&l) );
	      break;
		}
	}while( ( i >= 1 ) && ( i <= 8 ) );
}

void 
init_list( ptr )
List 	*ptr;
{
	ptr->str = NULL;
	ptr->next = NULL;
}

void 
print_list( header )
List 	*header;
{
	List	*i;
	int	c;
	
	c = 0;
	printf( "\n" );
	i = header->next;
	while( i != NULL ){
	  c++;
	  if( c == 6 )
	    {	
	      printf("\n");
	      c = 0;
	    }
	  printf("[%s] -> " , i->str );
	  i = i -> next;
	}
	printf( "end of list\n" );
}

int 
insert( word, p, ptr )
char 	*word; 
pos 	p;
List 	*ptr;
{
	List	*i;
	List	*newlist;
	List	*plist;		/* previous list */
	int	c;		/* count */
	char    *wa;            /* word address */

	if( check( p, ptr, 1 ) == FALSE ) {
	  return( FALSE );
	}

	if( ( wa = strdup(word) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n" );
	  return( FALSE );
	}

	if( ( newlist = (List *)malloc(sizeof(List)) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n");
	  return( FALSE );
	}
	
	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ) {
	  c++;
	  if( c == p ){
	    break;
	  }
	  plist = i;
	}
	newlist->next = plist->next;
	plist->next = newlist;
	newlist->str = wa;
	
	return( TRUE );
}

int
delete( p, ptr )
pos 	p;
List 	*ptr;
{
	int	c;
	List	*i;
	List	*plist;
	
	if( check( p, ptr, 0 ) == FALSE ){
	  return( FALSE );
	}

	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( c == p ){
	    break;
	  }
	  plist = i;
	}
	plist->next = i->next;
	free( i );

	return( TRUE );
}

char *
see( p, ptr )
pos 	p;
List 	*ptr;
{
	int	c;
	List	*i;
	
	if( check( p, ptr, 0 ) == FALSE ){
	  return( NULL );
	}
	
	c = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( c == p ){
	    break;
	  }
	}
	return(	i->str );
}

int
locate( word, ptr )
char 	*word;
List 	*ptr;
{
	List	*i;
	pos	p;
	
	p = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  p++;
	  if( strcmp(i->str, word) == 0 ){
	    return( p );
	  }
	}
	return( 0 );
}

pos
endlist( ptr )
List 	*ptr;
{
	List	*i;
	pos	p;
	
	p = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  p++;
	}
	return( p+1 );
}

pos
next( p, ptr )
pos 	p;
List 	*ptr;
{
	if( check(p, ptr, -1) == FALSE ){
	  return( ERROR );
	}
	return( p+1 );
}

pos
previous( p, ptr )
pos 	p;
List 	*ptr;
{
	if( check(p, ptr, 0) == FALSE ){
	  return( ERROR );
	}
	return( p-1 );
}

pos
first( ptr )
List 	*ptr;
{
	if( ptr->next == NULL ){
	  return( ERROR );
	}
	return( TRUE );
}

void
listcat( p1, p2 )
List 	*p1;
List 	*p2;
{
	List 	*i;

	i = p1;
	while( i->next != NULL ){
	  i = i->next;
	}
	i->next = p2->next;
	init_list( p2 );
}

void
clearlist( ptr )
List 	*ptr;
{
	List 	*i;
	List 	*plist;

	while( ptr->next != NULL ){
	  plist = ptr;
	  for( i = ptr->next; i->next != NULL; i = i->next ){
	    plist = i;
	  }
	  free( i->str );
	  free( i );
	  plist->next = NULL;
	}
	init_list( ptr );
}

int 
check( p, ptr, j )
pos 	p;
List 	*ptr;
int	j;
{
	int	nol;
	List	*i;
	
	if( p < 1 ){
	  fprintf( stderr, "plist: Disable position\n" );
	  return( FALSE );
	}
	
	nol = 0;
	for( i = ptr->next ; i != NULL ; i = i->next ){
	  nol++;
	}
	if( p > nol+j ){	
	  fprintf( stderr, "plist: Disable position\n" );
	  return( FALSE );
	}
	
	return( TRUE );
}

/*
 * Delete a same entry in the list
 *    Return: TRUE  : delete a same entry.
 *            FALSE : do not.
 *				(1,Jun.,95' by tomi )
 */

int
unique( ptr )
List 	*ptr;
{
	int 	i, j;
	int 	n;		/* number of entry in the list */
	char 	*buffer;	/* work area */
	int 	flag = 0;

	n = endlist( ptr );
	for( i = 1; i < n; i++ ){
	  buffer = see( i, ptr );
	  for( j = i+1; j < n; j++ ){
	    if( strcmp(buffer,see(j,ptr)) == 0 ){
	      delete( j, ptr );
	      flag++;
	      n--;
	    }
	  }
	}
	if( flag == 0 ){
	  return( FALSE );
	}else{
	  return( TRUE );
	}
}


int 
writelist( word, p, ptr )
char 	*word; 
pos 	p;
List 	*ptr;
{
	List	*i;
	List	*plist;	
	int	c;		/* count */
	char    *wa;            /* word address */

	if( check( p, ptr, 1 ) == FALSE ) {
	  return( FALSE );
	}

	if( ( wa = strdup(word) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n" );
	  return( FALSE );
	}

	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ) {
	  c++;
	  plist = i;
	  if( c == p ){
	    break;
	  }
	}
	free( plist->str );
	plist->str = wa;
	
	return( TRUE );
}

pos 
searchlist( word, ptr )
char 	*word;
List	*ptr;
{
  	int     c = 0, p = 0;
	List	*i;

	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( strcmp( word, i->str ) == 0 ){
	    p = c;
	    break;
	  }
	}
	return( p );
}
