/**************************************************************************
                                                                        
   Lexical Analyzer [npp.l] for lex of NCS PreProcessor Program
                                                                        
$Header: /cvsroot/satellite/satellite2/src/ncs/ncspp/npp.l,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

**************************************************************************/
%{
#include "string.h"
#include "common.h"
#include "list.h"
#include "npp-from-yacc.h"
extern int lineno;
extern int charno;
extern int tabno;
extern int yyerror( char * );
extern char buffer[];
extern List clang;
char var_top[10] = "variable_";
char str_buffer[100];
int bn = 0;
%}

digit          [0-9]
exp            ([eE][+-]?{digit}+)
ident          [a-zA-Z][_a-zA-Z0-9]*
c_keyword      auto|break|case|char|const|continue|default|do|double|enum|extern|float|goto|int|long|register|return|short|signed|sizeof|static|struct|switch|typedef|union|unsigned|void|while
%x comment
%x csource
%%
"type"                 { charno+=(int)yyleng; return(TYPE); }
"CELL"                 { charno+=(int)yyleng; return(CELL); }
"SYNAPSE"              { charno+=(int)yyleng; return(SYNAPSE); }
"GAP"                  { charno+=(int)yyleng; return(GAP); }
"EXINPUT"              { charno+=(int)yyleng; return(EXINPUTM); }
"NETWORK"              { charno+=(int)yyleng; return(NETWORK); }
"end"                  { charno+=(int)yyleng; return(END); }
"if"                   { charno+=(int)yyleng; return(IF); }
"else"                 { charno+=(int)yyleng; return(ELSE); }
"for"                  { charno+=(int)yyleng; return(FOR); }
"cell"                 { charno+=(int)yyleng; return(CELLN); }
"synapse"              { charno+=(int)yyleng; return(SYNN); }
"gap"                  { charno+=(int)yyleng; return(GAPN); }
"connection"           { charno+=(int)yyleng; return(CONEX); }
":"                    { charno+=(int)yyleng; return(COLON); }
";"                    { charno+=(int)yyleng; return(SCOLON); }
"/"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(DIV);}
"*"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(MULT);}
"+"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(PLUS);}
"-"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(MINUS);}
"("                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(LP);}
")"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(RP);}
"{"                    { charno+=(int)yyleng; return(BRCL); }
"}"                    { charno+=(int)yyleng; return(BRCR); }
"["                    { charno+=(int)yyleng; return(BRKL); }
"]"                    { charno+=(int)yyleng; return(BRKR); }
","                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(COMMA);}
"="                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(EQUAL);}
"+="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(PLEQ);}
"-="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(MIEQ);}
"*="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(MLEQ);}
"/="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(DVEQ);}
"%"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(MOD);}
"=="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(EQ); }
"!="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(NE); }
"<"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(LESS);}
">"                    { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(GR);}
"<="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(LEQ); }
">="                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(GEQ); }
"||"                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(OR);}
"&&"                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(AND);}
"++"                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(INC);}
"--"                   { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(DEC);}
"name"                 { charno+=(int)yyleng; return(NAME); }
"module"               { charno+=(int)yyleng; return(MODULE); }
"exinput"              { charno+=(int)yyleng; return(EXINPUT); }
"input"                { charno+=(int)yyleng; return(Input); }
"output"               { charno+=(int)yyleng; return(OUTPUT); }
"observable"           { charno+=(int)yyleng; return(OBSERVABLE); }
"constant"             { charno+=(int)yyleng; return(CONSTANT); }
"parameter"            { charno+=(int)yyleng; return(PARAMETER); }
"initial"              { charno+=(int)yyleng; return(INIT); }
"function"             { charno+=(int)yyleng; return(FUNCTION); }
{c_keyword}            { charno+=(int)yyleng+(int)strlen(var_top);
			 sprintf(str_buffer,"Can not describe keyword \"%s\" of C language in model description\n" , yytext);
			 yyerror( str_buffer );
                         strcpy( str_buffer,var_top );
                         yylval.ptr=(char *)strdup(strcat(str_buffer,yytext));
                         return(IDENT);}
{digit}+               { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(NUMBER); }
{digit}+"."{digit}*{exp}? |
{digit}*"."{digit}+{exp}? |
{digit}+{exp}              { charno+=(int)yyleng; 
                             yylval.ptr=(char *)strdup(yytext);
                             return(NUMBER); }
{ident}                { charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(IDENT); }
"\n"                   { lineno++; charno = 0; tabno = 0; }
[ ]                    { charno += yyleng;}
[\t]		       {tabno++; }
"/"("*"+)              { BEGIN(comment); }
<comment>[^*/\n]       { charno += yyleng; }
<comment>\n            { lineno++; charno = 0; tabno = 0; }
<comment>"/"+          { charno += yyleng; }
<comment>"*"+          { charno += yyleng; }
<comment>("*"+)"/"     { BEGIN(INITIAL); }
"%{"		       { BEGIN(csource); }
<csource>[^}%\n]       { buffer[bn++] = yytext[0]; }
<csource>"}"+          { buffer[bn++] = yytext[0]; }
<csource>"%"+	       { buffer[bn++] = yytext[0]; }
<csource>\n            { lineno++; 
			 buffer[bn++] = '\n'; 
			 buffer[bn++] = EOS; 
                         insert( buffer, endlist(&clang), &clang );
			 bn = 0; }
<csource>"}%"	       { buffer[bn++] = '\n'; 
			 buffer[bn++] = EOS; 
			 insert( buffer, endlist(&clang), &clang ); 
                         BEGIN(INITIAL); }
.                      { sprintf( str_buffer, 
				  "unknown token \"%s\"\n" , yytext);
                         yyerror( str_buffer );}
%%

#ifndef FLEX_SCANNER
yywrap () { return (1); }
#endif

int
call_yy_new_file () {
#ifdef FLEX_SCANNER
 YY_NEW_FILE;
#endif
 return( 0 );
}
