/**************************************************************************
                                                                        
   Parser Program [npp.y] for yacc of NCS PreProcessor Program on Unix
                                                                        
    $Id: npp.y,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

**************************************************************************/
%{
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_MATH_H
#include <math.h>
#endif /* HAVE_MATH_H */
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "ncs_dir.h"
#include "ncsdef.h"
#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */
#include "list.h"
#include "ncs_func_lib.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"
#include "scfprm.h"
#include "scfxin.h"
#include "scfxfp.h"
#include "scfout.h"
#include "scfobs.h"
#include "scfmat.h"
#include "scfdly.h"
#include "npp.h"

static void routine_work	 	_ANSI_ARGS_(( int ));
static char *getparameter		_ANSI_ARGS_(( char *ident ));
static int  check_module_description 	_ANSI_ARGS_(( void ));
static void list_up_modules		_ANSI_ARGS_(( List *mod ));
static void set_exinput		 	_ANSI_ARGS_(( char *var ));
static void set_input		 	_ANSI_ARGS_(( char *var ));
static void set_delay		 	_ANSI_ARGS_(( char *var, char *time, 
						      char *init ));
static void set_observable		_ANSI_ARGS_(( char *obs ));
static void mark_observable		_ANSI_ARGS_(( char *ident ));
static void insert_observable	 	_ANSI_ARGS_(( List *table ));
static void set_parameter		_ANSI_ARGS_(( char *parm, char *val, 
						      int flag ));

int  yyerror			 	_ANSI_ARGS_(( char *s ));
int  check_exec_file_name	 	_ANSI_ARGS_(( char *file_name ));
int  get_return_value_filter	 	_ANSI_ARGS_(( char *fname ));
void init			 	_ANSI_ARGS_(( void ));
void make_header		 	_ANSI_ARGS_(( char *input_file_name,
						      char *usr_header_file ));
void make_headerfile		 	_ANSI_ARGS_(( char *input_file_name ));
void make_ncsf_constset		 	_ANSI_ARGS_(( void ));
void make_csources		 	_ANSI_ARGS_(( void ));
void make_initvalue		 	_ANSI_ARGS_(( void ));
void make_ncsf_prmset		 	_ANSI_ARGS_(( void ));
void make_network		 	_ANSI_ARGS_(( void ));
void make_getprmptr		 	_ANSI_ARGS_(( void ));
void make_prm_file		 	_ANSI_ARGS_(( List *info ));
void make_xin_file		 	_ANSI_ARGS_(( void ));
void make_out_file		 	_ANSI_ARGS_(( void ));
void make_obs_file		 	_ANSI_ARGS_(( List *info ));
void make_dly_file		 	_ANSI_ARGS_(( List *info ));
void make_mat_file		 	_ANSI_ARGS_(( void ));
void make_line			 	_ANSI_ARGS_(( List *line_ptr ));
void endprocess			 	_ANSI_ARGS_(( void ));


/***** Variables to store information of model description  *****/
int lineno = 1;            	/* a number of lines                        */
int charno = 0;            	/* a number of characters                   */
int tabno = 0;            	/* a number of tab codes                    */
int mline = 0;            	/* difference number of line                */
int integ_flag = 0;        	/* flag of integration                      */
int num_of_integ = 0;      	/* a number of integration                  */
int module_id = 0;         	/* module ID                                */
int num_of_xin = 0;        	/* a number of exinputs                     */
int num_of_obs = 0;        	/* a number of observables                  */
int num_of_input = 0;      	/* a number of inputs                       */
int num_of_delay = 0;      	/* a number of delays                       */
int max_input = 0;         	/* maximal number of inputs                 */
int module_count = 0;      	/* a number of modules                      */
char *mfile_path;       	/* file name of model (work)                */
char *model_file_name;     	/* file name of model (source)              */

int error_num = 0;         	/* a number of errors                       */

/***** Lists to store information of NETWORK description *****/
int network_flag = 0;           /* flag for NETWORK description             */
char net_name[32];              /* a name of NETWORK                        */
List network;                   /* NETWORK description written by C         */
List net_info;                  /* information of NETWORK description       */
List net_def;                   /* list of define for paramter in NETWORK   */
List net_undef;                 /* list of undef for paratmer in NETWORK    */

List net_module;         /* modules described left side equation in NETWORK */
List net_inputs; /* modules described right side equation in NETWORK(input) */
List net_loads;  /* modules described right side equation in NETWORK(output)*/

List cell_modules;              /* Cell modules defined in NETWORK          */
List synapse_modules;           /* Synapse modules defined in NETWORK       */
List gap_modules;               /* Gap modules defined in NETWORK           */

List name;                      /* list of name of modules 		    */

/***** Lists to describe functions of module *****/
List module;                    /* final description of function            */
List define;                    /* define of paramter before function       */
List integ;                     /* for intagration                          */
List f_header;                  /* header of function                       */
List declare;                   /* variable declaration(double) in function */
List constant;                  /* description produced "constant:"         */
List constant2;                  /* description produced "constant:"         */
List delay;                     /* description produced delay statements    */
List function;                  /* description produced "function:"         */
List exinput;                   /* information of "exinput:"                */
List input;                     /* informaiton of "input:"                  */
List observable;                /* description produced "observable:"       */
List observ_table;              /* table of "observable:" in all module      */
List initial;                   /* for "initial:"                           */
List f_end;                  /* end of lines of function includes "output:" */
List undef;                     /* for undef                                */

List output;                    /* list of "output:"                        */
List fact;                      /* list of factor                           */
List parameter;                 /* for ncsf_prmset(), make_prm_file()       */
List param_table;               /* table of "parameter:" in all module      */
List initvalue;                 /* for initvalue()                          */
List getprmptr;		        /* for getprmptr() (to link NPE)            */

/***** Lists to describe functions of module *****/
List header;                    /* final description for header file        */
List ncs_xin;                   /* list to write exinput (module ID -> ...) */
List ncs_obs;                   /* to write header file                     */
List ncs_double;                /* for declaration of parameter in header   */

List net_table;              /* list of component of module written NETWORK */
List module_table;              /* module name and module ID                */
List delay_file;                /* infomation of delay                      */
                                /*     mdl_name -> inp_name -> time -> init */

/***** Lists to directory describe in C language *****/
List clang;
int csflag;

/***** work memory *****/
FILE *fp;                       /* file pointer of *.c                      */
char buffer[100000];            /* working space                            */
char *work_dir;            /* path name of SATELLITE                   */

%}

%union {
    int num;
    char *ptr;
    double dval;
    int ival;
}

%token <num> SCOLON COLON IF ELSE CELL GAP SYNAPSE NETWORK
%token <num> EXINPUTM TYPE CONEX FOR CELLN SYNN GAPN NAME EXINPUT
%token <num> PARAMETER INIT FUNCTION Input OUTPUT OBSERVABLE END
%token <num> CONSTANT BRCL BRCR BRKL BRKR MODULE
%token <ptr> LP RP EQUAL COMMA PLEQ MIEQ MLEQ DVEQ
%token <ptr> IDENT NUMBER

%left <ptr> OR
%left <ptr> AND
%left <ptr> EQ GR LESS LEQ NE GEQ
%left <ptr> PLUS MINUS
%left <ptr> DIV MULT MOD
%token <ptr> INC DEC

%nonassoc UMINUS

%type <ptr> factor2 exp1 substitution net_name
%type <ptr> character characters
%type <ptr> if_state if_state2 function
%type <ptr> parameter parameter2
%type <ptr> exinput exinput2 exinput3 
%type <ptr> cell module_name output observable observable2
%type <ptr> constant constant2 
%type <ptr> input1 input2 input3
%type <ptr> initial initial2 initial3 
%type <ptr> inputs inputs2
%type <ptr> mname2 cellname mname mnames
%type <ptr> num_cal fnumber
%type <ptr> id_exp id_assign_exp assign_operator
%type <ptr> id_condition_exp id_logic_or_exp id_logic_and_exp
%type <ptr> id_eqn_exp id_relation_exp id_add_exp id_multi_exp
%type <ptr> id_unary_exp id_post_exp id_prim_exp
%type <dval> va_exp va_add_exp va_multi_exp
%type <dval> va_unary_exp va_post_exp va_prim_exp
%type <ival> iexp, iexps
%type <ptr> id_add_exp1 id_multi_exp1 id_unary_exp1 id_prim_exp1
%type <ptr> cell_body syn_body


%%
/*** Model descrition ***/
model   : network modules        { ; }
        ;
modules : /* empty */
        | modules module
        ;
module  : cell                   { module_count++; }
        | syn                    { module_count++; }
        | gap                    { module_count++; }
        ;
/*** NETWORK description ***/
network : TYPE COLON NETWORK SCOLON net_name net_body_list connect END SCOLON
          { 
	    /* for paramters */
	    network_flag = 0;
            clearlist( &define );
            clearlist( &declare );
            clearlist( &parameter );
	    clearlist( &undef );
	    clearlist( &fact );

	    insert( ENDMARK_GPP, endlist(&getprmptr), &getprmptr );

	    /* check matching modules */
	    if( check_module_description() == FALSE ){
	      /* yyerror( "module mismatch" );*/
	    }
	  }
        | error END SCOLON
          {
	    /* fatal error in NETWORK description */
	    exit(7);
          }
        ;
net_body_list : net_body                  { ; }
              | net_body_list net_body   { ; }
;
net_body      : cellname                { ; }
              | synname                 { ; }
              | gapname                 { ; }
              | parameter               { ; }
              | error SCOLON
              {
		yyerrok;
	      }
              ;
net_name: MODULE COLON IDENT SCOLON
          {
	    network_flag = 1;
            strcpy( net_name, $3 );  
	    insert( "0", endlist(&name), &name ); 
	    insert( $3, endlist(&name), &name ); 
	  }
        ;
/*** CELL MODULE description ***/
cell    : TYPE COLON CELL SCOLON module_name cell_body_list function END SCOLON
          { 
	    int i;
	    routine_work( (int)'b' );
	    insert( "1", endlist(&module_table), &module_table );

	    /* insert observable information to lists */
	    insert_observable( &observ_table );
	    
	    unique( &declare );

	    /* connect lists to write CELL modules */
	    sprintf( buffer, "/*** module  ***/\n" );
	    insert( buffer, endlist(&module), &module );
	    listcat( &module, &define );
	    listcat( &module, &integ );
	    listcat( &module, &f_header );
	    listcat( &module, &declare );
	    listcat( &module, &constant );
	    listcat( &module, &delay );
	    listcat( &module, &initial );
	    listcat( &module, &function );
	    listcat( &module, &observable );
	    listcat( &module, &f_end );
	    listcat( &module, &undef );

	    if( csflag == 0 ){
	      make_csources();
	      csflag++;
	    }

	    for( i = 1; i < endlist(&module); i++ ){
	      fprintf( fp, "%s", see(i,&module) );
	    }
	    num_of_input = 0;
	    routine_work( (int)'e' );

	    /* to link NPE */
	    insert( ENDMARK_GPP, endlist(&getprmptr), &getprmptr );
	  }
          ;
cell_body_list : cell_body                  { ; }
               | cell_body_list cell_body   { ; }
;
cell_body : input1                { ; }
          | output                { ; }
          | observable            { ; }
          | constant              { ; }
          | parameter             { ; }
          | initial               { ; }
	  | exinput               { ; }
          | error SCOLON
           {
	     yyerrok;
	   }
          ;
/*** SYNAPSE MODULE description ***/
/*syn     : *//* empty */                      /* { ; }*/
syn     : TYPE COLON SYNAPSE SCOLON module_name syn_body_list 
          function END SCOLON
          { 
	    int i;
	    routine_work( (int)'b' );
	    insert( "2", endlist(&module_table), &module_table );

	    /* insert observable information to lists */
	    insert_observable( &observ_table );

	    /* connect lists to write SYNAPSE modules */
	    listcat( &module, &define );
	    listcat( &module, &integ );
	    listcat( &module, &f_header );
	    listcat( &module, &declare );
	    listcat( &module, &constant );
	    listcat( &module, &delay );
	    listcat( &module, &initial );
	    listcat( &module, &function );
	    listcat( &module, &observable );
	    listcat( &module, &f_end );
	    listcat( &module,&undef );
	    for( i = 1; i < endlist( &module ); i++){
	      fprintf( fp, "%s", see(i,&module) );
	    }
	    routine_work( (int)'e' );

	    /* to link NPE */
	    insert( ENDMARK_GPP, endlist(&getprmptr), &getprmptr );
	  }
        ;
syn_body_list : syn_body                    { ; }
              | syn_body_list syn_body      { ; }
;
syn_body : inputs                  { ; }
         | output                  { ; }
         | observable              { ; }
         | constant                { ; }
         | parameter               { ; }
         | initial                 { ; }
         ;
/*** GAP MODULE description ***/
/*gap     : *//* empty */                      /* { ; }*/
gap       : TYPE COLON GAP SCOLON module_name syn_body_list function END SCOLON
          {
	    int i;
	    routine_work( (int)'b' );
	    insert( "3", endlist(&module_table), &module_table );

	    /* insert observable information to lists */
	    insert_observable( &observ_table );

	    /* connect lists to write GAP modules */
	    listcat( &module, &define );
	    listcat( &module, &integ );
	    listcat( &module, &f_header );
	    listcat( &module, &declare );
	    listcat( &module, &constant );
	    listcat( &module, &delay );
	    listcat( &module, &initial );
	    listcat( &module, &function );
	    listcat( &module, &observable );
	    listcat( &module, &f_end );
	    listcat( &module, &undef );
	    for( i = 1; i < endlist(&module); i++ ){
	      fprintf( fp, "%s", see(i,&module) );
	    }
	    routine_work( (int)'e' );  

	    /* to link NPE */
	    insert( ENDMARK_GPP, endlist(&getprmptr), &getprmptr );
	  }
        ;

/*** "module" statement ***/
module_name: MODULE COLON IDENT SCOLON
	    { 
	      sprintf( buffer, "double %s(NcsTime , Ncs_y , Ncs_dy)\ndouble NcsTime , **Ncs_y , **Ncs_dy;\n{\n", $3 );
	      insert( buffer, 1, &f_header );

	      /* module name and module ID are stored in module_table */
	      insert( $3, endlist(&module_table), &module_table );
	      if( locate( $3, &net_table ) == 0 ){
		exit(21);
	      }
	      sprintf( buffer, "%s", see(locate($3,&net_table)+2,&net_table) );
	      insert( buffer, endlist(&module_table), &module_table );
	      module_id = atoi( buffer );

	      /* to link NPE */
	      sprintf( buffer, "%d", module_id );
	      insert( buffer, endlist(&name), &name ); 
	      insert( $3, endlist(&name), &name ); 
	    }
        ;
/*** for "cell", "synapse" and "gap" statement ***/
mnames   : mnames COMMA mname 
           {
	    sprintf( buffer, "%s:%s", $1, $3 );
	    $$ = strdup( buffer );  
	   }
         | mname              
           {
	     $$ = $1;
	   }
         ;
mname   : IDENT BRKL NUMBER BRKR
          { /* module name, number of component, module ID are stored  */
	    /* in net_table                                            */
	    insert( $1, endlist(&net_table), &net_table );
	    insert( $3, endlist(&net_table), &net_table );
	    sprintf( buffer, "%d", module_id );
	    insert( buffer, endlist(&net_table), &net_table );
	    module_id++; 
	    sprintf( buffer, "%s,%s", $1, $3 );
	    $$ = strdup( buffer );
	  }
        ;
/*** "cell" statement ***/
cellname : CELLN COLON mnames SCOLON
           { 
	     insert( $3, endlist(&cell_modules), &cell_modules );
	     list_up_modules( &cell_modules );
	   }
         ;
/*** "synapse" statement ***/
synname : SYNN COLON mnames SCOLON                      
           { 
	     insert( $3, endlist(&synapse_modules), &synapse_modules );
	     list_up_modules( &synapse_modules );
	   }
        ;
/*** "gap" statement ***/
gapname : GAPN COLON mnames SCOLON
           { 
	     insert( $3, endlist(&gap_modules), &gap_modules );
	     list_up_modules( &gap_modules );
	   }
        ;
/*** "connection" statement **/
connect : CONEX COLON jexps                 { ; }
        ;
jexps   : jexps jexp
          { 
	    insert( ";", endlist(&net_info), &net_info ); 
	  }
        | jexp
          { 
	    insert( ";", endlist(&net_info), &net_info );
	  }
        ;
jexp    : mname2 LESS iexps SCOLON
          { 
	    insert( "*", endlist(&net_info), &net_info );
	    insert( $1, endlist(&net_info), &net_info );

	    sprintf( buffer, "%d", $3 );
	    insert( $1, endlist(&net_module), &net_module );
	    insert( buffer, endlist(&net_module), &net_module );
	  }
        | for
          { ; }
        | error
          {
	    yyerrok;
          }
        ;
mname2  : IDENT BRKL id_exp BRKR
          { 
	    /* define Check*/
	    int dflag = 0, pt, dim;

	    if( (pt = locate( $1, &cell_modules )) == 0 ){
	      dflag++;
	    }else{
	      dim = atoi(see( pt+1, &cell_modules ));
	      if( atoi($3) >= dim ){
		sprintf( buffer,
			 "module \"%s\" dimension mismatch",$1 );
		yyerror( buffer );
	      }
	    }
	    if( (pt = locate( $1, &synapse_modules )) == 0 ){
	      dflag++;
	    }else{
	      dim = atoi(see( pt+1, &synapse_modules ));
	      if( atoi($3) >= dim ){
		sprintf( buffer,
			 "module \"%s\" dimension mismatch",$1 );
		yyerror( buffer );
	      }
	    }
	    if( (pt = locate( $1, &gap_modules )) == 0 ){
	      dflag++;
	    }else{
	      dim = atoi(see( pt+1, &gap_modules ));
	      if( atoi($3) >= dim ){
		sprintf( buffer,
			 "module \"%s\" dimension mismatch",$1 );
		yyerror( buffer );
	      }
	    }
	    if( dflag == 3 ){
	      sprintf( buffer, "module \"%s\" is not defined", $1 );
	      yyerror( buffer );
	    }

	    sprintf(buffer,"%s,%s",$1,$3);
	    $$=strdup(buffer);
	  }
        ;
iexps   : iexps iexp
          {
	    $$ = $1 + $2;
	  }
        | iexp
          {
	    $$ = $1;
          }
        ;
iexp    : LP jterms RP
          { 
	    insert( "!", endlist(&net_info), &net_info ); 

            $$ = 1;
	  }
        | LP RP                          
         { 
            $$ = 1;
	 }
        ;
jterms  : jterm                          { ; }
        | jterms PLUS jterms             { ; }
        ;
jterm   : mname2 LESS mname2
          { 
	    sprintf( buffer,"%s<%s", $1, $3 );
	    insert( buffer, endlist(&net_info), &net_info );

	    insert( $1, endlist(&net_loads), &net_loads );
	    insert( $3, endlist(&net_inputs), &net_inputs );
	  }
        | LP jterms RP                          { ; }
        ;
/** "for" statement **/
for     : FOR scope BRCL jexps BRCR
          { 
	    insert( "$", endlist(&net_info)-1, &net_info );
	    /* take 1 from endlist(), because there is "$" after ";" */  
	  }
        ;
scope   : LP id_exp SCOLON id_exp SCOLON id_exp RP
        { 
	  insert( "for", endlist(&net_info), &net_info );
	  sprintf( buffer, "int %s;", $2 );
	  insert( buffer, endlist(&net_info), &net_info );
	  sprintf( buffer, "%s ; %s ; %s", $2, $4, $6 );
	  insert( buffer, endlist(&net_info), &net_info );
	}
        ;
id_exp           :  id_assign_exp
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 ;
id_assign_exp    :  id_condition_exp
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 | id_unary_exp assign_operator id_assign_exp
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 ;
assign_operator  : EQUAL               { ; }
                 | PLEQ                { ; }
                 | MIEQ                { ; }
                 | MLEQ                { ; }
                 | DVEQ                { ; }
                 ;
id_condition_exp : id_logic_or_exp
                  { 
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 ;
id_logic_or_exp  : id_logic_and_exp
                  { 
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );  
		  }
                 | id_logic_or_exp OR id_logic_or_exp
                  { 
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );  
		  }
                ;
id_logic_and_exp : id_eqn_exp
                  { 
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_logic_or_exp AND id_logic_or_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
id_eqn_exp       : id_relation_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_eqn_exp EQ id_relation_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_eqn_exp NE id_relation_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
id_relation_exp  : id_add_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_relation_exp LESS id_add_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_relation_exp GR id_add_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_relation_exp LEQ id_add_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_relation_exp GEQ id_add_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
id_add_exp       : id_multi_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_add_exp PLUS id_multi_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_add_exp MINUS id_multi_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
id_multi_exp     : id_unary_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_multi_exp MULT id_unary_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_multi_exp DIV id_unary_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 | id_multi_exp MOD id_unary_exp
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
id_unary_exp     : id_post_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | INC id_unary_exp  /* %prec UINC */
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 | DEC id_unary_exp  /* %prec UINC */
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 | PLUS id_multi_exp %prec UMINUS
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 | MINUS id_multi_exp %prec UMINUS 
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 ;
id_post_exp      : id_prim_exp
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | id_post_exp BRKL id_exp BRKR
                  {
		    sprintf( buffer, "%s%c%s%c", $1, $2, $3, $4 );
		    $$ = strdup( buffer );
		  }
                 | id_post_exp INC
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 | id_post_exp DEC
                  {
		    sprintf( buffer, "%s%s", $1, $2 );
		    $$ = strdup( buffer );
		  }
                 ;
id_prim_exp      : NUMBER 
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | IDENT
                  {
		    sprintf( buffer, "%s",$1 );
		    $$ = strdup( buffer );
		  }
                 | LP id_exp RP
                  {
		    sprintf( buffer, "%s%s%s",$1,$2,$3 );
		    $$ = strdup( buffer );
		  }
                 | IDENT LP exp1 factor2 RP
                  { 
		    char buf4func[255];/*working space for internal function*/

		    sprintf( buffer, "%s%s", $3, $4 );
		    if( check_lib_func_list( $1, buffer ) == FALSE ){
		      sprintf( buffer, "%s%s%s%s%s", $1, $2, $3, $4, $5 );
		    }else{
		      strcpy( buf4func, buffer );
		      sprintf( buffer, "ncsl_%s%s%s%s", $1, $2, buf4func, $5 );
		    }
		    $$ = strdup(buffer);
		  }
                 ;
/*** "exinput" statement ***/
exinput : EXINPUT COLON exinput2 SCOLON
          { ; }
        ;
exinput2 : exinput2 COMMA exinput3
          { ; }
         | exinput3
          { ; }
        ;
exinput3 : IDENT
           {
	     set_exinput( $1 );
	     num_of_xin++; 
	   }
         | IDENT LP NUMBER COMMA NUMBER RP  { ; }
         ;
/*** "input" statement for cell module ***/
input1   : Input COLON input2 SCOLON        { ; }
        ;
input2   : input2 COMMA input3		{ ; }
         | input3		        { ; }
         ;
input3   : IDENT
           {
	     sprintf( buffer, "#define\t%s\tNET[%d]\n", $1, num_of_input );
	     insert( buffer, endlist(&define), &define );
	     num_of_input++;
	     /* maximum number of input */
	     if( num_of_input > max_input ){
	       max_input = num_of_input;
	     }

	     sprintf( buffer, "#undef\t%s\n", $1 );
	     insert( buffer, endlist(&undef), &undef );

	     set_input( $1 );
	     /* can't use delay in CELL module */ 
	   }
         ;
/*** "input" statement for synapse and gap module ***/
inputs   : Input COLON inputs2 SCOLON       { ; }
         ;
inputs2  : IDENT
           { 
	     sprintf( buffer, "#define\t%s\tINPUT\n", $1 );
	     insert( buffer, endlist(&define), &define );
	     sprintf( buffer, "#undef\t%s\n",$1 );
	     insert( buffer, endlist(&undef), &undef);
	     set_input( $1 );
	   }
         | IDENT LP num_cal COMMA num_cal RP
           {
	     set_input( $1 );
	     /* description for delay */
	     set_delay( $1, $3, $5 );
	   }
         ;
/*** "output" statement ***/
output   : OUTPUT COLON IDENT SCOLON
          {
	    sprintf( buffer, "#define\t%s\tncsm_outs%02d[CN]\n", 
		     $3, module_id );
	    insert( buffer, endlist(&define), &define );
	    sprintf( buffer, "\tncsm_outs%02d[CN] = %s;\n\treturn( %s );\n}\n"
		     , module_id, $3, $3 );
	    insert( buffer, 1, &f_end );
	    insert( $3, 1, &output ); /* prevention multiple define */
	    sprintf( buffer, "#undef\t%s\n", $3 );
	    insert( buffer, endlist(&undef), &undef );
	  }
         ;
/*** "observable" statement ***/
/*observable : *//* empty */
/*             {
	       $$ = strdup("");
	     }
           | OBSERVABLE COLON observable2 SCOLON */
observable : OBSERVABLE COLON observable2 SCOLON
             {
	       insert( "\n" , 1 , &observable );
	     }
           ;
observable2: IDENT
             {
	       set_observable( $1 );
	     }
           | observable2 COMMA IDENT
             {
	       set_observable( $3 );
	     }
           ;
/*** "constant" statement ***/
constant : CONSTANT COLON constant2 SCOLON  { ; }
         ;
constant2: IDENT EQUAL num_cal
           { 
	     sprintf( buffer, "%s", $1);
	     insert( buffer, endlist(&constant2), &constant2 );
	     sprintf( buffer, "\tstatic double %s = %s;\n", $1, $3 );
	     insert( buffer, endlist(&constant), &constant );
	   }
         | constant2 COMMA IDENT EQUAL num_cal
           { 
	     sprintf( buffer, "%s", $3);
	     insert( buffer, endlist(&constant2), &constant2 );
	     sprintf(buffer,"\tstatic double %s = %s;\n", $3, $5 );
	     $$ = strdup( buffer );
	     insert( $$, endlist(&constant), &constant );
	   }
         ;
/*** "parameter" statement ***/
parameter : PARAMETER COLON parameter3 SCOLON
            { ; }
          ;
parameter3 : parameter3 COMMA parameter2 {;}
           | parameter2  {;}
           ;
parameter2: IDENT EQUAL num_cal
            { 
	      set_parameter( $1, $3, network_flag );
	    }
          ;
/** calculate value of parameter **/
num_cal		: va_exp
                 { 
		   sprintf( buffer, "%e", $1 );
		   $$ = strdup( buffer );
		 }
                ;
va_exp          : va_add_exp
                 { $$ = $1;  }
                ;
va_add_exp      : va_multi_exp
                 { $$ = $1;  }
                | va_add_exp PLUS va_multi_exp
                 { $$ = $1 + $3;  }
                | va_add_exp MINUS va_multi_exp
                 { $$ = $1 - $3;  }
                ;
va_multi_exp    : va_unary_exp
                 { $$ = $1;  }
                | va_multi_exp MULT va_unary_exp
                 { $$= $1 * $3;  }
                | va_multi_exp DIV va_unary_exp
                 { $$= $1 / $3;  }
                ;
va_unary_exp    : va_post_exp
                 { $$ = $1;  }
                | PLUS va_multi_exp  %prec UMINUS 
                 { $$ = $2;  }
                | MINUS va_multi_exp %prec UMINUS 
                 { $$ = -1.0 * $2;  }
                ;
va_post_exp     : va_prim_exp
                 { $$ = $1;  }
                ;
va_prim_exp     : NUMBER 
                 { $$ = atof($1);  }
                | LP va_exp RP
                 { $$ = $2;  }
		| IDENT	/* add by T.N 95/6/15 */
 		 { 
		   sprintf( buffer, "%s", getparameter($1) );
   		   $$ = atof(buffer);
		 }
                ;
/*** "initial" statement. this statement can not use, now. ***/
initial   : INIT COLON initial2 SCOLON
            { 
	      sprintf( buffer, "\tif ( TIME == 0. ) {\n" );
	      insert( buffer, 1, &initial );
	      insert( "\t}\n\n", endlist(&initial), &initial );
	    }
          ;
initial2  : initial2 COMMA initial3
          | initial3
          ;
initial3  : IDENT EQUAL num_cal
            {
	      sprintf( buffer, "\t\t%s = %s;\n", $1, $3 );
	      insert( buffer, endlist(&initial), &initial );
	    }
          ;
/*** "function" statement ***/
function  : FUNCTION COLON characters
	    { 
	      char buffer2[256];
	      int i, j, flag = 0;
	      
	      insert( $3, 1, &function );

	      /* check multiple define of variable */
	      for( i = 1; i < endlist(&declare); i++ ){
		sprintf( buffer2, "%s", strchr(see(i,&declare),' ')+1 );
		sprintf( buffer2, "%s", strtok(buffer2,";") );
		
		for( j = 1; j < endlist(&define); j++ ){
		  sprintf( buffer, "%s", strchr(see(j,&define),'\t')+1 );
		  sprintf( buffer, "%s", strtok(buffer,"\t") );
		  if( strcmp(buffer,buffer2) == 0 ){
		    delete( i, &declare );
		    flag = 1;
		  }
		}

		/* check define of variable equaled to integral */
		for( j = 1; j < endlist( &integ ); j++ ){
		  if( strchr( see( j, &integ ), '_' ) != NULL ){
		    sprintf( buffer, "%s", strchr(see(j,&integ),'_')+1 );
		    sprintf( buffer, "%s", strtok(buffer,"\t") );
		    if( strcmp(buffer,buffer2) == 0 ){
		      delete( i, &declare );
		      flag = 1;
		    }
		  }
		}
		if( flag == 1 ){
		  i--;
		  flag = 0;
		}
	      }
	    }
           ;
characters : character                       { ; }
           | characters character
             { 
	       sprintf( buffer, "%s%s", $1, $2 );
	       $$ = strdup( buffer );
	     }
           ;
character : substitution SCOLON
            { 
	      sprintf( buffer, "\t%s;\n", $1 );
	      $$ = strdup( buffer );
	    }
          | if_state
            { ; }
          | error SCOLON
             {
	       yyerrok;
             }
          ;
substitution : IDENT EQUAL exp1
               { 
		 int i, flag, ttt, flag2 = 0;
		 char *st, *ed, tmpst[1024];
		 flag = 0;   /* flag to check multiple define of variable */

		 if( integ_flag == 1 ){		/* exp1 == "integral(..." */
	
		   /* definition for integration before function */
		   sprintf( buffer,"#undef\t%s\t/* for integration */\n", $1 );
		   insert( buffer, endlist(&integ), &integ );
		   sprintf( buffer, "#define\t%s\tNcs_y[CN][%d]\n", 
			    $1, num_of_integ );
		   insert( buffer, endlist(&integ), &integ );
		   sprintf( buffer, "#define\tncsd_%s\tNcs_dy[CN][%d]\n", 
			    $1, num_of_integ );
		   insert( buffer, endlist(&integ), &integ );

		   /* definition for integration after function */
		   sprintf( buffer, "#undef\t%s\n", $1 );
		   insert( buffer, endlist(&undef), &undef );
		   sprintf( buffer, "#undef\tncsd_%s\n", $1 );
		   insert( buffer, endlist(&undef), &undef );

		   /* definition of variable for integration in function */
		   sprintf( buffer,"\tstatic double ncs_%s[NCS_OUT%02d_NC];\n",
			    $1, module_id );
		   insert( buffer, endlist(&declare), &declare );
		   /* function for integration */
		   integ_flag = 0;
		   num_of_integ++;
		   st = strpbrk( $3, "," )+1;
		   ed = strrchr( $3, ')' );
		   ttt = 0;
		   while( st != ed ){
		     tmpst[ttt] = *st;
		     ttt++;
		     st++;
		   }
		   tmpst[ttt] = '\0';
		   sprintf( buffer, "ncsd_%s = %s", $1, tmpst );
		   $$=strdup(buffer);

	         }else{				/* exp1 != "integral(..." */

		   if( (locate($1,&fact) != 0) && (locate($1,&output)==0) ){

		     /* check defined of parameter statement */
		     for( i = 1; i < endlist(&define); i++ ){
		       sprintf( buffer, "%s", strchr(see(i,&define),'\t')+1 );
		       sprintf( buffer, "%s", strtok(buffer,"\t") );
		       if( strcmp(buffer,$1) == 0 ){
			 flag2 = 1;
			 break;
		       }
		     }
		     
		     /* check variable defined output statement */
		     if( flag2 == 0 ){
		       sprintf( buffer, "#define\t%s\tncs_%s[CN]\n", $1, $1 );
		       insert( buffer, endlist(&define), &define );
		       sprintf( buffer, "#undef\t%s\n", $1 );
		       insert( buffer, endlist(&undef), &undef );
		       sprintf( buffer,
			       "\tstatic double ncs_%s[NCS_OUT%02d_NC];\n",
			       $1, module_id );
		       insert( buffer, endlist(&declare), &declare );
		     }
		   }
		   

		   sprintf( buffer, "\tdouble %s;\n", $1 );
		   $$ = strdup( buffer );

		   /* check if statement */
		   for( i = 1; i < endlist(&declare); i++ ){
		     if( strcmp(see(i,&declare),$$) == 0 ){
		       flag = 1;
		       break;
		     }
		   }
		   /* check defined of parameter statement */
		   for( i = 1; i < endlist(&define); i++ ){
		     sprintf( buffer, "%s", strchr(see(i,&define),'\t')+1 );
		     sprintf( buffer, "%s", strtok(buffer,"\t") );
		     if( strcmp(buffer,$1) == 0 ){
		       flag = 1;
		       break;
		     }
		   }
		   /* check defined of constant statement */
		   for( i = 1; i < endlist(&constant2); i++ ){
		     if( strcmp(see(i,&constant2),$1) == 0 ){
		       flag = 1;
		       break;
		     }
		   }

		   if( flag == 0 ){
		     insert( $$, endlist(&declare), &declare );
		   }
		   flag = 0;
		   sprintf( buffer, "%s = %s", $1, $3 );
		   $$ = strdup( buffer );

	         }
		 mark_observable( $1 );
	       }
             | IDENT PLUS PLUS
               {
		 sprintf( buffer, "%s++", $1 );
		 $$ = strdup( buffer ); 
	       }
             ;
/** for equation **/
exp1             : id_add_exp1
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 ;
id_add_exp1      : id_multi_exp1
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 | id_add_exp1 PLUS id_multi_exp1
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 | id_add_exp1 MINUS id_multi_exp1
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 ;
id_multi_exp1    : id_unary_exp1
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 | id_multi_exp1 MULT id_unary_exp1
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 | id_multi_exp1 DIV id_unary_exp1
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 | id_multi_exp1 MOD id_unary_exp1
                  { sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$=strdup( buffer );  }
                 ;
id_unary_exp1    : id_prim_exp1
                  { sprintf( buffer, "%s",$1 );
		    $$=strdup( buffer );  }
                 | PLUS id_multi_exp1 /* %prec UMINUS */
                  { sprintf( buffer, "%s%s", $1, $2 );
		    $$=strdup( buffer );  }
                 | MINUS id_multi_exp1 /* %prec UMINUS */
                  { sprintf( buffer, "%s%s", $1, $2 );
		    $$=strdup( buffer );  }
                 ;
id_prim_exp1     : fnumber		    { ; }
                 | IDENT
                  { 
		    /* list of factor */
		    if( locate($1,&fact) == 0 ){
		      insert( $1, 1, &fact );
		    }
		  }
                 | IDENT LP exp1 factor2 RP
                  { 
		    char buf4func[255];/*working space for internal function*/

		    /* for initvalue() */
		    if( strncmp($1,"integral",8) == 0 ){
		      integ_flag =1;
		      if( isalpha((int)$3[0]) != 0 ){
			sprintf( buffer, "\t\tNcs_y[i][%d] = m%02d%s;\n",
				 num_of_integ, module_id, $3 );
		      }else{
			sprintf( buffer, "\t\tNcs_y[i][%d] = %s;\n",
				 num_of_integ, $3 );
		      }
		      insert(buffer,endlist(&initvalue),&initvalue);
		    }
		    /*  for check Library Function */
		    sprintf( buffer, "%s%s", $3, $4 );
		    if( check_lib_func_list( $1, buffer ) == FALSE ){
		      sprintf( buffer, "%s%s%s%s%s", $1, $2, $3, $4, $5 );
		    }else{
		      strcpy( buf4func, buffer );
		      sprintf( buffer, "ncsl_%s%s%s%s", $1, $2, buf4func, $5 );
		    }
		    $$ = strdup( buffer );
		  }
                 | LP exp1 RP
                  {
		    sprintf( buffer, "%s%s%s", $1, $2, $3 );
		    $$ = strdup( buffer );
		  }
                 ;
fnumber          : NUMBER 
		 {
		   sprintf( buffer, "%e", atof($1) );
		   $$ = strdup(buffer);
		 }
		 ;
factor2   : /* empty */
            {
	      $$ = strdup("");
	    }
          | factor2 COMMA exp1              
            {
	      sprintf( buffer, "%s%s%s", $1, $2, $3 );
              $$ = strdup( buffer );
	    }
          ;

/** "if" statement **/
if_state  : IF LP id_exp RP BRCL characters BRCR if_state2
            {
	      sprintf( buffer, "\tif (%s) {\n\t%s\t}%s\n", $3, $6, $8 );
	      $$ = strdup( buffer );
	    }
          ;
if_state2 : /* empty */    
            {
	      $$ = strdup("");
	    }
          | ELSE BRCL characters BRCR
            {
	      sprintf( buffer, "else{\n\t%s\t}", $3 );
	      $$ = strdup( buffer );
	    }
          ;
%%

/*************************************************************************
	Functions to set information accepted by yacc 
*************************************************************************/

/* for start and end of line in function */
static void
routine_work( c )
int c;
{
	switch( (char)c ){
	  case 'b':
	    /* beginning of module */
	    insert( "\n", endlist(&integ), &integ );
	    insert( "\n", endlist(&declare), &declare );
	    break;
	  case 'e':
	    /* end of module */
	    clearlist( &module );
	    clearlist( &fact );
	    clearlist( &output );
	    insert( "\n", 1, &module );
	    insert( "\n", 1, &delay );
	    break;
	}
}

/*
 * Function to check definition cell module in network description.
 * 	Return  TRUE  : network description is correct
 * 	        FALSE : a used module in right side is not defined 
 *                      in left side.
 */
static int
check_module_description()
{
  	char 	*brkpt;
  	int 	i;
	List 	mtmp;
	int 	eflag = 0;
	char    ebuffer[100];

	init_list( &mtmp );

	/* get module name in right side of equation */
	for( i = 1; i < endlist(&net_module); i+=2 ){
	  strcpy( buffer, see( i, &net_module ) );
	  brkpt = strchr( buffer, (int)(',') );
	  *brkpt = '\0';
	  insert( buffer, endlist(&mtmp), &mtmp );
	}
	while( unique( &mtmp ) == TRUE );

	/* check module name in left side of equation */
	for( i = 1; i < endlist(&net_inputs); i++ ){
	  strcpy( buffer, see( i, &net_inputs ) );
	  brkpt = strchr( buffer, (int)(',') );
	  *brkpt = '\0';
	  if( locate( buffer, &mtmp ) == 0 ){
	    sprintf( ebuffer, 
		     "cell module \"%s\" is not define", buffer );
	    yyerror( ebuffer );
	    eflag++;
	  }
	}

	clearlist( &mtmp );

	if( eflag != 0 ){
	  return( FALSE );
	}else{
	  return( TRUE );
	}
}

/*
 * Function to rebuild list of module name.
 *  Cut each single module name in stirng
 */
static void
list_up_modules( mod )
List 	*mod;
{
  	char 	*brkpt1, *brkpt2, *brkpt3;
  	char 	module_info[100];
  	char 	module_info2[100];

  	if( endlist(mod) > 1 ){
	  strcpy( buffer, see( 1, mod ) );
	  delete( 1, mod );
	  brkpt1 = buffer;
	  while( (brkpt2 = strchr( brkpt1, (int)(':')))!=NULL ){
	    strncpy( module_info, brkpt1, (int)(brkpt2-brkpt1) );
	    brkpt3 = strchr( module_info, (int)(','));
	    strncpy( module_info2, module_info, (int)(brkpt3-module_info) );
	    module_info2[(int)(brkpt3-module_info)] = '\0';
	    insert( module_info2, endlist(mod), mod );
	    brkpt3++;
	    insert( brkpt3, endlist(mod), mod );
	    brkpt1 = brkpt2+1;
	  }
	  brkpt3 = strchr( brkpt1, (int)(','));
	  strncpy( module_info2, brkpt1, (int)(brkpt3-brkpt1) );
	  module_info2[(int)(brkpt3-brkpt1)] = '\0';
	  insert( module_info2, endlist(mod), mod );
	  brkpt3++;
	  insert( brkpt3, endlist(mod), mod );
	}
}

/* 
 * When "IDENT" check, if a variable defined already in parameter, 
 * the variable accept.
 *					add by T.N 95/6/15
 */
static char *
getparameter( ident )
char 	*ident;
{
	int 	id;		/* module ID */
	int 	position;	/* position of "IDENT" in list of parameter */
	char tmp[256];

	/* get module ID include the parameter */
	id = atoi( see(endlist(&module_table)-1,&module_table) );
	sprintf( tmp, "m%02d%s", id, ident );

	/* get position of the parameter in list */
	position = locate( tmp, &parameter )+1;

	/* if the parameter is undefined parameter, then ERROR display */
        if( position == 1 ){
	  exit(22);
	}
	return( see(position,&parameter) );
}


/* 
 *  Procedure to set information of exinput
 *	char *var : name of variable.
 */
static void 
set_exinput( var )
char	*var;
{
  	sprintf( buffer, "#define\t%s\tncsm_xin%02d[CN]\n", var, num_of_xin );
	insert( buffer, endlist(&define), &define );
	sprintf( buffer, "#undef\t%s\n", var );
	insert( buffer, endlist(&undef), &undef );

	/* for header file */
	sprintf( buffer, "%d", module_id );
	insert( buffer, endlist(&ncs_xin), &ncs_xin );

	sprintf( buffer, "%s", var );
	insert( buffer, endlist(&exinput), &exinput );
	sprintf( buffer, "%d", module_id );
	insert( buffer, endlist(&exinput), &exinput );
	insert( see(endlist(&module_table)-2,&module_table), 
		endlist(&exinput), &exinput );
}

/* 
 *  Procedure to set information of input
 *	char *var : name of variable.
 */
static void 
set_input( var )
char	*var;
{
  	sprintf( buffer, "%s", var );
	insert( buffer, endlist(&input), &input );
	sprintf( buffer, "%d", module_id );
	insert( buffer, endlist(&input), &input );
	insert( see(endlist(&module_table)-2,&module_table), 
		endlist(&input), &input );
}

/* 
 *  Procedure to set information of delay
 *	char *var : name of variable.
 *	char *time: delay time.
 *	char *init: initial value.
 */
static void 
set_delay( var, time, init )
char	*var, *time, *init;
{
	sprintf( buffer, "\tstatic long *ncspt%02d;\n", num_of_delay );
	insert( buffer, endlist(&declare), &declare );
	sprintf( buffer, "\tswitch(ncsg_delay_flag){\n" );
	insert( buffer, endlist(&delay), &delay );
	sprintf( buffer, 
		 "\tcase CALCULATE:\n\t\t%s = delay(ncs_dly[%d].q[CN],&ncspt%02d[CN],ncsg_qsize[%d],%s);\n\t\tbreak;\n\n",
		 var, num_of_delay, num_of_delay, num_of_delay, var );
	insert( buffer, endlist(&delay), &delay );
	sprintf( buffer, 
		 "\tcase DELAY_INIT_SET:\n\t\tncspt%02d = (long *)calloc(ncsg_cell,sizeof(long));\n\t\tif(ncsg_dlyinit_flg[%d] == DELAY_INIT_AUTO_SET)\n\t\t\tinit_queue(ncs_dly[%d].q[CN] , ncsg_qsize[%d],%s);\n\t\tbreak;\n\n",
		 num_of_delay, num_of_delay, num_of_delay,
		 num_of_delay, var );
	insert( buffer, endlist(&delay), &delay );
	sprintf( buffer, "\tcase OUTPUT_INIT:\n\t\tbreak;\t\n\t}\n\n" );
	insert( buffer, endlist(&delay), &delay );

	/* delay information is stored for *.DLY */
	insert( see(endlist(&module_table)-2,&module_table),
		endlist(&delay_file), &delay_file );
	insert( var, endlist(&delay_file), &delay_file );
	if( atoi( time ) < 0 ){
	  fprintf( stderr,
		   "Wanning: Improper delay time, delay time is set 0\n" );
	  insert( "0", endlist(&delay_file), &delay_file );
	}else{
	  insert( time, endlist(&delay_file), &delay_file );
	}
	insert( init, endlist(&delay_file), &delay_file );

	/* insert define and undef in function */
	sprintf( buffer, "#define\t%s\tINPUT\n", var );
	insert( buffer, endlist(&define), &define );
	sprintf( buffer, "#undef\t%s\n", var );
	insert( buffer, endlist(&undef), &undef );
	num_of_delay++;
}

/* 
 *  Function to set information of observable statement
 *	char *obs: name of variable.
 */
static void
set_observable( obs )
char 	*obs;
{
	/* for file of observable infomation    */
	/* 1 set = [variable]->[module ID]->[module]->[flag]->[line] */
	insert( obs, endlist( &observ_table ), &observ_table );
	sprintf( buffer, "%d", module_id );
	insert( buffer, endlist( &observ_table ), &observ_table );
	insert( see(endlist(&module_table)-2,&module_table), 
		endlist( &observ_table ), &observ_table );
	sprintf( buffer, "%c%c", FLAG_OFF, '\0' );
	insert( buffer, endlist( &observ_table ), &observ_table );
	sprintf( buffer, "%d", lineno );
	insert( buffer, endlist( &observ_table ), &observ_table );
}

/* 
 *  Procedure to mark the table of observable variable
 *	char *ident: variable used in funtion.
 */
static void
mark_observable( ident )
char 	*ident;
{
  	int 	i, id;
	
  	for( i = 1; i < endlist(&observ_table); i += 5 ){
	  id = atoi( see(i+1,&observ_table) );
	  if( id == module_id ){
	    if( strcmp( ident, see(i,&observ_table) ) == 0 ){
	      sprintf( buffer, "%c%c", FLAG_ON, '\0' );
	      writelist( buffer, i+3, &observ_table );
	    }
	  }
	}
}


/* 
 *  Procedure to insert observable information to lists
 *	List *table: table of observable variables.
 */
static void
insert_observable( table )
List 	*table;
{
  	int	i, j;
	char	flag;
	int     id;


	for( i = 1; i < endlist( table ); i += 5 ){

	  id = atoi( see(i+1,table) );
	  if( id == module_id ){

	    /* mark variables described exinput */
	    if( num_of_xin != 0 ){
	      for( j = 1; j < endlist(&exinput); j += 3 ){
		id = atoi( see(j+1,&exinput) );
		if( id == module_id ){
		  if( strcmp( see(j,&exinput), see(i,&observ_table) ) == 0 ){
		    sprintf( buffer, "%c%c", FLAG_ON, '\0' );
		    writelist( buffer, i+3, &observ_table );
		  }
		}
	      }
	    }

	    /* mark variables described input */
	    if( num_of_input != 0 ){
	      for( j = 1; j < endlist(&input); j += 3 ){
		id = atoi( see(j+1,&input) );
		if( id == module_id ){
		  if( strcmp( see(j,&input), see(i,&observ_table) ) == 0 ){
		    sprintf( buffer, "%c%c", FLAG_ON, '\0' );
		    writelist( buffer, i+3, &observ_table );
		  }
		}
	      }
	    }

	    /* mark variables described parameter */
	    if( endlist(&param_table) > 1 ){
	      for( j = 1; j < endlist(&param_table); j += 4 ){
		id = atoi( see(j+2,&param_table) );
		if( id == module_id ){
		  if( strcmp(see(j,&param_table),see(i,&observ_table)) == 0 ){
		    sprintf( buffer, "%c%c", FLAG_ON, '\0' );
		    writelist( buffer, i+3, &observ_table );
		  }
		}
	      }
	    }

	    /* insert script for observable information */
	    flag = (char)*see( i+3, table );
	    if( flag == FLAG_ON ){
	      sprintf( buffer, "\tncsm_obs%02d[CN] = %s;\n", 
		       num_of_obs, see( i, table ) );
	      insert( buffer , endlist(&observable), &observable );

	      /* for header file */
	      sprintf( buffer, "%d", num_of_obs );
	      insert( buffer, endlist(&ncs_obs), &ncs_obs );
	      sprintf( buffer, "%s", see( i+2, table ) );
	      insert( buffer, endlist(&ncs_obs), &ncs_obs );
	      sprintf( buffer, "o%02d%s", module_id, see( i, table ) );
	      insert( buffer, endlist(&ncs_obs), &ncs_obs );
	      num_of_obs++;
	    } else {
	      fprintf( stderr, 
		       "Warnning: observable \"%s\" not found in function near line %s\n",
		       see(i,table), see(i+4,table) );
	    }
	  }
	}
}

/* 
 *  Function to set information of parameter statement
 *	char *param: name of parameter.
 *	char *val  : value of parameter.
 *	int  flag  : if there is parameter statement in NETWORK description,
 *                   then flag = 1.
 *                   if there is parameter statement in module description,
 *                   then flag = 0.
 */
static void
set_parameter( param, val, flag )
char 	*param, *val;
int 	flag;
{
  	if( flag == 1 ){	/* NETWORK description */

	  /* begin of line and end of line in function */
	  sprintf( buffer, "#define\t%s\tn00%s\n", param, param );
	  insert( buffer, endlist(&net_def), &net_def );
	  sprintf( buffer, "#undef\t%s\n", param );
	  insert( buffer, endlist(&net_undef), &net_undef );
	  /* for header file */
	  sprintf( buffer, "int n00%s;\n", param );
	  insert( buffer, endlist(&ncs_double), &ncs_double );
	  /* for ncsf_prmset() */
	  sprintf( buffer, "n00%s", param );
	  insert( buffer, endlist(&parameter), &parameter );
	  sprintf( buffer, "%s", val );
	  insert( buffer, endlist(&parameter), &parameter );
	  insert( net_name, endlist(&parameter), &parameter );

	} else {		/* MODULE description */

	  /* begin of line and end of line in function */
	  sprintf( buffer, "#define\t%s\tm%02d%s\n", param, module_id, param );
	  insert( buffer, endlist(&define), &define );
	  sprintf( buffer, "#undef\t%s\n", param );
	  insert( buffer , endlist(&undef), &undef );
	  /* for header file */
	  sprintf( buffer, "double m%02d%s;\n", module_id, param );
	  insert( buffer, endlist(&ncs_double), &ncs_double );
	  /* for ncsf_prmset() */
	  sprintf( buffer, "m%02d%s", module_id, param );
	  insert( buffer, endlist(&parameter), &parameter );
	  sprintf( buffer, "%s", val );
	  insert( buffer, endlist(&parameter), &parameter );
	  insert( see(endlist(&module_table)-2, &module_table ),
		  endlist(&parameter), &parameter);
	  /* parameter information */
	  sprintf( buffer, "%s", param );
	  insert( buffer, endlist(&param_table), &param_table );
	  sprintf( buffer, "%s", val );
	  insert( buffer, endlist(&param_table), &param_table );
	  sprintf( buffer, "%d", module_id );
	  insert( buffer, endlist(&param_table), &param_table );
	  insert( see(endlist(&module_table)-2,&module_table), 
		  endlist(&param_table), &param_table );
	}
	insert( param, endlist(&getprmptr), &getprmptr );
}


/*
 * Function to display error message
 */
int
yyerror( s )
char 	*s;
{
	int 	eline;

	if( error_num++ == 0 ){
	  fprintf( stderr, "In model file \"%s\"\n", model_file_name );
	}
	eline = lineno;

	fprintf( stderr, "Error: %s near line %d\n", s, eline+mline );
	return( 0 );
}

char *get_error_code()
{
	 char *s = NULL;

	 return( s );
}

/**********************************************************************
	    Main Routine
 **********************************************************************/
#ifdef SATELLITE
int 
main()
{
	char 	*argument;              /* argument 1 of npp command */
	char 	*header;                /* argument 2 of npp command */
	char    scf_model[FNAME_WD], scf_header[FNAME_WD], scf_lib[FNAME_WD];
	int  	status, argc;
	char 	*argv[10], dir[FNAME_WD];
	char 	tmp_fname[FNAME_WD];

	read_syscom();               /* for SATELLITE */
	argument = GetString(0);     /* get name of model source file  */
	header = GetString(1);       /* get name of user's header file */

	/* say wellcome */
	fprintf( stdout, "NCS Preprocessor, compiling now.\n");

	/* set path name of working directory */
	if( SetWorkDirSCF( get_tmpdir() ) == FALSE ){
	  exit(15);
	}
	/* Was a model file name assigned or not? */
	if( GetSCFN( scf_model, scf_header, scf_lib ) == NULL ){
	  if( ( argument == NULL ) && 
	      ( strlen(argument) == 0 ) &&
	      ( scf_model[0] == EOS ) ){
	    exit(1);
	  }
	}

	/* Was a header file name assigned or not? */
	if( (header != NULL) && (strlen(header)!=0) ){
	  strcpy( scf_header, header );
	} else {
	  if( (scf_header == NULL) || (strlen(scf_header)==0 )){
	    scf_header[0] = '\0';
	  } 
	}

	/* When first argument was assigned */
	if( ( argument != NULL ) && (strlen(argument) != 0) ){
	  if( SetSCFN( argument, scf_header, scf_lib ) == FALSE ){
	    exit(1);
	  } else {
	    sprintf( tmp_fname, "%s.%s", argument, NCS_MDL_EXTN );
	    model_file_name = strdup( tmp_fname );
	  }
	} else {
	  sprintf( tmp_fname, "%s.%s", scf_model, NCS_MDL_EXTN );
	  model_file_name = strdup( tmp_fname );
	}
	  
	if( ModelNameSCFN( scf_model ) == NULL ){
	  exit(4);
	} else {
	  sprintf( tmp_fname, "%s%s", get_tmpdir(), scf_model );
	  mfile_path = strdup( tmp_fname );
	}

	/* model file -> filter -> final model file */
	argc = 0;
	sprintf( dir, "%s/%s", NCS_BIN_DIR, NCS_PREPRO_FILTER );
	sprintf( tmp_fname, "%s%s", get_tmpdir(), NCS_TMP_MODEL_FILE );

        strargcpy( argv, argc++, dir );
	strargcpy( argv, argc++, model_file_name );
	strargcpy( argv, argc++, NCS_BIN_DIR );
 	strargcpy( argv, argc++, mfile_path );
	strargcpy( argv, argc++, tmp_fname );
	argv[argc] = NULL;

	status = ChildProcess( argv );
	if( status != 0 ){
	  exit( status );
	}

	/* temporary file check */
	switch( get_return_value_filter( tmp_fname ) ){
	  case ERRORM1:
	    exit(3);
	    break;
	  case SUCCESS:
	    mline = 0;
	    break;
	  case 1:
	    mline = -10;
	    break;
	}

	/* open model file */
	if( (yyin = fopen( mfile_path,"r" )) == NULL ){
	  fprintf( stderr, "Model file name = %s\n", mfile_path );
	  exit(3);
	}

        /* initialize list structure */
	init();
	init_list(&net_table);
	init_list(&module_table);
	init_list(&initvalue);
	init_list(&getprmptr);

	work_dir = get_tmpdir();    /* get path of tmp for SATELLITE */

	make_header( scf_model, scf_header );
	                           /* write header to model source file */

	yyparse();                   /* LR(1) parsing routine */

	fclose( yyin );                  /* close model file */

	/* good-by  */
	if( error_num == 0 ){
	  /* write to the model source file */
	  make_headerfile( scf_model );  /* header file     */
	  make_network();                  /* network()       */
	  make_initvalue();                /* initvalue()     */
	  make_ncsf_constset();            /* ncsf_constset() */
	  make_ncsf_prmset();              /* ncsf_prmset()   */
	  make_getprmptr();                /* GetPrmPtr()     */
	  fclose( fp );             

	  /* write to simulation condition file */
	  make_prm_file( &parameter );                 /* for parameter      */
	  make_xin_file();                             /* for external input */
	  make_dly_file( &delay_file );                /* for delay          */
	  make_out_file();                             /* for output         */
	  make_obs_file( &observ_table ); 	       /* for output         */
	  make_mat_file();		               /* for time           */

	  fprintf( stdout, "done.\n" );
	}else{
	  if( error_num == 1 ){
	    fprintf( stdout, "There is a error detected.\n" );
	  }else{
	    fprintf( stdout, "There are %d errors detected.\n", error_num );
	  }
	  free( model_file_name );
	  free( mfile_path );
	  exit(7);
	}

        /* free list structure */
	endprocess();

	free( model_file_name );
	free( mfile_path );
	write_syscom();          /* for SATELLITE */
	return( 0 );
}

#else

/* for NCS priprocessor without SATELLITE */

#endif  /* SATELLITE */


/* 
 * Function to check execution file
 *       char *file_name: file name of execution file
 *       Return         : TRUE  : execution file is able to make.
 *                        FALSE : execution file is not able to make.
 */
int 
check_exec_file_name( file_name )
char 	*file_name;
{
  	if( access( file_name, X_OK ) == 0 ){
	  return( TRUE );
	}else{
	  if( access( file_name, F_OK ) == 0 ){
	    return( FALSE );
	  }else{
	    return( TRUE );
	  }
	}
}

/* 
 * Function to get return value of filter
 *       char *fname : file name of temporary file
 *       Return      : return value of filter.
 *                   
 */
int
get_return_value_filter( fname )
char 	*fname;
{
  	FILE 	*ptr;
	int	ret;
	
	if( (ptr=fopen(fname,"w"))==NULL ){
	  exit(4);
	}
	
	fscanf( ptr, "%d", &ret );
	
	fclose( ptr );
	return( ret );
}


/*
 * Function to initialize all lists.
 */
void init()
{
	init_list( &net_def );
	init_list( &net_undef );
	init_list( &network );
	init_list( &net_info );
	init_list( &module );
	insert( "\n", 1, &module );
	init_list( &f_header );
	init_list( &name );
	init_list( &exinput );
	init_list( &input );
	init_list( &output );
	init_list( &observable );
	init_list( &observ_table );
	init_list( &integ );
	insert( "\n", 1, &integ );
	init_list( &constant );
	init_list( &constant2 );
	init_list( &parameter );
	init_list( &param_table );
	init_list( &initial );
	init_list( &define );
	init_list( &declare );
	init_list( &delay );
	insert( "\n", 1, &delay );
	init_list( &function );
	init_list( &undef );
	init_list( &f_end );
	init_list( &ncs_double );
	init_list( &ncs_obs );
	init_list( &ncs_xin );
	init_list( &delay_file );
	init_list( &fact );

	init_list( &net_module );
	init_list( &net_inputs );
	init_list( &net_loads );

	init_list( &cell_modules );
	init_list( &synapse_modules );
	init_list( &gap_modules );

	init_list( &clang );
	csflag = 0;
}

/*
 * Function to write description of include file to model source file
 */
void make_header( input_file_name, usr_header_file )
char input_file_name[];
char usr_header_file[];
{
	char out_file_name[256];

	/* open the model source file */
	sprintf( out_file_name, "%s%s.%s", 
		 work_dir, input_file_name, NCS_SPF_EXTN );
	if( (fp = fopen(out_file_name,"w")) == NULL){
	  printf( "Can't open '%s'\n", out_file_name );
	  exit(3);
	}
	
	fprintf(fp,"#include <stdio.h>\n");
	fprintf(fp,"#include <string.h>\n");
	fprintf(fp,"#include <math.h>\n");
	sprintf(buffer,"#include \"%s.h\"\n" , input_file_name );
	fprintf(fp,"%s",buffer);
 	fprintf(fp,"#include \"ncss.h\"\n");
	if( (usr_header_file[0] != '\0') || strlen(usr_header_file) != 0  ){
	  fprintf(fp,"#include \"%s\"\n",usr_header_file);
	}else{
	  fprintf(fp,"\n");
	}

}

/*
 * Function to write directory described C-langage sources to model source file
 */
void make_csources()
{
  int i;

  fprintf( fp, "/*** this lines described in model files directory ***/" );
  for( i = 1; i < endlist(&clang); i++){
    fprintf( fp, "%s", see(i,&clang) );
  }
}

/*
 * Function to write initvalue() to model source file
 */
void make_initvalue()
{
	int 	i;

	insert( "\n", 1, &initvalue );
	/* set integration constant */
	insert( "void initvalue( Ncs_y )\ndouble **Ncs_y;\n{\n\tint i,k;\n\n\tfor(i=0 ; i < ncsg_cell ; i++){\n", 1, &initvalue );
	insert( "\t}\n\n", endlist(&initvalue), &initvalue );

	/* for delay information */
	if( num_of_delay != 0 ){
	  sprintf( buffer, "\tfor(k=0 ; k < NCS_DLY_NT ; k++){\n" );
	  insert( buffer, endlist(&initvalue), &initvalue );
	  sprintf( buffer,"\t\tncs_dly[k].q = (double **)alloc2d(ncsg_cell,ncsg_qsize[k],sizeof(double));\n" );
	  insert( buffer, endlist(&initvalue), &initvalue );
	  sprintf( buffer, "\t\tfor(i=0 ; i < ncsg_cell; i++){\n\t\t\tinit_queue(ncs_dly[k].q[i],ncsg_qsize[k],ncsg_dlyinit[k]);\n\t\t}\n\t}\n\n");
	  insert( buffer, endlist(&initvalue), &initvalue );
	}
	/* end of lines of initvalue() */
	insert("}\n\n",endlist(&initvalue),&initvalue);

	/* write initvalue() to model source file */
	for( i = 1; i < endlist(&initvalue); i++){
	  fprintf( fp, "%s", see(i,&initvalue) );
        }
}

/*
 * Function to write header file for model source file
 */
void 
make_headerfile( input_file_name )
char *input_file_name;
{
	int 	i, j;
	int 	cell_module_max;   /* maximum number of cell module */
	int 	xin_max;           /* NCS_XIN_MAX */
	FILE *ptr;
	char tmp[NPP_VAL_LEN+3];
	char out_file_name[32];    /* file name of header file */

	cell_module_max = 0;
	xin_max = 0;

	/* rewrite list                                             */
	/* (module name->module ID->module type->component number ) */
	for( i = 1; i <= endlist(&net_table)-1; i = i + 3 ){
	  if( locate(see(i,&net_table),&module_table) != 0 ){
	    insert( see(i+1,&net_table),
		    locate(see(i,&net_table),&module_table)+3,&module_table );
	  }
	}

	/* calculate maximum number of cell module */
	for( i = 1; i < endlist(&module_table) ; i = i + 4 ){
	  if( (cell_module_max < atoi(see(i+3,&module_table))) 
	      && (atoi(see(i+2,&module_table)) == 1) ){
	    cell_module_max = atoi( see(i+3,&module_table) );
	  }
	}

	/* write begin of lines of header file */
	init_list( &header );

	insert( "#define\tNCELL\t", endlist(&header), &header );
	sprintf( buffer, "%d\n", cell_module_max );
	insert( buffer, endlist(&header), &header );

	insert( "#define\tNEQN\t", endlist(&header), &header );
	/* if there is no integration in model file, then integration is 1 */
	if( num_of_integ == 0 ){
	  sprintf( buffer, "%d\n", 1 );
	} else {
	  sprintf( buffer, "%d\n", num_of_integ );
	}
	insert( buffer, endlist(&header), &header );

	insert( "#define\tNCS_OUT_NT\t", endlist(&header), &header );
	sprintf( buffer, "%d\n", module_count );
	insert( buffer, endlist(&header), &header );

	/* if there is no exinput in model file, then exinput is 1 */
	insert( "#define\tNCS_XIN_NT\t", endlist(&header), &header );
	if( num_of_xin == 0 ){
	  sprintf( buffer, "%d\n", 1 );
	} else {
	  sprintf(buffer,"%d\n",num_of_xin);
	}
	insert( buffer, endlist(&header), &header );

	/* if there is no observable in model file, then observable is 1 */
	insert( "#define\tNCS_OBS_NT\t", endlist(&header), &header );
	if( num_of_obs == 0 ){
	  sprintf( buffer, "%d\n", 1 );
	} else {
	  sprintf( buffer, "%d\n", num_of_obs );
	}
	insert( buffer, endlist(&header), &header );

	/* if there is no input in model file, then input is 1 */
	insert( "#define\tNCS_NNET\t", endlist(&header), &header );
	if( max_input == 0 ){
	  sprintf( buffer, "%d\n", 1 );
	} else {
	  sprintf( buffer, "%d\n", max_input );
	}
	insert( buffer, endlist(&header), &header );

	/* this value is 2 that is true? */
	insert("#define\tNCS_XFM_FADDR\t",endlist(&header),&header);
	insert("2\n",endlist(&header),&header);

	/* write NCS_XIN_MAX */
	for( i = 1; i < endlist(&ncs_xin); i++ ){
	  sprintf( tmp, "%s", see(i,&ncs_xin) );
	  for( j = 2; j < endlist(&module_table) ; j += 4 ){
	    if( strcmp(tmp,see(j,&module_table)) == 0 ){
	      xin_max += atoi( see(j+2,&module_table) );
	      break;
	    }
	  }
	}
	/* calculation of NCS_XIN_MAX */
	if( xin_max == 0 ){
	  xin_max = 1;
	}
	insert( "#define\tNCS_XIN_MAX\t", endlist(&header), &header );
	sprintf( buffer, "%d\n", xin_max );
	insert( buffer, endlist(&header), &header );

	/* for output include routine to match module */
	for( i = 0; i< module_count; i++ ){
	  for( j = 2; j < endlist(&module_table) ; j += 4 ){
	    sprintf( tmp, "%d", i );
	    if( strcmp(tmp,see(j,&module_table)) == 0 ){
	      /* name of module */
	      sprintf( tmp, "%s", see(j-1,&module_table) ); 
	      break;
	    }
	  }
	  
          /*                      module ID v       v comp number */
	  sprintf(buffer, "#define\tNCS_OUT%02d_NC\t%s\n", 
		  i, see(locate(tmp,&module_table)+3,&module_table) );
	  insert( buffer, endlist(&header), &header );
	  sprintf( buffer, "double ncsm_outm%02d[%s];\n",
		   i, see(locate(tmp,&module_table)+3,&module_table ));
	  insert( buffer, endlist(&header), &header );
	  sprintf( buffer, "double ncsm_outs%02d[%s];\n",
		   i, see(locate(tmp,&module_table)+3,&module_table) );
	  insert( buffer, endlist(&header), &header );
	}

	/* for exinput */
	for( i = 0; i < num_of_xin; i++ ){
	  /*             v module ID */
	  sprintf( tmp,"%s",see(i+1,&ncs_xin) );
	  for( j = 2; j < endlist(&module_table); j += 4 ){
	    if( strcmp(tmp,see(j,&module_table)) == 0 ){
	      strcpy( tmp,see(j+2,&module_table));
	      break;
	    }
	  }
	  sprintf( buffer, "#define\tNCS_XIN%02d_NC\t%s\n", i, tmp );
	  insert( buffer, endlist(&header), &header );
	  sprintf( buffer, "double ncsm_xin%02d[%s];\n", i, tmp );
	  insert( buffer, endlist(&header), &header );
	}

	/* for observable */
	for( i = 0; i < num_of_obs; i++ ){
	  strcpy( tmp, see(3*i+2,&ncs_obs) );
	  sprintf( buffer, "#define\tNCS_OBS%02d_NC\t%s\n",
		   i, see(locate(tmp,&module_table)+3, &module_table) );
	  insert( buffer, endlist(&header), &header );
	  sprintf( buffer, "double ncsm_obs%02d[%s];\n",
		   i, see(locate(tmp,&module_table)+3, &module_table) );
	  insert( buffer, endlist(&header), &header );
	}

	/* declaration of parameter */
	listcat( &header, &ncs_double );

	/* for delay */
	insert( "#define\tNCS_DLY_NT\t", endlist(&header), &header );
	if( num_of_delay == 0 ){
	  insert( "1\n", endlist(&header), &header );
	} else {
	  sprintf( buffer, "%d\n", num_of_delay );
	  insert( buffer, endlist(&header), &header );
	  insert( "int queue_size[NCS_DLY_NT];\n", endlist(&header), &header );
	  sprintf( buffer,
		   "struct\tncs_queue{\n\tdouble **q;\n}\tncs_dly[NCS_DLY_NT];\n");
	  insert( buffer, endlist(&header), &header );
	}

	/* write to file */
	sprintf( buffer, "%s%s.h", work_dir, input_file_name );
	strcpy( out_file_name, buffer );
	if( (ptr=fopen(out_file_name,"w")) == NULL ){
	  exit(5);
	}
	for( i = 1; i < endlist(&header) ; i++ ){
	  fprintf( ptr, "%s", see(i,&header) );
	}
	fclose( ptr );
	clearlist( &header );
}
	
/*
 * Function to write ncsf_constset() to the model source file
 */
void make_ncsf_constset()
{
	int 	i;
	char 	tmp[NPP_VAL_LEN+3];
	List 	f_const;     /* to store final script of ncsf_constset()  */
	List 	local_table; /* table translated module name -> module ID */

	/* making of local tabel */
	init_list( &f_const );
	init_list( &local_table );
	for( i = 1; i < endlist(&module_table) ; i = i + 4 ){
	  insert( see(i,&module_table), endlist(&local_table), &local_table );
	  insert(see(i+1,&module_table), endlist(&local_table), &local_table );
	}

	/* write output information to the function */
	for( i = 0; i < module_count; i++ ){
	  sprintf( buffer, "\tncsm_outptr[%d] = ncsm_outm%02d;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsm_subptr[%d] = ncsm_outs%02d;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( tmp, "%d", i );
	  sprintf( buffer, "\tstrcpy( ncsg_outtbl[%d] , \"%s\" );\n",
		   i, see(locate(tmp,&local_table)-1,&local_table) );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_ncout[%d] = NCS_OUT%02d_NC;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_outtblptr[%d] = ncsg_outtbl[%d];\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  insert( "\n", endlist(&f_const), &f_const );
	}

	/* write exinput informaiton to the function */
	for( i = 0; i < num_of_xin; i++ ){
	  sprintf( buffer, "\tncsm_xinptr[%d] = ncsm_xin%02d;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  strcpy( tmp, see(i+1,&ncs_xin) );
	  sprintf( buffer, "\tstrcpy(ncsg_xintbl[%d] , \"%s\");\n",
		   i, see(locate(tmp,&local_table)-1,&local_table) );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_ncxin[%d] = NCS_XIN%02d_NC;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_xintblptr[%d] = ncsg_xintbl[%d];\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  insert( "\n", endlist(&f_const), &f_const );
	}

	/* write observable information to the function */
	for( i = 0; i < num_of_obs; i++ ){
	  sprintf( buffer, "\tncsm_obsptr[%d] = ncsm_obs%02d;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  strcpy( tmp, see(3*i+3,&ncs_obs) );
	  sprintf( buffer, "\tstrcpy(ncsg_obstbl[%d] , \"%s\");\n", i, tmp );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_ncobs[%d] = NCS_OBS%02d_NC;\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  sprintf( buffer, "\tncsg_obstblptr[%d] = ncsg_obstbl[%d];\n", i, i );
	  insert( buffer, endlist(&f_const), &f_const );
	  insert( "\n", endlist(&f_const), &f_const );
	}

	/* write end of lines of the function */
	sprintf( buffer, "\t*(ncsg_outtbl[%d]) = \'\\0\';\n", module_count );
	insert( buffer,endlist(&f_const),&f_const);
	sprintf( buffer, "\t*(ncsg_xintbl[%d]) = \'\\0\';\n", num_of_xin );
	insert( buffer, endlist(&f_const), &f_const );
	sprintf( buffer, "\t*(ncsg_obstbl[%d]) = \'\\0\';\n", num_of_obs );
	insert( buffer, endlist(&f_const), &f_const );
	insert( "\n", endlist(&f_const), &f_const );

	sprintf( buffer, "\tncsg_ntout = NCS_OUT_NT;\n" );
	insert( buffer, endlist(&f_const), &f_const );
	/* if the model has exinput information, */
	if( num_of_xin != 0 ){
	  sprintf( buffer, "\tncsg_ntxin = NCS_XIN_NT;\n" );
	  insert( buffer, endlist(&f_const), &f_const );
	}
	/* if the model has observable information */
	if( num_of_obs != 0 ){
	  sprintf( buffer, "\tncsg_ntobs = NCS_OBS_NT;\n" );
	  insert( buffer, endlist(&f_const), &f_const );
	}
	sprintf( buffer, "\tncsg_cell = NCELL;\n" );
	insert( buffer, endlist(&f_const), &f_const );
	sprintf( buffer, "\tncsg_neqn = NEQN;\n" );
	insert( buffer, endlist(&f_const), &f_const );
	sprintf( buffer, "\tncsg_relerr = 1.0e-04;\n" );
	insert( buffer, endlist(&f_const), &f_const );

	/* write begin and end of line to the function */
	insert( "void ncsf_constset()\n{\n", 1, &f_const );
	insert( "}\n\n", endlist(&f_const), &f_const );

	/* write the function from list to the model source file */
	for( i = 1; i < endlist(&f_const); i++ ){
	  fprintf( fp, "%s", see(i,&f_const) );
	}
	clearlist( &f_const );
	clearlist( &local_table );
}

/*
 * Function to write ncsf_prmset() to the model source file
 */
void make_ncsf_prmset()
{
	int 	i;
	List 	prmset;          /* to store final script of ncsf_prmset() */

	init_list( &prmset );

	/* write the first line of the function to list */
	sprintf( buffer, 
		 "int ncsf_prmset( ncs_prm )\nstruct scf_prm\t*ncs_prm;\n{\n");
	insert( buffer, 1, &prmset );
	sprintf( buffer, 
		 "\tint ncs_dest;\n\tstatic char *ncs_prmtbl[] = {\n" );
	insert( buffer, 2, &prmset );

	/* write parameters */
	for( i = 1; i < endlist(&parameter); i += 3 ){
	  sprintf( buffer, "\t\t\"%s\",\n", see(i,&parameter) );
	  insert( buffer, endlist(&prmset), &prmset );
	}
	sprintf( buffer, "\t\t EOS  };\n\n" );
	insert( buffer, endlist(&prmset), &prmset );

	sprintf( buffer, "\tncs_dest = string_ana(ncs_prm->prm_name,ncs_prmtbl,MODE0);\n\n\tswitch(ncs_dest){\n");
	insert( buffer, endlist(&prmset), &prmset );
	
	/* write case sentence */
	for( i = 1; i < endlist(&parameter); i += 3 ){
	  sprintf( buffer,
		   "\tcase %d: %s = (double)ncs_prm->prm_val.prm_real;\n\t\tbreak;\n",
		   (i+2)/3, see(i,&parameter) );
		insert( buffer, endlist(&prmset), &prmset );
	}
	sprintf( buffer, 
		 "\tdefault: return (-1);\tbreak;\n\t}\n\treturn (0);\n}\n" );
	insert( buffer, endlist(&prmset), &prmset );

	/* write the function from list to the model source file */
	for( i = 1; i < endlist(&prmset); i++ ){
	  fprintf( fp, "%s", see(i,&prmset) );
	}
}

/*
 * Function to write NETWORK() to the model source file
 */
void make_network()
{
	int 	i, j;
	List 	line;
	char 	local_buffer[4096];
	char 	poscn[127];
	int 	iflag;

	init_list(&line);

	/* pre-process(modified from ";"->";" to ";" in list */
	for( i = 1; i < endlist(&net_info)-1; i++ ){
	  sprintf( buffer, "%s", see(i,&net_info) );
	  sprintf( poscn, "%s", see(i+1,&net_info) );
	  if( (strcmp(buffer,";") == 0) && (strcmp(poscn,";") == 0) ){
	    delete( i, &net_info );
	  }
	}

	/* write the first lines to the function */
	sprintf( buffer, "void NETWORK( NcsTime, Ncs_y , Ncs_dy)\n" );
	insert( buffer, 1, &network );
	sprintf( buffer, "double NcsTime,**Ncs_y,**Ncs_dy;\n{\n" );
	insert( buffer, 2, &network );

	/** work befor ";" **/
	/* for "for" sentence */
	while( endlist(&net_info) != 1 ){
	  sprintf( buffer, "%s", see(1,&net_info) );
	  if( strcmp(buffer,"for") == 0 ){
	    /* write "int" to the function */
	    sprintf( buffer, "\t%s\n",see(2,&net_info) );
	    /* don't write the same name variable */
	    iflag = 0;
	    for( j = 3; j < endlist(&net_info); j++ ){
	      if( strncmp( see(j,&net_info),see(2,&net_info), 5 ) == 0 ){
		iflag++;
		break;
	      }
	    }
	    if( iflag == 0 ){
	      insert( buffer, 3, &network );
	    }
	    sprintf( local_buffer, "\tfor (%s){\n\n", see(3,&net_info) );
	    insert( local_buffer, endlist(&network), &network );
	    delete( 1, &net_info );
	    delete( 1, &net_info );
	    delete( 1, &net_info );
	  }
	  make_line( &line );

	  listcat( &network, &line );
	}

	/* write end of lines to the function */
	insert("} /* network */\n\n",endlist(&network),&network);

	/* difine for the function */
	for( i = 1 ; i < endlist(&net_def); i++ ){
	  insert( see(i,&net_def), 1, &network );
	}

	/* undef for the function  */
	listcat( &network, &net_undef );

	/* write the function from list to the model source file */
	for( i = 1; i < endlist(&network); i++ ){
	  fprintf( fp, "%s", see(i,&network) );
	}
}

/*
 * Function to write lines before ";" to another list 
 * and delete the lines from the source list.
 */
void make_line( line_ptr )
List 	*line_ptr;
{
	int 	i , j;
	int 	net_number;       /* NET[net_number] */
	int 	local_id;
	char 	buffer2[1024];
	char 	buffer2_1[1024];
	char 	buffer3[1024];
	char 	end_line[1024];   /* store left side of equation */
	char 	poscn[8];
	char 	precn[8];
	char 	cn[8];
	int 	check_num;
	int 	module_num;
	char   *buffer2_1p;

	net_number = 0;

	/* for left side of equation */
	i = locate( "*", &net_info );
	sprintf( buffer2, "%s", see(i+1,&net_info) );
	sprintf( buffer2_1, "%s", see(i+1,&net_info) );
	sprintf( buffer3, "%s", see(i+1,&net_info) );
	buffer2_1p = buffer2_1;
	/* because a next strtok() can be terminated by null */
	strtok( buffer2_1, "," );

	/* end of lines */
	sprintf( end_line, "\tCN = %s;\n\t%s(NcsTime , Ncs_y , Ncs_dy);\n\n",
		 strchr(buffer2,',')+1, buffer2_1p );
	/* free buffer2 */

	/* to ready when the model is described multiple cell module */
	/* get POSCN  */
	sprintf( poscn, "%s", strchr(buffer3,',')+1 );

	/* get module ID */
	sprintf( buffer2, "%s", strtok(buffer3,",") );
	/* free buffer3 */

	local_id = atoi( see(locate(buffer2,&module_table)+1,&module_table) );

	module_num = atoi( see(locate(buffer2,&net_table)+1, &net_table) );

	/* keep mark of "*" because this mark indicate left side of equation */
	delete(i+1,&net_info); /* delete the line next to "*" */


	sprintf(buffer3,"\tPOSOUT = ncsm_outm%02d[%s];\n",local_id,poscn);

	/* when the model is described multiple cell modules */
	if( locate("*",&net_info) != 1 ){
	  sprintf( buffer, "%s", poscn );
	  check_num = atoi( poscn );
	  if( strchr("0123456789", (int)buffer[0]) == NULL ){
	    sprintf( buffer, "\tif( %s >= %d ){\n", poscn, module_num );
	    insert( buffer, endlist( line_ptr ), line_ptr );
	    sprintf( buffer, "\t\texit(23); }\n" );
	    insert( buffer, endlist( line_ptr ), line_ptr );
	  }else{
	    /*
	    if( atoi(poscn) >= module_num ){
	      exit( 157 );
	    }
	    */
	  }
	  sprintf( buffer2, "\tPOSCN = %s;\n", poscn );
	  insert( buffer2, endlist(line_ptr), line_ptr ); /* poscn  */
	  insert( buffer3, endlist(line_ptr), line_ptr ); /* posout */
	  sprintf( buffer3, "\tNET[%d] = 0.0;\n\n", net_number );
	  insert( buffer3, endlist(line_ptr), line_ptr );
	}

	while( strcmp(see(1,&net_info),"*") != 0 ){
	  /* get PRECN */
	  sprintf( buffer, "%s", see(1,&net_info) );
	  sprintf( buffer2, "%s", strchr(buffer,'<')+1 );
	  sprintf( precn, "%s", strchr(buffer2,',')+1 );
	  
	  /* get module ID which is right side INPUT */
	  sprintf( buffer, "%s", see(1,&net_info) );
	  sprintf( buffer2, "%s", strchr(buffer,'<')+1 );
	  sprintf( buffer3, "%s", strtok(buffer2,",") );
	  local_id = atoi(see(locate(buffer3,&module_table)+1,&module_table));
	  module_num = atoi( see(locate(buffer3,&net_table)+1,&net_table) );

	  /* get CN */
	  sprintf( buffer, "%s", see(1,&net_info) );
	  sprintf( buffer2, "%s", strchr(buffer,',')+1 );
	  sprintf( cn, "%s", strtok(buffer2,"<") );

	  /* get the module name */
	  sprintf( buffer, "%s", see(1,&net_info) );
	  sprintf( buffer2, "%s", strtok(buffer,",") );
		
	  /* write all lines to the list */
	  sprintf( buffer, "\tPRECN = %s;\n", precn );
	  insert( buffer, endlist(line_ptr), line_ptr );

	  sprintf( buffer, "%s", precn );
	  check_num = atoi( precn );
	  if( strchr("0123456789",(int)buffer[0]) == NULL ){
	    sprintf( buffer, "\tif( %s >= %d ){\n", precn, module_num );
	    insert( buffer, endlist(line_ptr), line_ptr );
	    sprintf( buffer, "\t\texit(23); }\n" );
	    insert( buffer, endlist(line_ptr), line_ptr );
	  }else{
	    /*
	      if( check_num >= module_num ){
	      exit( 157 );
	      }
	      */
	  }

	  sprintf( buffer, "\tINPUT = ncsm_outm%02d[%s];\n", local_id, precn );
	  insert( buffer, endlist(line_ptr), line_ptr );
	  sprintf( buffer, "\tCN = %s;\n", cn );
	  insert( buffer, endlist(line_ptr), line_ptr );
	  sprintf( buffer,
		   "\tNET[%d] += %s(NcsTime , Ncs_y , Ncs_dy);\n\n",
		   net_number, buffer2 );
	  insert( buffer, endlist(line_ptr), line_ptr );

	  delete( 1, &net_info );
		
	  j = strlen( see(2,&net_info) );
	  sprintf( buffer, "%s", see(1,&net_info) );
	  if( strcmp(buffer,"!") == 0 ){
	    /* delete "!" from the list */
	    delete( 1, &net_info );
	    if( j > 1 ){
	      net_number++;
	      sprintf( buffer, "\tNET[%d] = 0.0;\n\n", net_number );
	      insert( buffer, endlist(line_ptr), line_ptr );
	    }
	  }
	}

	/* delete "*" from the list */
	delete( 1, &net_info );

	/* finally, write the left side of equation */
	insert( end_line, endlist(line_ptr), line_ptr );

	/* check end of "for" sentence */
	j = locate( ";", &net_info );
	for( i = 1; i < j; i++ ){
	  sprintf( buffer, "%s", see(i,&net_info) );
	  if( strcmp(buffer,"$") == 0 ){
	    insert( "\t} /* for */\n\n", endlist(line_ptr), line_ptr );
	    delete( i, &net_info );
	    break;
	  }
	}
	/* delete ";" from the list */
	delete( 1, &net_info );
}

/*
 * Function to write GetPrmPtr() for linking to NPE
 *                                      	[ Oct.3,1994 ]
 */
void make_getprmptr()
{
  	int	i, j;
  	List	flist;

	init_list( &flist );

	/* module name */
	for( i = 1, j = 1; i < endlist(&name); i+=2 ){
	/* parameter name */
	  while( (endlist(&getprmptr) > j) && 
	      (strncmp(see( j, &getprmptr ), ENDMARK_GPP, 1) != 0) ){

	    /* first half of script of "if" sentence */
	    sprintf( buffer, "\tif(!strcmp(\"%s\",mdl_name) ", 
		    see( i+1, &name) );
	    insert( buffer, endlist(&flist), &flist );

	    /* second half of script of "if" sentence */
	    sprintf( buffer, "&& !strcmp(\"%s\",prm_name)){\n", 
		    see( j, &getprmptr) );
	    insert( buffer, endlist(&flist), &flist );
	    if( i == 1 ){
	      sprintf( buffer, "\t\t\treturn( &n00%s );\n\t}\n", 
		      see( j, &getprmptr ) );
	    } else {
	      sprintf( buffer, "\t\t\treturn( &m%02d%s );\n\t}\n", 
		      atoi(see(i,&name)),see( j, &getprmptr ) );
	    }
	    insert( buffer, endlist(&flist), &flist );
	    
	    /* next parameter */
	    j++;
	  }
	  /* move for ENDMARK_GPP */
	  j++;
	}

	/* the first lines of the function */
	insert( "char *mdl_name, *prm_name;\n{\n", 1, &flist );
	insert( "double *GetPrmPtr( mdl_name, prm_name )\n", 1, &flist );
	insert( "/*\t       \t\t*/\n", 1, &flist );
	insert( "/*\tfor NPE\t\t*/\n", 1, &flist );
	insert( "\n/*\t       \t\t*/\n", 1, &flist );

	/* the end of lines of the function */
	insert( "\t/* Failded */\n\treturn( NULL );\n", 
		endlist(&flist), &flist);
	insert( "\n}\t/* GetPrmPtr() */\n\n", endlist(&flist), &flist );
	  
	for( i = 1; i < endlist(&flist); i++ ){
	  fprintf( fp, "%s", see(i,&flist) );
	}
	  
	clearlist( &flist );
}


/* 
 * Write simulation condition file for parameter information
 */
void 
make_prm_file( info )
List *info;
{
	int 	 i;
	PrmFile prm;
	char 	mdl_name[SCF_NAME_LEN];         
	char   	prm_name[SCF_NAME_WID];
	double 	value;
	char	type;


	if( PrmMakeSCF() == FALSE ){
	  exit(60);
	}

	for( i = 1; i < endlist(info); i += 3 ){
	  sprintf( mdl_name, "%s", see(i+2,info) );
	  sprintf( prm_name, "%s", see(i,info) );
	  value = atof( see(i+1,info) );
	  type = SCF_PRM_TYPE_NORMAL;

	  PrmSetInfoSCF(&prm, &type, mdl_name, prm_name, value );
	  if( PrmAddInfoSCF( &prm ) == FALSE ){
	    exit(61);
	  }

	}
}
		
/* 
 * Write simulation condition file for external input information
 */
void 
make_xin_file()
{
	/* making of base of SCF file for exinput */
  	if( XinMakeSCF() == FALSE ){
	  exit(70);
	}

	/* making of base of SCF file for external input function */
  	if( XfpMakeSCF() == FALSE ){
	  exit(75);
	}
}

/* 
 * Write simulation condition file for delay information
 */
void 
make_dly_file( info )
List *info;
{
	int 	i;
	DlyFile dly;
	char	flag;

	/* making of base of SCF file for delay */
  	if( DlyMakeSCF() == FALSE ){
	  exit(80);
	}

	/* setting of SCF file for delay */
	flag = SCF_DLY_FLAG_FIX; 
	if( endlist(info) != 1 ){
	  for( i = 1; i < endlist(info); i += 4 ){
	    DlySetInfoSCF( &dly, see(i,info), see(i+1,info),
			   atof( see( i+2, info ) ), atof( see( i+3, info ) ), 
			   &flag );
	    if( DlyAddInfoSCF( &dly ) == FALSE ){
	      exit(81);
	    } 
	  }
	}
}

/* 
 * Write simulation condition file for output information
 */
void 
make_out_file()
{
	/* making of base of SCF file for observable */
  	if( OutMakeSCF() == FALSE ){
	  exit(50);
	}
}

/* 
 * Write simulation condition file for observable information
 */
void 
make_obs_file( info )
List *info;
{
  	int	i;
	int	lp;
	int     mod;
	int	component = 0;
	char    flag;
	ObsFile obs;

  	if( ObsMakeSCF() == FALSE ){
	  exit(55);
	}

	/* store all observable informaiton */
	obs.type = SCF_OBS_NORMAL;
	for( i = 1; i < endlist(info); i += 5 ){
	  mod = 0;
	  flag = (char)*see( i+3, info );
	  /* There is the variable in function description */
	  if( flag == FLAG_ON ){	
	    strcpy( obs.info.var, see(i,info) );
	    strcpy( obs.info.module, see(i+2,info) );

	    if( (lp=locate(obs.info.module,&cell_modules)) != 0 ){
	     mod = 1;
	     component = atoi( see(lp+1,&cell_modules) );
	    }
	    if( ( mod == 0 ) && 
		( (lp=locate(obs.info.module,&synapse_modules)) != 0 ) ){
	      mod = 2;
	      component = atoi( see(lp+1,&synapse_modules) );
	    }
	    if( ( mod == 0 ) && 
		( (lp=locate(obs.info.module,&gap_modules)) != 0 ) ){
	      mod = 3;
	      component = atoi( see(lp+1,&gap_modules) );
	    }
	    
	    if( mod != 0 ){
	      obs.info.max_comp = component;
	    } else {
	      fprintf( stderr, 
		       "Wanning: \"%s\" module is not defined in network description", 
		       obs.info.module );
	      obs.info.max_comp = 0;
	    }
	  
	    if( ObsAddInfoSCF( &obs ) == FALSE ){
	      exit(55);
	    }
	  }
	}

	clearlist( info );
}


/* 
 * Write simulation condition file for calculation information
 */
void 
make_mat_file()
{
	MatFile	mat;
	int 	cell_module_max = 0;
	int 	i;
	char	method;

	if( MatMakeSCF() == FALSE ){
	  exit(60);
	}

	for( i = 1; i < endlist(&module_table); i += 4 ){
	  if( (cell_module_max < atoi(see(i+3,&module_table))) 
	      && (atoi(see(i+2,&module_table))==1) ){
	    cell_module_max = atoi( see(i+3,&module_table) );
	  }
	}
	method = SCF_MAT_INTEG_FERBERG;
	
	MatSetInfoSCF( &mat, 1.0, 0.1, 0.1, 1.0, &method,
		      cell_module_max, 1.0e-5 );

	if( MatAddInfoSCF( &mat ) == FALSE ){
	  exit(61);
	}
}

/* 
 * end of command
 */
void 
endprocess()
{
	clearlist( &net_def );
	clearlist( &net_undef );
	clearlist( &network );
	clearlist( &net_info );
	clearlist( &module );
	clearlist( &f_header );
	clearlist( &name );
	clearlist( &exinput );
	clearlist( &input );
	clearlist( &output );
	clearlist( &observable );
	clearlist( &observ_table );
	clearlist( &integ );
	clearlist( &constant );
	clearlist( &parameter );
	clearlist( &param_table );
	clearlist( &initial );
	clearlist( &define );
	clearlist( &declare );
	clearlist( &delay );
	clearlist( &function );
	clearlist( &undef );
	clearlist( &f_end );
	clearlist( &ncs_double );
	clearlist( &ncs_obs );
	clearlist( &ncs_xin );
	clearlist( &delay_file );
	clearlist( &fact );

	clearlist( &net_module );
	clearlist( &net_inputs );
	clearlist( &net_loads );

	clearlist( &cell_modules );
	clearlist( &synapse_modules );
	clearlist( &gap_modules );
}
