/*****************************************************************************
  
 	          NCS SIMULATION CONDITION SETTING COMMAND
		  SETTING OF SIMULATION CONDITION FILE NAME

    $Id: nasgn.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */
#include <string.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"

int
main()
{
	char	*tmpdir;
	char	*scf_name;
	char 	*file_name1, *file_name2;

#ifdef SATELLITE
	resat();
	tmpdir = get_tmpdir();
#endif /* SATELLITE */

	scf_name = GetString(0);
	file_name1 = GetString(1);
	file_name2 = GetString(2);

	if( SetWorkDirSCF( tmpdir ) == FALSE ){
	  exit(15);
	}

	if( strcmp(scf_name, "?") == 0 ){
	  ListupSCFN( stdout );
	} else {
	  SignSCFN( scf_name, file_name1, file_name2 );
	}

	return (0);
}				/* main() */
