/*****************************************************************************
  
                   NCS CALCULATION COMMAND
  
    $Id: ncal.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $
  
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"

#define	MAXARGS	10

int
main()
{
	char            scf_name[FNAME_WD];
	int             status, argc = 0;
	char           *argv[MAXARGS];
	char	       	buffer[255];

#ifdef SATELLITE
	resat();
	SetWorkDirSCF( get_tmpdir() );
#endif /* SATELLITE */

	if( ModelNameSCFN( scf_name ) == NULL ){
	  exit(6);
	}

	strcpy( buffer, get_tmpdir());
	strcat( buffer, scf_name);
	strargcpy(argv, argc++, buffer);
	argv[argc] = NULL;

	status = ChildProcess(argv);
	return (status);
}
