/*****************************************************************************
  
         	NCS SIMULATION CONDITION SETTING COMMAND
                 SETTING OF NUMBER OF BUFFER TO OUTPUTS 
  
    $Id: nchgbuff.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <string.h>
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "common.h"
#include "comlib.h"
#include "ncsdef.h"
#include "scflib.h"
#include "scfn.h"
#include "ncssscf.h"

#define  OFFSET_HEAD 0L
#define  OUTPUT_FILE  "NCSOUT.DAT"
#define  RECSIZE		(sizeof(struct scf_out))
#define  RECORD1		(0)
#define  RECORD2		(RECSIZE)
#define  RECORD3		(RECSIZE*2)
#define  RECORD4		(RECSIZE*3)
#define  PRMNUM			5

#ifndef L_SET
#define L_SET  0
#define L_INCR 1
#define L_XTND 2
#endif

static int
Check_buff_num( fd_out )
int             fd_out;
{
	int             ret, DataNo;
	long            offset;
	struct scf_out  sc;

	offset = RECORD1;
	lseek(fd_out, offset, L_SET);

	DataNo = 0;
	while ((ret = read(fd_out, (char *) &sc, RECSIZE)) != FCNTL_ERROR 
	       && sc.type != NCS_SCF_EOF
	       && ret >= RECSIZE ) {
		DataNo++;
		/*		fprintf( stderr, "sc.rec_type = %c\n", sc.rec_type );*/
		if( sc.type == OUT_BUFF_SIZE_TYPE ){
		  return (DataNo);
		}
	}
	return (0);
}


/**************************************************************************
	fd_out  : file pointer of *.OUT 
	argv[]  : argument of nout* 
	data_num: ( != 0) Nth data. ( == 0 ) additional data. 
***************************************************************************/
static void
Set_out_info( fd_out, data_num, number )
int             fd_out, data_num, number;
{
	long            offset;
	struct scf_out  sc;

	offset = RECORD1 + (data_num - 1) * RECSIZE;
	lseek(fd_out, offset, L_SET);

	sc.out.rec4.max_number = number;
	sc.type = OUT_BUFF_SIZE_TYPE;

	write(fd_out, (char *) &sc, sizeof(struct scf_out));
}

int
main()
{
	int     fd_out, DataNo;
	char    scfn[FNAME_WD], fname_wd[FNAME_WD];
	int 	number;

#ifdef SATELLITE
	resat();
	SetWorkDirSCF( get_tmpdir() );	
#endif /* SATELLITE */
	if( ModelNameSCFN( scfn ) == NULL ){
	  exit(6);
	}
	sprintf(fname_wd, "%s%s.%s", get_tmpdir(), scfn, NCS_OUT_EXTN);

	number = (int)GetScalar(0);

	if( number <= ISPP_BUFF_MAX ){
	  fprintf( stderr, "Wanning: Value(%d) is less than default(%d).\n",
		   number, ISPP_BUFF_MAX );
	  exit(0);
	}

	if ((fd_out = open(fname_wd, O_RDWR)) == FCNTL_ERROR){
	  exit(1);
	}

	if( ( DataNo = Check_buff_num( fd_out )) == 0 ){
	  fprintf( stderr, "Error:Check_buff_num()\n" );
	  exit( 290 );
	}

	Set_out_info( fd_out, DataNo, number );

	close( fd_out );

	return( 0 );
}
