/*****************************************************************************
  
	             NCS SIMULATION CONDITION SETTING COMMAND
                         SETTING OF DELAY INFORMATION 

    $Id: ndelay.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"
#include "scfdly.h"

int
main()
{
	DlyFile dly;
	char	*mdl_name, *inp_name, *str, flag;
	double	dly_time, initvalue;

#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	mdl_name = GetString(0);
	inp_name = GetString(1);
	dly_time = GetScalar(2);
	initvalue = GetScalar(3);
	str = GetString(3);

	SetWorkDirSCF( get_tmpdir() );

	if( dly_time < 0 ){
	  fprintf( stderr, "Delay time = %f\n", dly_time );
	  exit(212);
	}

	if( strcmp(str, "AUTO") == 0 || strcmp(str, "auto") == 0 ){
	  flag = SCF_DLY_FLAG_AUTO;
	} else {
	  flag = SCF_DLY_FLAG_FIX;
	}

	DlySetInfoSCF( &dly, mdl_name, inp_name, dly_time, 0, &flag );

	if( DlyWriteInfoSCF( &dly ) == FALSE ){
	  fprintf( stderr, "Module name = %s : variable name = %s\n", 
		  mdl_name, inp_name );
	  exit(71);
	};

	return( 0 );
}				/* main */
