/*****************************************************************************

                  NCS SIMULATION CONDITION ERASE COMMAND
                         ERASING OF EXTERNAL INPUTS

    $Id: nerase.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#ifdef SATELLITE 
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfxin.h"
#include "scfxfp.h"
#include "scfout.h"

/*****************************************************************************

        NERASE main function


*****************************************************************************/
int
main()
{
  	OutFile osc;
  	XinFile isc;
	int 	number = 0;
	char	*type, *all;
	int 	buff_dim;
	char 	*name = NULL;
	int     flag;
	
#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	type = GetString(0);
	all = GetString(1);
/*	if( strcmp( all, "A" ) == 0 || strcmp( all, "ALL" ) == 0 ){*/
	if( *all == 'A' ){
	  flag = SCF_ALL_MATCH;
	}else{
	  flag = FALSE;
	  number = (int)GetScalar(1);
	  name = all;
	}
			
	SetWorkDirSCF( get_tmpdir() );
	switch( *type ){
	  case 'S':
	    if( syscom.narg > 2 ){
	      number = (int)GetScalar(2); 
	    } else {
	      name = NULL;
	    }
	    XinSetInfoSCF( &isc, name, number );
	    if( XfpRemoveInfoSCF( &isc, flag ) == FALSE ){
	      exit(73);
	    };
	    break;

	  case 'O':
	    if( syscom.narg > 2 ){
	      buff_dim = (int)GetScalar(2);
	    }else{
	      buff_dim = SCF_ALL_MATCH;
	    }
	    
	    OutSetInfoSCF( &osc, number, name, buff_dim, NULL, 0, 0, NULL );
	    if( OutRemoveInfoSCF( &osc, flag ) == FALSE ){
	      exit(53);
	    }
	    break;

	  default:
	    fprintf( stderr, "Usage : NERASE " );
	    fprintf( stderr, " Stimulus/Output\n" );
	    fprintf( stderr, "               "  );
	    fprintf( stderr, " ~        ~\n" );
	    exit(100);
	    break;
	}
	return( 0 );
}
