/*****************************************************************************

                  NCS SIMULATION CONDITION SETTING COMMAND 
                          GET A PARAMETER VALUE

    $Id: ngetp.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "common.h"
#include "comlib.h"
#include "ncsdef.h"
#include "scflib.h"
#include "scfn.h"
#include "scfprm.h"


int
main()
{
	char    *module_name;
	char    *para_name;
	char	flag;
	PrmFile sc;

#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	if( ((module_name = GetString(0)) != NULL) && 
	    ((para_name = GetString(1)) != NULL ) ){
	  SetWorkDirSCF( get_tmpdir() );

	  flag = SCF_PRM_TYPE_NORMAL;
	  PrmSetInfoSCF( &sc, &flag, module_name, para_name, 0.0 );
	  if( PrmGetValueSCF( &sc ) == FALSE ){
	    exit(67);
	  } else {
	    ReturnScalar( sc.prm_val.prm_real );
	  }
	} else {
	  exit(100);
	}
	return( 0 );
}				/* main */
