/*****************************************************************************
  
             	   NCS SIMULATION CONDITION SETTING COMMAND 
                      SETTING OF INTEGRATON INFORMATION 

    $Id: ninteg.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "scflib.h"
#include "scfmat.h"

int
main()
{
	char            *integ_type;
	int             maxcell;
	int		narg;
	double		relerr;
	MatFile		sc;

	/* get syscom.temp_dir */
#ifdef SATELLITE
	resat();
	narg = syscom.narg;
#endif /* SATELLITE */

	SetWorkDirSCF( get_tmpdir() );
	if( MatGetInfoSCF( &sc, 0 ) == FALSE ){
	  exit(62);
	}

	integ_type = GetString(0);
	maxcell    = (int) GetScalar(1);
	relerr     = GetScalar(2);

	switch( *integ_type ){
	  case 'l':
	  case 'L':
	    MatIntegListupSCF( stdout );
	    break;
	  case 'E':
	  case 'F':
	  case 'R':
	    switch( narg ){
	    case 3:
	      sc.integral.relerr = relerr;
	    case 2:
	      sc.integral.maxcell = maxcell;
	    case 1:
	      sc.integral.method = *integ_type;
	      break;
	    }	/* switch */

	    if( MatWriteInfoSCF( &sc ) == FALSE ){
	      exit(61);
	    }

	    break;

	  default:
	    printf("NINTEG ... FAILED!!\n");
	    break;

	}			/* switch */

	return(0);
}				/* main() */
