/*****************************************************************************
  
                    	NCS LINKER COMMAND
  
    $Id: nlink.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "../ncs_dir.h"

#include <stdio.h>
#include <string.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"



/* If EXEC_FLAG is defined, a execution file of model is removed */
/* from current directory.                                       */
/*	NOTE: The action defined this flag actually differ.      */
/*            Now, if EXEC_FLAG is defined, the execution file   */
/*            is copied from temporary directory to current one. */
#define EXEC_FLAG      	
   
int
main()
{
	char	scf_name[FNAME_WD], scf_model[FNAME_WD];
	char	scf_lib[FNAME_WD], scf_header[FNAME_WD];
	char    dir[100];
	int     status, argc;
	char    *argv[10], *option;
	char	*flag, *lib_file_name;
	char	err_flag[8], obj_flag[8];
	char	libs[100];

#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	SetWorkDirSCF( get_tmpdir() );
	if( ModelNameSCFN( scf_name ) == NULL ){
	  exit(85);
	}
	if( GetSCFN( scf_model, scf_header, scf_lib ) == NULL ){
	  exit(85);
	}

	option = GetString(0);
	flag = GetString(1);
	if( strlen(flag) > 1 ){
	  lib_file_name=flag;
	  flag = GetString(2);
	}else{
	  lib_file_name = NULL;
	}


	argc = 0;
	fprintf( stdout, "Linking now.\n" );
	sprintf( dir, "%s/%s", NCS_BIN_DIR, NCS_LINKER );

	strargcpy( argv, argc++, dir );
	strargcpy( argv, argc++, get_tmpdir() );
	strargcpy( argv, argc++, scf_name );
	if( strlen(option) != 0 ){
	  strargcpy( argv, argc++, option );
	} else {
	  strargcpy( argv, argc++, "off" );
	}

	/* error file flag (argument 4) */
	if( (strchr(flag, 'E') != NULL) || (strchr(flag, 'N') != NULL) ){
	  strcpy( err_flag, "on" );
	}else{
	  strcpy( err_flag, "off" );
	}
	strargcpy( argv, argc++, err_flag );

	/* object file flag (argument 5) */
	if( (strchr(flag, 'O') != NULL) || (strchr(flag, 'N') != NULL) ){
	  strcpy( obj_flag, "on" );
	}else{
	  strcpy( obj_flag, "off" );
	}
	strargcpy( argv, argc++, obj_flag );

	/* usr's library file (argument 6) */
	if( lib_file_name == NULL ){
	  if( scf_lib[0] == '\0' ){
	    strargcpy( argv, argc++, "off" );
	  } else {
	    strcpy( libs, scf_lib );
	    strargcpy( argv, argc++, libs );
	  }
	} else {
	  strcpy( scf_lib, lib_file_name );
	  SetSCFN( scf_model, scf_header, scf_lib );
	  strcpy( libs, lib_file_name );
	  strargcpy( argv, argc++, libs );
	}
	  
	/* remove exec file from current directory (argument 7) */
#ifdef	EXEC_FLAG
	strargcpy( argv, argc++, "on" );
#else
	strargcpy( argv, argc++, "off" );
#endif
	
	argv[argc] = NULL;
	if( ( status = ChildProcess(argv) ) != 0 ){
	  exit(status);
	}
	exit( status );

	return( 0 );
}
