/*****************************************************************************

             	NCS SIMULATION CONDITION SETTING COMMAND 
                          SETTING OF PARAMETERS

    $Id: nlist.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "scflib.h"
#include "scfn.h"
#include "scfprm.h"

extern  void screen_out		_ANSI_ARGS_(( char *, int ));

int
main()
{
	char    *module_name;
	char	tmpfile[FNAME_WD];
	char    *tmpdir;
	FILE	*fp_tmp;
	int	row;

#ifdef SATELLITE
	read_syscom();               /* for SATELLITE */
	tmpdir = get_tmpdir();
#endif /* SATELLITE */

	module_name = GetString(0);

	/* open temprary file */
	SetWorkDirSCF( tmpdir );
	strcpy( tmpfile, tmpdir );
	strcat( tmpfile, TMPNLIST );
	if( ( fp_tmp = fopen( tmpfile, "w" ) ) == NULL ){
	  fprintf( stderr, "nlist tmp file not open." );
	  exit(1);
	}

	/* parameter get */
	row = PrmListupSCF( fp_tmp, module_name );
	fclose( fp_tmp );
	if( row > 0 ){
	  screen_out( tmpfile, row );
	}
	return( 0 );
}				/* main */
