/*****************************************************************************
  
                   COMMAND TO MAKE NCS EXECUTION FILE 
  
    $Id: nmake.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $  

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "ncs_dir.h"

#include <stdio.h>
#include <string.h>

#ifdef SATELLITE 
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"


/* If EXEC_FLAG is defined, a execution file of model is removed */
/* from current directory.                                       */
/* 	NOTE: see also nlink.c 				         */
#define EXEC_FLAG      	


static int flag_check( flags, n, num )
char *flags[];
int n;
int num;
{
  int i;

  for( i = 0; i < n; i++ ){
    if( strchr( flags[i], 'A' ) != NULL ){
      if( num == 0 ){
	return( i );
      }else{
	continue;
      }
    }
	
    if(( strlen( flags[i] ) < 2 ) &&
       (( strchr( flags[i], 'E' ) != NULL ) ||
	( strchr( flags[i], 'O' ) != NULL ) ||
	( strchr( flags[i], 'N' ) != NULL ))){
      if( num == 2 ){
	return( i );
      }else{
	continue;
      }
    }

    return( i );
  }
  return( 10 );
}

int
main()
{
	char	scf_name[FNAME_WD],scf_model[FNAME_WD];
	char	scf_lib[FNAME_WD], scf_header[FNAME_WD];
	int     status, argc = 0;
	char    *argv[10], dir[100], op[100];
	char    *flags[3];
	int	f_pos;
	char	err_flag[8], obj_flag[8];
	int     nargs=0;

#ifdef SATELLITE
	resat();
	nargs = syscom.narg;
#endif /* SATELLITE */

	SetWorkDirSCF( get_tmpdir() );
	if( ModelNameSCFN( scf_name ) == NULL ){
	  exit(85);
	}
	if( GetSCFN( scf_model, scf_header, scf_lib ) == NULL ){
	  exit(85);
	}

	flags[0] = GetString(0);
	flags[1] = GetString(1);
	flags[2] = GetString(2);

	/* Preprocessor */
	argc = 0;
	if( ( f_pos = flag_check( flags, nargs, 0 ) ) < 3 ){
	  fprintf( stderr, "Now, this option can't available.\n" );
	  exit(100);
	}else{
	  sprintf( dir, "%s/%s", NCS_BIN_DIR, NCS_PREPRO );
	}
	strargcpy( argv, argc++, dir );

	argv[argc] = NULL;
	status = ChildProcess( argv );
	if( status != 0 ){
	  exit(status);
	}

	/* C Compile & Linking */
	argc = 0;
	fprintf( stdout, "Linking now.\n" );
	sprintf(dir, "%s/%s", NCS_BIN_DIR, NCS_LINKER);

	strargcpy( argv, argc++, dir );
	strargcpy( argv, argc++, get_tmpdir() );
	strargcpy( argv, argc++, scf_name );

	/* Compile & Link option (argument 3)*/
	if( ( f_pos = flag_check( flags, nargs, 1 ) ) < 3 ){
	  strcpy( op, flags[f_pos] );
	  strargcpy( argv, argc++, op );
	}else{
	  strargcpy( argv, argc++, "off" );
	}

	/* error file flag (argument 4) */
	if(((f_pos = flag_check( flags, nargs, 2 )) < 3 ) &&
	   ((strchr(flags[f_pos],'E')!= NULL)||
	    (strchr(flags[f_pos],'N') != NULL))){
	  strcpy( err_flag, "on" );
	}else{
	  strcpy( err_flag, "off" );
	}
	strargcpy( argv, argc++, err_flag );

	/* object file flag (argument 5) */
	if( ((f_pos = flag_check( flags, nargs, 2 )) < 3 ) &&  
	    ((strchr(flags[f_pos], 'O') != NULL) || 
	     (strchr(flags[f_pos], 'N') != NULL)) ){
	  strcpy( obj_flag, "on" );
	}else{
	  strcpy( obj_flag, "off" );
	}
	strargcpy( argv, argc++, obj_flag );

	/* usr's library file (argument 6) */
	if( scf_lib[0] != '\0' ){
	  strargcpy( argv, argc++, scf_lib );
	} else {
	  strargcpy( argv, argc++, "off" );
	}

	/* remove exec file from current directory (argument 7) */
#ifdef	EXEC_FLAG
	strargcpy( argv, argc++, "on" );
#else
	strargcpy( argv, argc++, "off" );
#endif

	argv[argc] = NULL;
	status = ChildProcess(argv);
	exit(status);

	return( 0 );
}
