/*****************************************************************************
  
         	NCS SIMULATION CONDITION SETTING COMMAND
                          SETTING OF OUTPUTS 

    $Id: nout.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $
  
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#ifndef HAVE_STDLIB_H
#include <malloc.h>
#else
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#endif /* HAVE_MALLOC_H */

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "common.h"
#include "comlib.h"
#include "ncsdef.h"
#include "scflib.h"
#include "scfn.h"
#include "scfout.h"
#include "scfobs.h"

int
main()
{
	int	buf_id, comp_no, type;
	char	*mdl_name, *obs_name;
	int     buf_dim;
	char	*tmp;
	char  	*buf_name;
	OutFile out_info;
	ObsFile obs_info;

	resat();


	buf_id = (int)GetScalar(0);
	buf_name = GetString(0);
	tmp = GetArgType(1);
	if( strcmp( "string", tmp ) == 0 ){
	  buf_dim = 0;
	  mdl_name = GetString(1);
	  comp_no = (int)GetScalar(2);
	  type = (int)GetScalar(3);
	  obs_name = GetString(4);

	  if( type < 3 && syscom.narg > 4 ){
	    exit(292);
	  }

	  if( syscom.narg == 4 && type == 3) {
	    printf("Observable : ");
	    scanf( "%s", obs_name );
	  }
	}else{
	  buf_dim = (int)GetScalar(1);
	  mdl_name = GetString(2);
	  comp_no = (int)GetScalar(3);
	  type = (int)GetScalar(4);
	  obs_name = GetString(5);

	  if( type < 3 && syscom.narg > 5 ){
	    exit(292);
	  }

	  if (syscom.narg == 5 && type == 3) {
	    printf("Observable : ");
	    scanf("%s", obs_name);
	  }
	}

	if( buf_id == 0 ){
	  fprintf( stderr, "\'%s\' not buffer\n", buf_name );
	  exit(216);
	}

	if( type > 3 ){
	  exit( 212 );
	}

	SetWorkDirSCF( get_tmpdir() );

	if( type == 3 ){
	  if( ObsSetInfoSCF( &obs_info, mdl_name, comp_no, obs_name )
	      == FALSE ){
	    exit( 56 );
	  }
	  if( ObsSearchInfoSCF( &obs_info ) < 0 ){
	    fprintf( stderr, "Module: %s, Variable: %s\n", 
		     mdl_name, obs_name );
	    exit( 58 );
	  }
	}
	if( OutSetInfoSCF( &out_info, buf_id, buf_name, buf_dim, 
			   mdl_name, comp_no, type, obs_name ) == FALSE ){
	  exit( 51 );
	}
	if( OutWriteInfoSCF( &out_info ) == FALSE ){
	  exit( 52 );
	}

	return( 0 );
}
