/*****************************************************************************

             	NCS SIMULATION CONDITION SETTING COMMAND 
                          SETTING OF PARAMETERS

    $Id: npara.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#ifdef SATELLITE 
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"
#include "scfprm.h"

int
main()
{
	char	*mdl_name, *prm_name, flag;
	char	*tmpdir;
	double	prm_real;
	PrmFile	prm;

#ifdef SATELLITE
	resat();
	tmpdir = get_tmpdir();
#endif /* SATELLITE */


	mdl_name = GetString(0);
	prm_name = GetString(1);
	prm_real = GetScalar(2);

	SetWorkDirSCF( tmpdir );
	flag = SCF_PRM_TYPE_NORMAL;
	PrmSetInfoSCF( &prm, &flag, mdl_name, prm_name, prm_real );
	if( PrmWriteInfoSCF( &prm ) == FALSE ){
	  fprintf( stderr, "Can't Find the Parameter[%s:%s]\n", 
		  mdl_name, prm_name );
	  exit(61); 
	}

	return( 0 );
}				/* end of main */
