/*****************************************************************************

             	NCS SIMULATION CONDITION DISPLAY COMMAND
                    CONTENTS OF SIMULATION CONDITIONS

    $Id: nsclst.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "ncssscf.h"

#define or	: case

extern  void screen_out		_ANSI_ARGS_(( char *, int ));


/*****************************************************************************

             NCS SIMULATION CONDITION DSPLAY COMMAND 
                      MAIN FUNCTION

on UNIX                                      05/07/1990 CODED BY S.Hitomi
*****************************************************************************/
int 
main()
{
	char	*type;
	char	tmpfile[FNAME_WD];
	FILE	*fp_tmp;
	int	row = 0;
	char    scfn[FNAME_WD];
	char    fname[FNAME_WD];

#ifdef SATELLITE
	resat();
#endif

	type = GetString(0);

	if( syscom.narg != 1 ){
	  *type = 99;
	}

	/* open temprary file */
	strcpy( tmpfile, get_tmpdir() );
	strcat( tmpfile, TMPNLIST );
	if( ( fp_tmp = fopen( tmpfile, "w" ) ) == NULL ){
	  fprintf( stderr, "nlist tmp file not open." );
	  exit(1);
	}

	/* make file name */
	SetWorkDirSCF( get_tmpdir() );
	if( ModelNameSCFN( scfn ) == NULL ){
	  exit(6);
	}

	switch( *type ){
	  case '1' or 's' or 'S':
	    row = XfpListupAllSCF( fp_tmp );
	    break;

	  case '2' or 'o' or 'O':
	    sprintf( fname,"%s%s.%s", get_tmpdir(), scfn, SCF_OUT_EXTN );
	    row = OutListupSCF( fp_tmp );
	    break;

	  case '3' or 't' or 'T':
	    row = MatTimeListupSCF( fp_tmp );
	    break;

	  case '4' or 'd' or 'D':
	    row = DlyListupSCF( fp_tmp );
	    break;

	  case '5' or 'i' or 'I':
	    row = MatIntegListupSCF( fp_tmp );
	    break;

	  case '6' or 'b' or 'B':
	    row = ObsListupSCF( fp_tmp );
	    break;

	  default:
	    fprintf( stderr, "Usage : NSCLST " );
	    fprintf( stderr, " Stimulus/Output/Timer/Delay/Integration\n" );
	    fprintf( stderr, "               "  );
	    fprintf( stderr, " ~        ~      ~     ~     ~\n" );
	    break;
	}
	fclose( fp_tmp );
	if( row > 0 ){
	  screen_out( tmpfile, row );
	}

	return( 0 );

}				/* main() */
