/*****************************************************************************

                 NCS SIMULATION CONDITION SETTING COMMAND 
                         SETTING OF EXTERNAL INPUTS

    $Id: nstim.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /*SATELLLITE */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"
#include "scflib.h"
#include "scfn.h"
#include "scfxin.h"
#include "scfxfp.h"


int
ncs_get_p( type, val, fname, buff_name )
char 	type;
double  val[];
char    *fname;
char	*buff_name;
{
        float  d;
	switch( type ){
	  case 'P':
	    printf(" Start time    : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[0] = d;
	    printf(" Initial Value : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[1] = d;
	    printf(" Height        : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[2] = d;
	    printf(" Width         : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[3] = d;
	    printf(" Period        : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[4] = d;
	    break;
	  case 'R':
	    printf(" Start time    : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[0] = d;
	    printf(" Initial Value : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[1] = d;
	    printf(" Gradient      : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[2] = d;
	    break;
	  case 'F':
	    fname[0] = EOS;
	    while( strlen( fname ) == 0 ){
	      printf(" File name     : ");
	      INPUT( FNAME_WD, fname, NULL, NULL ); 
	    }
	    printf("Buffer number  : ");
	    INPUT( FNAME_WD, NULL, NULL, &d ); 
	    val[1] = d;
	    break;
	  case 'B':
	    printf("can't set series object");
	    return( ERROR );
	    break;
	  default:
	    return( ERROR );
	}
	return( SUCCESS );
}



/***************************************************************
   argc : 3 + 3 or 5
   argv[0]: nstim
   argv[1]: Module name
   argv[2]: Compornent No.
   argv[3]: Function  ( R: Ramp, P: Pulse, F: File, B: Buffer )

   argv[4]: start time of input
   argv[5]: initial value of input
   argv[6]: [R]gradient, [P]height
   argv[7]: [R]null,     [P]width
   argv[8]:              [P]period
   argv[9]:              [P]null
***************************************************************/
int
main()
{
	char           *mdl_name, infile[FNAME_WD], *type;
	int             i, comp_no;
	double          val[5];
	char            *buf_name=NULL;
	char		*buf_time=NULL;
	XinFile		sc_xin;
	XfpFile		sc_xfp;

#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	mdl_name = GetString(0);
	comp_no = (int) GetScalar(1);
	type = GetString(2);
	for( i = 0; i < 5; i++ ){
	  val[i] = GetScalar(3 + i);
	}

	if( strcmp(type,"B") == 0 ){
	  buf_name = GetString(3);
	  if( val[0] == 0 ){
	    fprintf( stderr, "BUFFER(%s : number = %d);", 
		    buf_name, (int)val[0] );
	    exit(216);
	  }
	  buf_time = GetString(4);
	  if( digit_or_not(buf_time) == TRUE ){
	    buf_time = GetString(5);
	    if( digit_or_not(buf_time) == TRUE ){
	      buf_time[0] = '\0';
	    }
	  }else{
	    val[2] = val[1];
	    val[1] = 0;
	  }
	}
	

	if( syscom.narg == 3 ){
	  ncs_get_p( *type, val, infile );
	}

 	SetWorkDirSCF( get_tmpdir() );
  
 	XinSetInfoSCF( &sc_xin, mdl_name, comp_no );
 	XfpSetInfoSCF( &sc_xfp, type, val, infile, buf_name, buf_time );
 	XfpSetStimSCF( &sc_xin, &sc_xfp );
  
	return( 0 );

}				/* main */
