/*****************************************************************************

                   NCS SIMULATION CONDITION SETTING COMMAND 
                        SETTING OF SIMULATION TIMER

    $Id: ntime.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef SATELLITE
#include "SL_macro.h"
#include "SL_cmd.h"
#endif /* SATELLITE */

#include "ncsdef.h"
#include "common.h"
#include "scflib.h"
#include "scfmat.h"


int
main()
{
  	int		i;
	MatFile		sc;

#ifdef SATELLITE
	resat();
#endif /* SATELLITE */

	SetWorkDirSCF( get_tmpdir() );
	if( MatGetInfoSCF( &sc, 0 ) == FALSE ){
	  exit(62);
	}

	if( sc.type == SCF_MAT_TYPE_NORMAL ){
	  for( i = 0; i < 4; i++ ){
	    sc.timer.sim_timer[i] = GetScalar(i);
	  }
	  if( sc.timer.sim_timer[3] == 0 ){
	    sc.timer.sim_timer[3] = sc.timer.sim_timer[2];
	  }
	}
	if( sc.timer.sim_timer[2] < sc.timer.sim_timer[1] ){
	  exit(100);
	}
	if( MatWriteInfoSCF( &sc ) == FALSE ){
	  exit(61);
	}

	return( 0 );
}				/* main() */
