/*****************************************************************************

             Functions to Dispaly Screen 

    $Id: screen.c,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif 
#include <unistd.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <string.h>
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#endif /* HAVE_TERMCAP_H */

#include "ncsdef.h"
#include "common.h"
#include "comlib.h"

#define DEFAULT_TERM	"unknown"
#define PAGER_DEFAULT	"more"

/*
 *	Display parameter
 */
void screen_out( filename, row )
char 	*filename;
int 	row;
{
  	static char *argv[3] = {PAGER_DEFAULT};
  	int status;
	char *pager;
	char termbuf[2048];
	char *term;
	register int hard;
	int wrow;
	char *s;

	/* Find out what kind of terminal this is. */
	if ((term = getenv("TERM")) == NULL){
	  term = DEFAULT_TERM;
	}
	if (tgetent(termbuf, term) <= 0){
	  strcpy(termbuf, "dumb:hc:");
	}

	hard = tgetflag("hc");

	/* Get size of output screen */
	if ((s = getenv("LINES")) != NULL){
	  wrow = atoi(s);
	}else{
	  wrow = tgetnum("li");
	}

	/* Check size of output screen */
	if( row > wrow ){
	  /* Use pager to display parameter */
	  if( ( pager = getenv("PAGER") ) != NULL ){
	    argv[0] = pager;
	  }
	  argv[1] = filename;
	  argv[2] = NULL;
	  if( ( status = ChildProcess( argv ) ) != 0 ){
	    exit( status );
	  }
	}else{
	  /* Use 'cat' command to display parameter */
	  argv[0] = strdup( "cat" );
	  argv[1] = filename;
	  argv[2] = NULL;
	  if( ( status = ChildProcess( argv ) ) != 0 ){
	    exit( status );
	  }
	  free( argv[0] );
	}
}
 
