#!/bin/sh
#   Filter for model file with/without network description
#      arg1 : output file name
#      arg2 : temporary file name
#	
#     $Id: npp_filter.sh,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $
#
predescription()
{
  echo "/***   Network description   ***/" >> "$1"
  echo "type:           NETWORK;"  >> "$1"
  echo "module:         SYSTEM;" >> "$1"
  echo "cell:           $2[1];" >> "$1"
  echo "connection:" >> "$1"
  echo "                $2[0] < ();" >> "$1"
  echo "                end;" >> "$1"
  echo " " >> "$1"
  echo "/***   Single module description   ***/" >> "$1"
  echo "type:           CELL;" >> "$1"
}

FLAG=off
export FLAG

while read line
do
  if [ "$line" ]; then
    top=`echo ${line} | sed 's/[\t ]*:.*$/:/'`
    sentence=`echo ${line} | sed 's/ *;.*$//'`
    sentence=`echo ${sentence} | sed 's/.*: *//'`
  else
    top=""
    sentence=""
  fi

  if [ "$FLAG" = "off" ] && [ "${top}" = "type:" ] && [ "${sentence}" = "NETWORK" ] ; then
	FLAG=on
	break
  fi

  if [ "$FLAG" = "off" ] && [ -z "${MODULE}" ] && [ "${top}" = "module:" ] ; then
	MODULE=${sentence}
	break
  fi
done

if [ "$FLAG" = "off" ]; then
    if [ -n "${MODULE}" ]; then
	predescription $1 ${MODULE}
	echo "1" > $2
    else
	echo 1
        echo "-1" > $2
	rm "$1"
	exit 1
    fi
else
echo "0" > $2
fi

echo 0
exit 0
