#!/bin/sh
#   Filter for model file with/without network description
#      arg1 : model source file name
#      arg2 : path name of NCS module
#      arg3 : output file name
#      arg4 : temporary file name.
#
#     $Id: nspp.sh,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $
#
if [ -f $3 ]; then
    rm $3
fi
if [ -f $4 ]; then
    rm $4
fi

if [ -f $1 ]; then
    if [ -r $1 ]; then
	ret=`cat -v $1 | $2/npp_filter.sh $3 $4`
    else
        echo "Model file ($1) is not read"
	exit 1
    fi
else
    echo "Model file ($1) is not found"
    exit 1
fi

if [ $ret = 1 ] ; then
    echo "Module name is not found"
    exit 1
else
    cat "$1" >> "$3"
fi

exit 0

