/**************************************************
**  NPEinit.c                                    **
**  command  : npeinit                           **
**  function : initialization of npe common area **
**************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "NPEcmd.h"

#if !defined(NPECOMMONAREA)
#define NPECOMMONAREA   "/npecommon.area"
#endif

int main(void)
{
  FILE  *fp;
  char  string[MAXLINE];

  read_syscom();
  strcpy( string, syscom.temp_dir );
  strcat( string, NPECOMMONAREA   );
  if( (fp=fopen( string, "w" )) == NULL ) {
    exit( 14 );
  }
  fprintf( fp, "%d\n",TRUE ); /* write flag  */
  fclose( fp );

  if( (fp=fopen( NEWS, "r" )) == NULL ) {
    puts( "\tThere is No News, today." );
    return( 0 );
  }
  while( fgets( string, MAXLINE, fp ) != NULL ) {
    printf( "%s", string );
  }
  return( 0 );
}
