/*****************************************************************
**  NPEload.c                                                   **
**  command  : cload                                            **
**  function : load configuration file for parameter estimation **
**             which is generated by "cstore" command           **
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "NPEcmd.h"
#include "global_vars.h"

/*  global vars in this file */
extern int   StoreFlag; /* defined in common1.c  */

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
extern void renpe_(char *filename);
extern void wrnpe_(char *filename, int storeflag);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
extern void renpe_();
extern void wrnpe_();

#endif

int main()
{
  char  buf[BUFSIZ];
  char  *p_char;

  read_syscom();
  p_char = GetString(0);

  renpe();
  if( StoreFlag == FALSE ) {
    fprintf( stderr, "Estimation Conditions has been Modified. OK? (y/n) :" );
    if(fgets(buf, BUFSIZ, stdin) != NULL){
      if((buf[0] != 'Y')&&(buf[0] != 'y')){
        fprintf( stderr, "Try again.\n" );
        return(0);
      }
    } else {
      fprintf(stderr, "Illegal input.\n");
      return(0);
    }
  }
  renpe_( p_char );
  printf( "[%s]=>[NPE Common Area]\n", p_char );

  p_char[0] = '\0';
  wrnpe_( p_char, TRUE );

  initHead();
  return(0);
}
