/*******************************************
**  NPEstore.c                            **
**  command  : cstore                     **
**  function : save estimation conditions **
*******************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <unistd.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
extern void wrnpe_(char *filename, int storeflag);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
extern void wrnpe_();

#endif

int main(void)
{
  char  buf[BUFSIZ];
  char *p_char;


  read_syscom();
  p_char = GetString(0);
  renpe();

  if( access( p_char, 0 ) == 0 ) { /* --> exist(p_char) ? */
    fprintf( stderr, "%s exists. Overwite? (y/n) :", p_char );
    if(fgets(buf, BUFSIZ, stdin) != NULL){
      if((buf[0] != 'Y')&&( buf[0] != 'y')) {
        fprintf( stderr, "Try again.\n" );
        return(0);
      }
    } else {
        fprintf(stderr, "Illegal input.\n");
        return(0);
    }
  }

  printf( "[NPE Common Area]=>[%s]\n", p_char );

  wrnpe_( p_char, TRUE); /* second argument is necessary? */
  initHead();
  return( 0 );
}
