/*************************************************
**  delblock.c                                  **
**  command  : cdel                             **
**  function : delete one estimation condition  **
**             from npe common area.            **
*************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <string.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

/* function protypes in this file */
#if defined(ANSI)
void  delMethod( void );
void  delLSearch( void );
void  delModel(void );
void  delPenalty(void );
void  delInit( void );
void  delScale( void );
void  delTerm( void );
void  delNumber( void );
void  delPoint( void );
void  delData( void );
void  delWeight( void );
void  delResult( void );
void  delHistory( void );
void  delXinteg( void );
void  delDisp( void );
void  delNorm( void );
void  delBlock( int num );
int   getElmntType( char *cp );
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);

#else
void  delMethod();
void  delLSearch();
void  delModel();
void  delPenalty();
void  delInit();
void  delScale();
void  delTerm();
void  delNumber();
void  delPoint();
void  delData();
void  delWeight();
void  delResult();
void  delHistory();
void  delXinteg();
void  delDisp();
void  delNorm();
void  delBlock();
int  getElmntType();
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();

#endif /* ANSI */

#define BUFS  64
/******************** MAIN ********************/
int  main()
{
  int   i;
  char  *Type_str, buf[BUFS];

  renpe();

  read_syscom();

  Type_str = GetString(0);
  for(i=0; i<strlen(Type_str); i++)
    buf[i] = tolower(Type_str[i]);
  buf[strlen(Type_str)] = '\0';
  Type_str = buf;

  switch(getElmntType( Type_str )){
    case METHOD  : delMethod();   break;
    case LSEARCH : delLSearch();  break;
    case MODEL   : delModel();    break;
    case PENALTY : delPenalty();  break;
    case INIT    : delInit();     break;
    case SCALE   : delScale();    break;
    case TERM    : delTerm();     break;
    case NUMBER  : delNumber();   break;
    case POINT   : delPoint();    break;
    case DATA    : delData();     break;
    case WEIGHT  : delWeight();   break;
    case RESULT  : delResult();   break;
    case HISTORY : delHistory();  break;
    case XINTEG  : delXinteg();   break;
    case DISPLAY : delDisp();     break;
    case NORM    : delNorm();     break;
    case BLOCK   : delBlock(1);   break;
    default      : 
      printf("Unknown condition [%s]\n", Type_str);
      break;
  }
  wrnpe();
  initHead();
  return(0);
}


void delMethod( void )
{
  if( MethodHead == NULL ) return;

  free(MethodHead->fname);
  free(MethodHead);
  MethodHead = NULL;
}


void  delLSearch( void )
{
  if( LsearchHead == NULL ) return;

  free(LsearchHead->fname);
  free(LsearchHead);
  LsearchHead = NULL;
}


void  delModel(void )
{
  if( ModelHead == NULL ) return;

  switch( ModelHead->type ){
    case USR : free(ModelHead->inform.Usr.fname); break;
    case NCS : free(ModelHead->inform.Ncs.fname); break;
  }
  free(ModelHead);
  ModelHead = NULL;
}



void  delPenalty( void )
{
  if( PenaltyHead == NULL ) return;

  free(PenaltyHead->fname);
  free(PenaltyHead);
  PenaltyHead = NULL;
}



void  delInit( void )
{
  void  freeEstParam(struct estparam *wp); /* common1.c */

  if( InitHead == NULL ) return;

  freeEstParam(InitHead->EstParam);
  free(InitHead);
  InitHead = NULL;
}



void  delScale( void )
{
  if( ScaleHead == NULL ) return;

  free(ScaleHead);
  ScaleHead = NULL;
}


void  delTerm( void )
{
  void freeTermCrite(struct termcrite *wp); /* common1.c */

  if( TermHead == NULL ) return;

  free(TermHead->logic);
  freeTermCrite(TermHead->TermCrite);
  free(TermHead);
  TermHead = NULL;
}



void  delNumber( void )
{
  if( NumberHead == NULL ) return;

  free(NumberHead);
  NumberHead = NULL;
}



void  delPoint( void )
{
  if( PointHead == NULL ) return;

  free(PointHead);
  PointHead = NULL;
}


void  delData( void )
{
  if( ExperimentHead == NULL ) return;

  free(ExperimentHead->fname);
  free(ExperimentHead);
  ExperimentHead = NULL;
}


void  delWeight( void )
{
  if( WeightHead == NULL ) return;

  free(WeightHead->fname);
  free(WeightHead);
  WeightHead = NULL;
}



void  delResult( void )
{
  if( ResultHead == NULL ) return;

  free(ResultHead->fname);
  free(ResultHead);
  ResultHead = NULL;
}


void  delHistory( void )
{
  if( HistoryHead == NULL ) return;

  free(HistoryHead->fname);
  free(HistoryHead);
  HistoryHead = NULL;
}


void  delXinteg( void )
{
  if( XintegHead == NULL ) return;

  free(XintegHead);
  XintegHead = NULL;
}


void  delDisp( void )
{
  if( DisplayHead == NULL ) return;

  free(DisplayHead);
  DisplayHead = NULL;
}


void  delNorm( void )
{
  if( NormHead == NULL ) return;

  free(NormHead);
  NormHead = NULL;
}


void  delBlock( int num )
{
  int i;
  Block    *work, *workbefore = NULL;
  int  freeElement(struct element *wp);

  if( BlockHead == NULL ){ 
    exit( 300 );
  }

  if( num == 0 ){
    printf( " Set Number : " );
    scanf( "%d", &num );
  }

  if( num == 1){
    work = BlockHead;
    BlockHead = BlockHead->next;
    freeElement(work->Element);
    free(work);
  } else {
    work=BlockHead;
    for(i = 1; i< num ; i++ ){
      if( work->next == NULL ){
        exit( 301 );
      }
      workbefore = work;
      work = work->next;
    }
    workbefore->next = work->next;
    freeElement(work->Element);
    free(work);
  }
}



#if !defined(EL_TYPE_MDL)
#define  EL_TYPE_MDL  3
#endif

int  getElmntType(char *cp )
{
  if(cp == NULL) return(-1);
  if(strncmp(cp,"data",EL_TYPE_MDL)==0)    return( DATA );
  if(strncmp(cp,"display",EL_TYPE_MDL)==0) return( DISPLAY );
  if(strncmp(cp,"history",EL_TYPE_MDL)==0) return( HISTORY );
  if(strncmp(cp,"init",EL_TYPE_MDL)==0)    return( INIT );
  if(strncmp(cp,"integ",EL_TYPE_MDL)==0)   return( XINTEG );
  if(strncmp(cp,"lsearch",EL_TYPE_MDL)==0) return( LSEARCH );
  if(strncmp(cp,"method",EL_TYPE_MDL)==0)  return( METHOD );
  if(strncmp(cp,"model",EL_TYPE_MDL)==0)   return( MODEL );
  if(strncmp(cp,"norm",EL_TYPE_MDL)==0)    return( NORM );
  if(strncmp(cp,"number",EL_TYPE_MDL)==0)  return( NUMBER );
  if(strncmp(cp,"penalty",EL_TYPE_MDL)==0) return( PENALTY );
  if(strncmp(cp,"point",EL_TYPE_MDL)==0)   return( POINT );
  if(strncmp(cp,"result",EL_TYPE_MDL)==0)  return( RESULT );
  if(strncmp(cp,"set",EL_TYPE_MDL)==0)     return( BLOCK );
  if(strncmp(cp,"scale",EL_TYPE_MDL)==0)   return( SCALE );
  if(strncmp(cp,"term",EL_TYPE_MDL)==0)    return( TERM );
  if(strncmp(cp,"weight",EL_TYPE_MDL)==0)  return( WEIGHT );
  return( -1 );
}

/* --- end of delblock.c --- */
